/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.util;

import java.util.concurrent.Semaphore;
import org.slf4j.Logger;

public class SegmentRefreshSemaphore {
    private final Semaphore _semaphore;

    public SegmentRefreshSemaphore(int permits, boolean fair) {
        this._semaphore = permits > 0 ? new Semaphore(permits, fair) : null;
    }

    public void acquireSema(String segmentName, Logger logger) throws InterruptedException {
        if (this._semaphore != null) {
            long startTime = System.currentTimeMillis();
            logger.info("Waiting for lock to refresh : {}, queue-length: {}", (Object)segmentName, (Object)this._semaphore.getQueueLength());
            this._semaphore.acquire();
            logger.info("Acquired lock to refresh segment: {} (lock-time={}ms, queue-length={})", new Object[]{segmentName, System.currentTimeMillis() - startTime, this._semaphore.getQueueLength()});
        } else {
            logger.info("Locking of refresh threads disabled (segment: {})", (Object)segmentName);
        }
    }

    public void releaseSema() {
        if (this._semaphore != null) {
            this._semaphore.release();
        }
    }
}

