/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.util.trace;

import org.apache.pinot.core.util.trace.TraceContext;
import org.apache.pinot.spi.trace.BaseRecording;
import org.apache.pinot.spi.trace.InvocationRecording;
import org.apache.pinot.spi.trace.InvocationScope;
import org.apache.pinot.spi.trace.NoOpRecording;
import org.apache.pinot.spi.trace.Tracer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuiltInTracer
implements Tracer {
    private static final Logger LOGGER = LoggerFactory.getLogger(BuiltInTracer.class);

    public void register(long requestId) {
        TraceContext.register(requestId);
    }

    public void unregister() {
        TraceContext.unregister();
    }

    public InvocationScope createScope(Class<?> operatorClass) {
        return TraceContext.traceEnabled() ? new MilliTimeSpan(operatorClass) : NoOpRecording.INSTANCE;
    }

    public InvocationRecording activeRecording() {
        return NoOpRecording.INSTANCE;
    }

    private static final class MilliTimeSpan
    extends BaseRecording
    implements InvocationScope {
        private final long _startTimeMillis = System.currentTimeMillis();
        private final Class<?> _operator;

        public MilliTimeSpan(Class<?> operator) {
            super(true);
            this._operator = operator;
        }

        public void close() {
            String operatorName = this._operator.getSimpleName();
            long duration = System.currentTimeMillis() - this._startTimeMillis;
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Time spent in {}: {}", (Object)operatorName, (Object)duration);
            }
            TraceContext.logTime(operatorName, duration);
        }

        public void close(Object context) {
            String operatorName = this._operator.getSimpleName();
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Context collected for {}: {}", (Object)operatorName, context);
            }
            TraceContext.logInfo(operatorName, context);
        }
    }
}

