/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.auth;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.apache.pinot.spi.auth.AuthorizationResult;

public class TableAuthorizationResult
implements AuthorizationResult {
    private static final TableAuthorizationResult SUCCESS = new TableAuthorizationResult(Set.of());
    private final Set<String> _failedTables;

    public TableAuthorizationResult(Set<String> failedTables) {
        this._failedTables = failedTables;
    }

    public static TableAuthorizationResult success() {
        return SUCCESS;
    }

    @Override
    public boolean hasAccess() {
        return this._failedTables.isEmpty();
    }

    public Set<String> getFailedTables() {
        return this._failedTables;
    }

    @Override
    public String getFailureMessage() {
        if (this.hasAccess()) {
            return "";
        }
        ArrayList<String> failedTablesList = new ArrayList<String>(this._failedTables);
        Collections.sort(failedTablesList);
        return "Authorization Failed for tables: " + failedTablesList;
    }
}

