/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.config.table;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.util.Map;
import org.apache.pinot.spi.config.BaseJsonConfig;
import org.apache.pinot.spi.config.table.HashFunction;

public class DedupConfig
extends BaseJsonConfig {
    @JsonPropertyDescription(value="Whether dedup is enabled or not.")
    private final boolean _dedupEnabled;
    @JsonPropertyDescription(value="Function to hash the primary key.")
    private final HashFunction _hashFunction;
    @JsonPropertyDescription(value="Custom class for dedup metadata manager. If not specified, the default implementation ConcurrentMapTableDedupMetadataManager will be used.")
    private final String _metadataManagerClass;
    @JsonPropertyDescription(value="Custom configs for dedup metadata manager.")
    private final Map<String, String> _metadataManagerConfigs;
    @JsonPropertyDescription(value="When larger than 0, use it for dedup metadata cleanup, it uses the same unit as the dedup time column. The metadata will be cleaned up when the dedup time is older than the current time minus metadata TTL. Notice that the metadata may not be cleaned up immediately after the TTL, it depends on the cleanup schedule.")
    private final double _metadataTTL;
    @JsonPropertyDescription(value="Time column used to calculate dedup metadata TTL. When it is not specified, the time column from the table config will be used.")
    private final String _dedupTimeColumn;
    @JsonPropertyDescription(value="Whether to preload segments for fast dedup metadata recovery")
    private boolean _enablePreload;

    public DedupConfig(@JsonProperty(value="dedupEnabled", required=true) boolean dedupEnabled, @JsonProperty(value="hashFunction") HashFunction hashFunction) {
        this(dedupEnabled, hashFunction, null, null, 0.0, null, false);
    }

    @JsonCreator
    public DedupConfig(@JsonProperty(value="dedupEnabled", required=true) boolean dedupEnabled, @JsonProperty(value="hashFunction") HashFunction hashFunction, @JsonProperty(value="metadataManagerClass") String metadataManagerClass, @JsonProperty(value="metadataManagerConfigs") Map<String, String> metadataManagerConfigs, @JsonProperty(value="metadataTTL") double metadataTTL, @JsonProperty(value="dedupTimeColumn") String dedupTimeColumn, @JsonProperty(value="enablePreload") boolean enablePreload) {
        this._dedupEnabled = dedupEnabled;
        this._hashFunction = hashFunction == null ? HashFunction.NONE : hashFunction;
        this._metadataManagerClass = metadataManagerClass;
        this._metadataManagerConfigs = metadataManagerConfigs;
        this._metadataTTL = metadataTTL;
        this._dedupTimeColumn = dedupTimeColumn;
        this._enablePreload = enablePreload;
    }

    public HashFunction getHashFunction() {
        return this._hashFunction;
    }

    public boolean isDedupEnabled() {
        return this._dedupEnabled;
    }

    public String getMetadataManagerClass() {
        return this._metadataManagerClass;
    }

    public Map<String, String> getMetadataManagerConfigs() {
        return this._metadataManagerConfigs;
    }

    public double getMetadataTTL() {
        return this._metadataTTL;
    }

    public String getDedupTimeColumn() {
        return this._dedupTimeColumn;
    }

    public boolean isEnablePreload() {
        return this._enablePreload;
    }

    public void setEnablePreload(boolean enablePreload) {
        this._enablePreload = enablePreload;
    }
}

