/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.config.table;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Map;
import org.apache.pinot.spi.config.BaseJsonConfig;

public class TableTaskConfig
extends BaseJsonConfig {
    private final Map<String, Map<String, String>> _taskTypeConfigsMap;
    public static final String MINION_ALLOW_DOWNLOAD_FROM_SERVER = "allowDownloadFromServer";
    public static final boolean DEFAULT_MINION_ALLOW_DOWNLOAD_FROM_SERVER = false;

    @JsonCreator
    public TableTaskConfig(@JsonProperty(value="taskTypeConfigsMap", required=true) Map<String, Map<String, String>> taskTypeConfigsMap) {
        Preconditions.checkArgument((taskTypeConfigsMap != null ? 1 : 0) != 0, (Object)"'taskTypeConfigsMap' must be configured");
        this._taskTypeConfigsMap = taskTypeConfigsMap;
    }

    @JsonProperty
    public Map<String, Map<String, String>> getTaskTypeConfigsMap() {
        return this._taskTypeConfigsMap;
    }

    public boolean isTaskTypeEnabled(String taskType) {
        return this._taskTypeConfigsMap.containsKey(taskType);
    }

    public Map<String, String> getConfigsForTaskType(String taskType) {
        return this._taskTypeConfigsMap.get(taskType);
    }
}

