/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.config.table.ingestion;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.pinot.spi.config.BaseJsonConfig;

public class SchemaConformingTransformerConfig
extends BaseJsonConfig {
    @JsonPropertyDescription(value="Enable indexable extras")
    private boolean _enableIndexableExtras = true;
    @JsonPropertyDescription(value="Name of the field that should contain extra fields that are not part of the schema.")
    private String _indexableExtrasField = "json_data";
    @JsonPropertyDescription(value="Enable unindexable extras")
    private boolean _enableUnindexableExtras = true;
    @JsonPropertyDescription(value="Like indexableExtrasField except it only contains fields with the suffix in unindexableFieldSuffix.")
    private String _unindexableExtrasField = "json_data_no_idx";
    @JsonPropertyDescription(value="The suffix of fields that must be stored in unindexableExtrasField")
    private String _unindexableFieldSuffix = "_noindex";
    @JsonPropertyDescription(value="Array of flattened (dot-delimited) object paths to drop")
    private Set<String> _fieldPathsToDrop = new HashSet<String>();
    @JsonPropertyDescription(value="Array of flattened (dot-delimited) object paths not to traverse further and keep same as input. This will also skip building mergedTextIndex for the field.")
    private Set<String> _fieldPathsToPreserveInput = new HashSet<String>();
    @JsonPropertyDescription(value="Array of flattened (dot-delimited) object paths not to traverse further and keep same as input. This will NOT skip building mergedTextIndex for the field.")
    private Set<String> _fieldPathsToPreserveInputWithIndex = new HashSet<String>();
    @JsonPropertyDescription(value="Array of flattened (dot-delimited) object paths not to store but only build mergedTextIndex for the field.")
    private Set<String> _fieldPathsToSkipStorage = Set.of("message");
    @JsonPropertyDescription(value="Map from customized meaningful column name to json key path")
    private Map<String, String> _columnNameToJsonKeyPathMap = new HashMap<String, String>();
    @JsonPropertyDescription(value="mergedTextIndex field")
    private String _mergedTextIndexField = "__mergedTextIndex";
    @JsonPropertyDescription(value="If set to true {'a.b': 'c'} will be indexed in the same way as {'a': {'b': 'c}}. Otherwise, the former one will be ignored.")
    private Boolean _useAnonymousDotInFieldNames = true;
    @JsonPropertyDescription(value="Whether to store extra lower cases value:key pairs in __mergedTextIndex to optimize case insensitive queries")
    private Boolean _optimizeCaseInsensitiveSearch = false;
    @JsonPropertyDescription(value="Whether to store key and value in reverse order, if true store as value:key, else store as key:value")
    private Boolean _reverseTextIndexKeyValueOrder = true;
    @JsonPropertyDescription(value="mergedTextIndex document max length")
    private int _mergedTextIndexDocumentMaxLength = 32766;
    @JsonPropertyDescription(value="mergedTextIndex binary document detection minimum length")
    private Integer _mergedTextIndexBinaryDocumentDetectionMinLength = 512;
    @JsonPropertyDescription(value="Array of paths to exclude from merged text index.")
    private Set<String> _mergedTextIndexPathToExclude = new HashSet<String>();
    @JsonPropertyDescription(value="Anchor before merged text index value. Default is empty String")
    private String _mergedTextIndexBeginOfDocAnchor = "";
    @JsonPropertyDescription(value="Anchor after merged text index value. Default is empty String")
    private String _mergedTextIndexEndOfDocAnchor = "";
    @JsonPropertyDescription(value="Dedicated fields to double ingest into json_data column")
    private Set<String> _fieldsToDoubleIngest = new HashSet<String>();
    @JsonPropertyDescription(value="Separator between key and value in json used in the Lucene index. Default is ':'.")
    private String _jsonKeyValueSeparator = ":";

    public SchemaConformingTransformerConfig() {
    }

    @JsonCreator
    public SchemaConformingTransformerConfig(@JsonProperty(value="enableIndexableExtras") @Nullable Boolean enableIndexableExtras, @JsonProperty(value="indexableExtrasField") @Nullable String indexableExtrasField, @JsonProperty(value="enableUnindexableExtras") @Nullable Boolean enableUnindexableExtras, @JsonProperty(value="unindexableExtrasField") @Nullable String unindexableExtrasField, @JsonProperty(value="unindexableFieldSuffix") @Nullable String unindexableFieldSuffix, @JsonProperty(value="fieldPathsToDrop") @Nullable Set<String> fieldPathsToDrop, @JsonProperty(value="fieldPathsToKeepSameAsInput") @Nullable Set<String> fieldPathsToPreserveInput, @JsonProperty(value="fieldPathsToKeepSameAsInputWithIndex") @Nullable Set<String> fieldPathsToPreserveInputWithIndex, @JsonProperty(value="fieldPathsToSkipStorage") @Nullable Set<String> fieldPathsToSkipStorage, @JsonProperty(value="columnNameToJsonKeyPathMap") @Nullable Map<String, String> columnNameToJsonKeyPathMap, @JsonProperty(value="mergedTextIndexField") @Nullable String mergedTextIndexFields, @JsonProperty(value="useAnonymousDotInFieldNames") @Nullable Boolean useAnonymousDotInFieldNames, @JsonProperty(value="optimizeCaseInsensitiveSearch") @Nullable Boolean optimizeCaseInsensitiveSearch, @JsonProperty(value="reverseTextIndexKeyValueOrder") @Nullable Boolean reverseTextIndexKeyValueOrder, @JsonProperty(value="mergedTextIndexDocumentMaxLength") @Nullable Integer mergedTextIndexDocumentMaxLength, @JsonProperty(value="mergedTextIndexBinaryTokenDetectionMinLength") @Nullable Integer mergedTextIndexBinaryTokenDetectionMinLength, @JsonProperty(value="mergedTextIndexBinaryDocumentDetectionMinLength") @Nullable Integer mergedTextIndexBinaryDocumentDetectionMinLength, @JsonProperty(value="mergedTextIndexPathToExclude") @Nullable Set<String> mergedTextIndexPathToExclude, @JsonProperty(value="fieldsToDoubleIngest") @Nullable Set<String> fieldsToDoubleIngest, @JsonProperty(value="jsonKeyValueSeparator") @Nullable String jsonKeyValueSeparator, @JsonProperty(value="mergedTextIndexBeginOfDocAnchor") @Nullable String mergedTextIndexBeginOfDocAnchor, @JsonProperty(value="mergedTextIndexEndOfDocAnchor") @Nullable String mergedTextIndexEndOfDocAnchor) {
        this.setEnableIndexableExtras(enableIndexableExtras);
        this.setIndexableExtrasField(indexableExtrasField);
        this.setEnableUnindexableExtras(enableUnindexableExtras);
        this.setUnindexableExtrasField(unindexableExtrasField);
        this.setUnindexableFieldSuffix(unindexableFieldSuffix);
        this.setFieldPathsToDrop(fieldPathsToDrop);
        this.setFieldPathsToPreserveInput(fieldPathsToPreserveInput);
        this.setFieldPathsToPreserveInputWithIndex(fieldPathsToPreserveInputWithIndex);
        this.setFieldPathsToSkipStorage(fieldPathsToSkipStorage);
        this.setColumnNameToJsonKeyPathMap(columnNameToJsonKeyPathMap);
        this.setMergedTextIndexField(mergedTextIndexFields);
        this.setUseAnonymousDotInFieldNames(useAnonymousDotInFieldNames);
        this.setOptimizeCaseInsensitiveSearch(optimizeCaseInsensitiveSearch);
        this.setReverseTextIndexKeyValueOrder(reverseTextIndexKeyValueOrder);
        this.setMergedTextIndexDocumentMaxLength(mergedTextIndexDocumentMaxLength);
        mergedTextIndexBinaryDocumentDetectionMinLength = mergedTextIndexBinaryDocumentDetectionMinLength == null ? mergedTextIndexBinaryTokenDetectionMinLength : mergedTextIndexBinaryDocumentDetectionMinLength;
        this.setMergedTextIndexBinaryDocumentDetectionMinLength(mergedTextIndexBinaryDocumentDetectionMinLength);
        this.setMergedTextIndexPathToExclude(mergedTextIndexPathToExclude);
        this.setFieldsToDoubleIngest(fieldsToDoubleIngest);
        this.setJsonKeyValueSeparator(jsonKeyValueSeparator);
        this.setMergedTextIndexBeginOfDocAnchor(mergedTextIndexBeginOfDocAnchor);
        this.setMergedTextIndexEndOfDocAnchor(mergedTextIndexEndOfDocAnchor);
    }

    public Boolean isEnableIndexableExtras() {
        return this._enableIndexableExtras;
    }

    public SchemaConformingTransformerConfig setEnableIndexableExtras(Boolean enableIndexableExtras) {
        this._enableIndexableExtras = enableIndexableExtras == null ? this._enableIndexableExtras : enableIndexableExtras;
        return this;
    }

    public String getIndexableExtrasField() {
        return this._enableIndexableExtras ? this._indexableExtrasField : null;
    }

    public SchemaConformingTransformerConfig setIndexableExtrasField(String indexableExtrasField) {
        this._indexableExtrasField = indexableExtrasField == null ? this._indexableExtrasField : indexableExtrasField;
        return this;
    }

    public Boolean isEnableUnindexableExtras() {
        return this._enableUnindexableExtras;
    }

    public SchemaConformingTransformerConfig setEnableUnindexableExtras(Boolean enableUnindexableExtras) {
        this._enableUnindexableExtras = enableUnindexableExtras == null ? this._enableUnindexableExtras : enableUnindexableExtras;
        return this;
    }

    public String getUnindexableExtrasField() {
        return this._enableUnindexableExtras ? this._unindexableExtrasField : null;
    }

    public SchemaConformingTransformerConfig setUnindexableExtrasField(String unindexableExtrasField) {
        this._unindexableExtrasField = unindexableExtrasField == null ? this._unindexableExtrasField : unindexableExtrasField;
        return this;
    }

    public String getUnindexableFieldSuffix() {
        return this._unindexableFieldSuffix;
    }

    public SchemaConformingTransformerConfig setUnindexableFieldSuffix(String unindexableFieldSuffix) {
        this._unindexableFieldSuffix = unindexableFieldSuffix == null ? this._unindexableFieldSuffix : unindexableFieldSuffix;
        return this;
    }

    public Set<String> getFieldPathsToDrop() {
        return this._fieldPathsToDrop;
    }

    public SchemaConformingTransformerConfig setFieldPathsToDrop(Set<String> fieldPathsToDrop) {
        this._fieldPathsToDrop = fieldPathsToDrop == null ? this._fieldPathsToDrop : fieldPathsToDrop;
        return this;
    }

    public Set<String> getFieldPathsToPreserveInput() {
        return this._fieldPathsToPreserveInput;
    }

    public SchemaConformingTransformerConfig setFieldPathsToPreserveInput(Set<String> fieldPathsToPreserveInput) {
        this._fieldPathsToPreserveInput = fieldPathsToPreserveInput == null ? this._fieldPathsToPreserveInput : fieldPathsToPreserveInput;
        return this;
    }

    public Set<String> getFieldPathsToSkipStorage() {
        return this._fieldPathsToSkipStorage;
    }

    public SchemaConformingTransformerConfig setFieldPathsToSkipStorage(Set<String> fieldPathsToSkipStorage) {
        this._fieldPathsToSkipStorage = fieldPathsToSkipStorage == null ? this._fieldPathsToSkipStorage : fieldPathsToSkipStorage;
        return this;
    }

    public Set<String> getFieldPathsToPreserveInputWithIndex() {
        return this._fieldPathsToPreserveInputWithIndex;
    }

    public SchemaConformingTransformerConfig setFieldPathsToPreserveInputWithIndex(Set<String> fieldPathsToPreserveInputWithIndex) {
        this._fieldPathsToPreserveInputWithIndex = fieldPathsToPreserveInputWithIndex == null ? this._fieldPathsToPreserveInputWithIndex : fieldPathsToPreserveInputWithIndex;
        return this;
    }

    public Map<String, String> getColumnNameToJsonKeyPathMap() {
        return this._columnNameToJsonKeyPathMap;
    }

    public SchemaConformingTransformerConfig setColumnNameToJsonKeyPathMap(Map<String, String> columnNameToJsonKeyPathMap) {
        this._columnNameToJsonKeyPathMap = columnNameToJsonKeyPathMap == null ? this._columnNameToJsonKeyPathMap : columnNameToJsonKeyPathMap;
        return this;
    }

    public String getMergedTextIndexField() {
        return this._mergedTextIndexField;
    }

    public SchemaConformingTransformerConfig setMergedTextIndexField(String mergedTextIndexField) {
        this._mergedTextIndexField = mergedTextIndexField == null ? this._mergedTextIndexField : mergedTextIndexField;
        return this;
    }

    public Boolean isUseAnonymousDotInFieldNames() {
        return this._useAnonymousDotInFieldNames;
    }

    public SchemaConformingTransformerConfig setUseAnonymousDotInFieldNames(Boolean useAnonymousDotInFieldNames) {
        this._useAnonymousDotInFieldNames = useAnonymousDotInFieldNames == null ? this._useAnonymousDotInFieldNames : useAnonymousDotInFieldNames;
        return this;
    }

    public Boolean isOptimizeCaseInsensitiveSearch() {
        return this._optimizeCaseInsensitiveSearch;
    }

    public SchemaConformingTransformerConfig setOptimizeCaseInsensitiveSearch(Boolean optimizeCaseInsensitiveSearch) {
        this._optimizeCaseInsensitiveSearch = optimizeCaseInsensitiveSearch == null ? this._optimizeCaseInsensitiveSearch : optimizeCaseInsensitiveSearch;
        return this;
    }

    public Boolean isReverseTextIndexKeyValueOrder() {
        return this._reverseTextIndexKeyValueOrder;
    }

    public SchemaConformingTransformerConfig setReverseTextIndexKeyValueOrder(Boolean reverseTextIndexKeyValueOrder) {
        this._reverseTextIndexKeyValueOrder = reverseTextIndexKeyValueOrder == null ? this._reverseTextIndexKeyValueOrder : reverseTextIndexKeyValueOrder;
        return this;
    }

    public Integer getMergedTextIndexDocumentMaxLength() {
        return this._mergedTextIndexDocumentMaxLength;
    }

    public SchemaConformingTransformerConfig setMergedTextIndexDocumentMaxLength(Integer mergedTextIndexDocumentMaxLength) {
        this._mergedTextIndexDocumentMaxLength = mergedTextIndexDocumentMaxLength == null ? this._mergedTextIndexDocumentMaxLength : mergedTextIndexDocumentMaxLength;
        return this;
    }

    public Integer getMergedTextIndexBinaryDocumentDetectionMinLength() {
        return this._mergedTextIndexBinaryDocumentDetectionMinLength;
    }

    public SchemaConformingTransformerConfig setMergedTextIndexBinaryDocumentDetectionMinLength(Integer mergedTextIndexBinaryDocumentDetectionMinLength) {
        this._mergedTextIndexBinaryDocumentDetectionMinLength = mergedTextIndexBinaryDocumentDetectionMinLength == null ? this._mergedTextIndexBinaryDocumentDetectionMinLength : mergedTextIndexBinaryDocumentDetectionMinLength;
        return this;
    }

    public Set<String> getMergedTextIndexPathToExclude() {
        return this._mergedTextIndexPathToExclude;
    }

    public SchemaConformingTransformerConfig setMergedTextIndexPathToExclude(Set<String> mergedTextIndexPathToExclude) {
        this._mergedTextIndexPathToExclude = mergedTextIndexPathToExclude == null ? this._mergedTextIndexPathToExclude : mergedTextIndexPathToExclude;
        return this;
    }

    public Set<String> getFieldsToDoubleIngest() {
        return this._fieldsToDoubleIngest;
    }

    public SchemaConformingTransformerConfig setFieldsToDoubleIngest(Set<String> fieldsToDoubleIngest) {
        this._fieldsToDoubleIngest = fieldsToDoubleIngest == null ? this._fieldsToDoubleIngest : fieldsToDoubleIngest;
        return this;
    }

    public String getJsonKeyValueSeparator() {
        return this._jsonKeyValueSeparator;
    }

    public void setJsonKeyValueSeparator(@Nullable String jsonKeyValueSeparator) {
        this._jsonKeyValueSeparator = jsonKeyValueSeparator == null ? ":" : jsonKeyValueSeparator;
    }

    public String getMergedTextIndexBeginOfDocAnchor() {
        return this._mergedTextIndexBeginOfDocAnchor;
    }

    public SchemaConformingTransformerConfig setMergedTextIndexBeginOfDocAnchor(String mergedTextIndexBeginOfDocAnchor) {
        this._mergedTextIndexBeginOfDocAnchor = mergedTextIndexBeginOfDocAnchor == null ? this._mergedTextIndexBeginOfDocAnchor : mergedTextIndexBeginOfDocAnchor;
        return this;
    }

    public String getMergedTextIndexEndOfDocAnchor() {
        return this._mergedTextIndexEndOfDocAnchor;
    }

    public SchemaConformingTransformerConfig setMergedTextIndexEndOfDocAnchor(String mergedTextIndexEndOfDocAnchor) {
        this._mergedTextIndexEndOfDocAnchor = mergedTextIndexEndOfDocAnchor == null ? this._mergedTextIndexEndOfDocAnchor : mergedTextIndexEndOfDocAnchor;
        return this;
    }
}

