/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.data;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.pinot.spi.data.Schema;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SchemaInfo {
    @JsonProperty(value="schemaName")
    private String _schemaName;
    @JsonProperty(value="numDimensionFields")
    private int _numDimensionFields;
    @JsonProperty(value="numDateTimeFields")
    private int _numDateTimeFields;
    @JsonProperty(value="numMetricFields")
    private int _numMetricFields;
    @JsonProperty(value="numComplexFields")
    private int _numComplexFields;

    public String getSchemaName() {
        return this._schemaName;
    }

    public int getNumDimensionFields() {
        return this._numDimensionFields;
    }

    public int getNumDateTimeFields() {
        return this._numDateTimeFields;
    }

    public int getNumMetricFields() {
        return this._numMetricFields;
    }

    public int getNumComplexFields() {
        return this._numComplexFields;
    }

    public SchemaInfo() {
    }

    public SchemaInfo(Schema schema) {
        this._schemaName = schema.getSchemaName();
        this._numDimensionFields = schema.getDimensionFieldSpecs().size() - 3;
        this._numDateTimeFields = schema.getDateTimeFieldSpecs().size();
        this._numMetricFields = schema.getMetricFieldSpecs().size();
        this._numComplexFields = schema.getComplexFieldSpecs().size();
    }
}

