/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.filesystem;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.pinot.spi.filesystem.PinotFS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasePinotFS
implements PinotFS {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasePinotFS.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean move(URI srcUri, URI dstUri, boolean overwrite) throws IOException {
        if (!this.exists(srcUri)) {
            LOGGER.warn("Source {} does not exist", (Object)srcUri);
            return false;
        }
        if (this.exists(dstUri)) {
            if (overwrite) {
                this.delete(dstUri, true);
                return this.doMove(srcUri, dstUri);
            }
            LOGGER.warn("Cannot move {} to {}. Destination exists and overwrite flag set to false.", (Object)srcUri, (Object)dstUri);
            return false;
        }
        try {
            Path parentPath = Paths.get(dstUri.getPath(), new String[0]).getParent();
            URI parentUri = new URI(dstUri.getScheme(), dstUri.getAuthority(), parentPath.toString(), null, null);
            this.mkdir(parentUri);
            return this.doMove(srcUri, dstUri);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    protected abstract boolean doMove(URI var1, URI var2) throws IOException;
}

