/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.filesystem;

public class FileMetadata {
    private final String _filePath;
    private final long _lastModifiedTime;
    private final long _length;
    private final boolean _isDirectory;

    private FileMetadata(String filePath, long lastModifiedTime, long length, boolean isDirectory) {
        this._filePath = filePath;
        this._lastModifiedTime = lastModifiedTime;
        this._length = length;
        this._isDirectory = isDirectory;
    }

    public String getFilePath() {
        return this._filePath;
    }

    public long getLastModifiedTime() {
        return this._lastModifiedTime;
    }

    public long getLength() {
        return this._length;
    }

    public boolean isDirectory() {
        return this._isDirectory;
    }

    public String toString() {
        return "FileMetadata{_filePath='" + this._filePath + "', _lastModifiedTime=" + this._lastModifiedTime + ", _length=" + this._length + ", _isDirectory=" + this._isDirectory + "}";
    }

    public static class Builder {
        private String _filePath;
        private long _lastModifiedTime;
        private long _length;
        private boolean _isDirectory;

        public Builder setFilePath(String filePath) {
            this._filePath = filePath;
            return this;
        }

        public Builder setLastModifiedTime(long lastModifiedTime) {
            this._lastModifiedTime = lastModifiedTime;
            return this;
        }

        public Builder setLength(long length) {
            this._length = length;
            return this;
        }

        public Builder setIsDirectory(boolean isDirectory) {
            this._isDirectory = isDirectory;
            return this;
        }

        public FileMetadata build() {
            return new FileMetadata(this._filePath, this._lastModifiedTime, this._length, this._isDirectory);
        }
    }
}

