/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.ingestion.batch;

import java.util.Map;
import org.apache.pinot.spi.data.readers.FileFormat;
import org.apache.pinot.spi.utils.IngestionConfigUtils;

public class BatchConfig {
    private final Map<String, String> _batchConfigMap;
    private final String _tableNameWithType;
    private final FileFormat _inputFormat;
    private final String _inputDirURI;
    private final String _inputFsClassName;
    private final Map<String, String> _inputFsProps;
    private final String _outputDirURI;
    private final String _outputFsClassName;
    private final Map<String, String> _outputFsProps;
    private final boolean _overwriteOutput;
    private final String _recordReaderClassName;
    private final String _recordReaderConfigClassName;
    private final Map<String, String> _recordReaderProps;
    private final String _segmentNameGeneratorType;
    private final Map<String, String> _segmentNameGeneratorConfigs;
    private final String _segmentName;
    private final String _segmentNamePrefix;
    private final String _segmentNamePostfix;
    private final boolean _excludeSequenceId;
    private final boolean _appendUUIDToSegmentName;
    private final boolean _excludeTimeInSegmentName;
    private final String _segmentPartitionId;
    private final String _sequenceId;
    private final long _segmentUploadTimeMs;
    private final String _pushMode;
    private final int _pushAttempts;
    private final int _pushParallelism;
    private final long _pushIntervalRetryMillis;
    private final String _pushSegmentURIPrefix;
    private final String _pushSegmentURISuffix;
    private final String _pushControllerURI;
    private final String _outputSegmentDirURI;

    public BatchConfig(String tableNameWithType, Map<String, String> batchConfigsMap) {
        this._batchConfigMap = batchConfigsMap;
        this._tableNameWithType = tableNameWithType;
        String inputFormat = batchConfigsMap.get("inputFormat");
        this._inputFormat = inputFormat != null ? FileFormat.valueOf(inputFormat.toUpperCase()) : null;
        this._inputDirURI = batchConfigsMap.get("inputDirURI");
        this._inputFsClassName = batchConfigsMap.get("input.fs.className");
        this._inputFsProps = IngestionConfigUtils.extractPropsMatchingPrefix(batchConfigsMap, "input.fs.prop");
        this._outputDirURI = batchConfigsMap.get("outputDirURI");
        this._outputFsClassName = batchConfigsMap.get("output.fs.className");
        this._outputFsProps = IngestionConfigUtils.extractPropsMatchingPrefix(batchConfigsMap, "output.fs.prop");
        this._overwriteOutput = Boolean.parseBoolean(batchConfigsMap.get("overwriteOutput"));
        this._recordReaderClassName = batchConfigsMap.get("recordReader.className");
        this._recordReaderConfigClassName = batchConfigsMap.get("recordReader.configClassName");
        this._recordReaderProps = IngestionConfigUtils.extractPropsMatchingPrefix(batchConfigsMap, "recordReader.prop");
        this._segmentNameGeneratorType = IngestionConfigUtils.getSegmentNameGeneratorType(batchConfigsMap);
        this._segmentNameGeneratorConfigs = IngestionConfigUtils.extractPropsMatchingPrefix(batchConfigsMap, "segmentNameGenerator.configs");
        Map<String, String> segmentNameGeneratorProps = IngestionConfigUtils.getSegmentNameGeneratorProps(batchConfigsMap);
        this._segmentName = segmentNameGeneratorProps.get("segment.name");
        this._segmentNamePrefix = segmentNameGeneratorProps.get("segment.name.prefix");
        this._segmentNamePostfix = segmentNameGeneratorProps.get("segment.name.postfix");
        this._excludeSequenceId = Boolean.parseBoolean(segmentNameGeneratorProps.get("exclude.sequence.id"));
        this._segmentPartitionId = batchConfigsMap.get("segment.partitionId");
        this._sequenceId = batchConfigsMap.get("sequenceId");
        this._appendUUIDToSegmentName = Boolean.parseBoolean(segmentNameGeneratorProps.get("append.uuid.to.segment.name"));
        this._excludeTimeInSegmentName = Boolean.parseBoolean(segmentNameGeneratorProps.get("exclude.time.in.segment.name"));
        this._segmentUploadTimeMs = Long.parseLong(batchConfigsMap.getOrDefault("segment.uploadTimeMs", String.valueOf(System.currentTimeMillis())));
        this._pushMode = IngestionConfigUtils.getPushMode(batchConfigsMap);
        this._pushAttempts = IngestionConfigUtils.getPushAttempts(batchConfigsMap);
        this._pushParallelism = IngestionConfigUtils.getPushParallelism(batchConfigsMap);
        this._pushIntervalRetryMillis = IngestionConfigUtils.getPushRetryIntervalMillis(batchConfigsMap);
        this._pushSegmentURIPrefix = batchConfigsMap.get("push.segmentUriPrefix");
        this._pushSegmentURISuffix = batchConfigsMap.get("push.segmentUriSuffix");
        this._pushControllerURI = batchConfigsMap.get("push.controllerUri");
        this._outputSegmentDirURI = batchConfigsMap.get("output.segment.dir.uri");
    }

    public String getTableNameWithType() {
        return this._tableNameWithType;
    }

    public String getInputDirURI() {
        return this._inputDirURI;
    }

    public String getOutputDirURI() {
        return this._outputDirURI;
    }

    public String getInputFsClassName() {
        return this._inputFsClassName;
    }

    public Map<String, String> getInputFsProps() {
        return this._inputFsProps;
    }

    public String getOutputFsClassName() {
        return this._outputFsClassName;
    }

    public Map<String, String> getOutputFsProps() {
        return this._outputFsProps;
    }

    public FileFormat getInputFormat() {
        return this._inputFormat;
    }

    public boolean isOverwriteOutput() {
        return this._overwriteOutput;
    }

    public String getRecordReaderClassName() {
        return this._recordReaderClassName;
    }

    public String getRecordReaderConfigClassName() {
        return this._recordReaderConfigClassName;
    }

    public Map<String, String> getRecordReaderProps() {
        return this._recordReaderProps;
    }

    public Map<String, String> getSegmentNameGeneratorConfigs() {
        return this._segmentNameGeneratorConfigs;
    }

    public String getSegmentNameGeneratorType() {
        return this._segmentNameGeneratorType;
    }

    public String getSegmentName() {
        return this._segmentName;
    }

    public String getSegmentNamePrefix() {
        return this._segmentNamePrefix;
    }

    public String getSegmentNamePostfix() {
        return this._segmentNamePostfix;
    }

    public boolean isExcludeSequenceId() {
        return this._excludeSequenceId;
    }

    public String getSegmentPartitionId() {
        return this._segmentPartitionId;
    }

    public String getSequenceId() {
        return this._sequenceId;
    }

    public long getSegmentUploadTimeMs() {
        return this._segmentUploadTimeMs;
    }

    public boolean isAppendUUIDToSegmentName() {
        return this._appendUUIDToSegmentName;
    }

    public boolean isExcludeTimeInSegmentName() {
        return this._excludeTimeInSegmentName;
    }

    public String getPushMode() {
        return this._pushMode;
    }

    public int getPushAttempts() {
        return this._pushAttempts;
    }

    public int getPushParallelism() {
        return this._pushParallelism;
    }

    public long getPushIntervalRetryMillis() {
        return this._pushIntervalRetryMillis;
    }

    public String getPushSegmentURIPrefix() {
        return this._pushSegmentURIPrefix;
    }

    public String getPushSegmentURISuffix() {
        return this._pushSegmentURISuffix;
    }

    public String getPushControllerURI() {
        return this._pushControllerURI;
    }

    public String getOutputSegmentDirURI() {
        return this._outputSegmentDirURI;
    }

    public Map<String, String> getBatchConfigMap() {
        return this._batchConfigMap;
    }
}

