/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.plugin;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class PinotPluginConfiguration {
    private final Map<String, List<String>> _importsFromRealm;
    private final String _parentRealmId;

    PinotPluginConfiguration(Properties properties) {
        HashMap importsFromRealm = new HashMap();
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            String key = k.toString();
            if (k.toString().startsWith("importFrom.")) {
                String realm = key.substring("importFrom.".length());
                List importsFrom = Stream.of(v.toString().split(",")).collect(Collectors.toList());
                importsFromRealm.put(realm, List.copyOf(importsFrom));
            }
        }));
        this._importsFromRealm = Map.copyOf(importsFromRealm);
        this._parentRealmId = properties.getProperty("parent.realmId");
    }

    public Map<String, List<String>> getImportsFromPerRealm() {
        return this._importsFromRealm;
    }

    public Optional<String> getParentRealmId() {
        return Optional.ofNullable(this._parentRealmId);
    }
}

