/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.stream;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.spi.stream.OffsetCriteria;
import org.apache.pinot.spi.stream.StreamConfigProperties;
import org.apache.pinot.spi.utils.DataSizeUtils;
import org.apache.pinot.spi.utils.TimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamConfig.class);
    public static final int DEFAULT_FLUSH_THRESHOLD_ROWS = 5000000;
    public static final long DEFAULT_FLUSH_THRESHOLD_TIME_MILLIS = TimeUnit.MILLISECONDS.convert(6L, TimeUnit.HOURS);
    public static final long DEFAULT_FLUSH_THRESHOLD_SEGMENT_SIZE_BYTES = 0xC800000L;
    public static final double DEFAULT_FLUSH_THRESHOLD_VARIANCE_FRACTION = 0.0;
    public static final int DEFAULT_FLUSH_AUTOTUNE_INITIAL_ROWS = 100000;
    public static final String DEFAULT_CONSUMER_FACTORY_CLASS_NAME_STRING = "org.apache.pinot.plugin.stream.kafka20.KafkaConsumerFactory";
    public static final long DEFAULT_STREAM_CONNECTION_TIMEOUT_MILLIS = 30000L;
    public static final int DEFAULT_STREAM_FETCH_TIMEOUT_MILLIS = 5000;
    public static final int DEFAULT_IDLE_TIMEOUT_MILLIS = 180000;
    private static final double CONSUMPTION_RATE_LIMIT_NOT_SPECIFIED = -1.0;
    private final String _type;
    private final String _topicName;
    private final String _tableNameWithType;
    private final String _consumerFactoryClassName;
    private final String _decoderClass;
    private final Map<String, String> _decoderProperties = new HashMap<String, String>();
    private final long _connectionTimeoutMillis;
    private final int _fetchTimeoutMillis;
    private final long _idleTimeoutMillis;
    private final int _flushThresholdRows;
    private final int _flushThresholdSegmentRows;
    private final long _flushThresholdTimeMillis;
    private final long _flushThresholdSegmentSizeBytes;
    private final double _flushThresholdVarianceFraction;
    private final int _flushAutotuneInitialRows;
    private final String _groupId;
    private final double _topicConsumptionRateLimit;
    private final Map<String, String> _streamConfigMap = new HashMap<String, String>();
    private OffsetCriteria _offsetCriteria;
    private final Boolean _serverUploadToDeepStore;

    public StreamConfig(String tableNameWithType, Map<String, String> streamConfigMap) {
        this._type = streamConfigMap.get("streamType");
        Preconditions.checkNotNull((Object)this._type, (Object)"streamType cannot be null");
        String topicNameKey = StreamConfigProperties.constructStreamProperty(this._type, "topic.name");
        this._topicName = streamConfigMap.get(topicNameKey);
        Preconditions.checkNotNull((Object)this._topicName, (Object)("Stream topic name " + topicNameKey + " cannot be null"));
        this._tableNameWithType = tableNameWithType;
        StreamConfig.validateConsumerType(this._type, streamConfigMap);
        String consumerFactoryClassKey = StreamConfigProperties.constructStreamProperty(this._type, "consumer.factory.class.name");
        this._consumerFactoryClassName = streamConfigMap.getOrDefault(consumerFactoryClassKey, DEFAULT_CONSUMER_FACTORY_CLASS_NAME_STRING);
        String offsetCriteriaKey = StreamConfigProperties.constructStreamProperty(this._type, "consumer.prop.auto.offset.reset");
        String offsetCriteriaValue = streamConfigMap.get(offsetCriteriaKey);
        this._offsetCriteria = offsetCriteriaValue != null ? new OffsetCriteria.OffsetCriteriaBuilder().withOffsetString(offsetCriteriaValue) : new OffsetCriteria.OffsetCriteriaBuilder().withOffsetLargest();
        String decoderClassKey = StreamConfigProperties.constructStreamProperty(this._type, "decoder.class.name");
        this._decoderClass = streamConfigMap.get(decoderClassKey);
        Preconditions.checkNotNull((Object)this._decoderClass, (Object)("Must specify decoder class name " + decoderClassKey));
        String streamDecoderPropPrefix = StreamConfigProperties.constructStreamProperty(this._type, "decoder.prop");
        for (String key : streamConfigMap.keySet()) {
            if (!key.startsWith(streamDecoderPropPrefix)) continue;
            this._decoderProperties.put(StreamConfigProperties.getPropertySuffix(key, streamDecoderPropPrefix), streamConfigMap.get(key));
        }
        long connectionTimeoutMillis = 30000L;
        String connectionTimeoutKey = StreamConfigProperties.constructStreamProperty(this._type, "connection.timeout.millis");
        String connectionTimeoutValue = streamConfigMap.get(connectionTimeoutKey);
        if (connectionTimeoutValue != null) {
            try {
                connectionTimeoutMillis = Long.parseLong(connectionTimeoutValue);
            }
            catch (Exception e) {
                LOGGER.warn("Invalid config {}: {}, defaulting to: {}", new Object[]{connectionTimeoutKey, connectionTimeoutValue, 30000L});
            }
        }
        this._connectionTimeoutMillis = connectionTimeoutMillis;
        int fetchTimeoutMillis = 5000;
        String fetchTimeoutKey = StreamConfigProperties.constructStreamProperty(this._type, "fetch.timeout.millis");
        String fetchTimeoutValue = streamConfigMap.get(fetchTimeoutKey);
        if (fetchTimeoutValue != null) {
            try {
                fetchTimeoutMillis = Integer.parseInt(fetchTimeoutValue);
            }
            catch (Exception e) {
                LOGGER.warn("Invalid config {}: {}, defaulting to: {}", new Object[]{fetchTimeoutKey, fetchTimeoutValue, 5000});
            }
        }
        this._fetchTimeoutMillis = fetchTimeoutMillis;
        int idleTimeoutMillis = 180000;
        String idleTimeoutMillisKey = StreamConfigProperties.constructStreamProperty(this._type, "idle.timeout.millis");
        String idleTimeoutMillisValue = streamConfigMap.get(idleTimeoutMillisKey);
        if (idleTimeoutMillisValue != null) {
            try {
                idleTimeoutMillis = Integer.parseInt(idleTimeoutMillisValue);
            }
            catch (Exception e) {
                LOGGER.warn("Invalid config {}: {}, defaulting to: {}", new Object[]{idleTimeoutMillisKey, idleTimeoutMillisValue, 180000});
            }
        }
        this._idleTimeoutMillis = idleTimeoutMillis;
        this._flushThresholdRows = StreamConfig.extractFlushThresholdRows(streamConfigMap);
        this._flushThresholdSegmentRows = StreamConfig.extractFlushThresholdSegmentRows(streamConfigMap);
        this._flushThresholdTimeMillis = StreamConfig.extractFlushThresholdTimeMillis(streamConfigMap);
        this._flushThresholdSegmentSizeBytes = StreamConfig.extractFlushThresholdSegmentSize(streamConfigMap);
        this._flushThresholdVarianceFraction = StreamConfig.extractFlushThresholdVarianceFraction(streamConfigMap);
        this._serverUploadToDeepStore = streamConfigMap.containsKey("realtime.segment.serverUploadToDeepStore") ? Boolean.valueOf(streamConfigMap.get("realtime.segment.serverUploadToDeepStore")) : null;
        int autotuneInitialRows = 0;
        String initialRowsValue = streamConfigMap.get("realtime.segment.flush.autotune.initialRows");
        if (initialRowsValue != null) {
            try {
                autotuneInitialRows = Integer.parseInt(initialRowsValue);
            }
            catch (Exception e) {
                LOGGER.warn("Invalid config {}: {}, defaulting to: {}", new Object[]{"realtime.segment.flush.autotune.initialRows", initialRowsValue, 100000});
            }
        }
        this._flushAutotuneInitialRows = autotuneInitialRows > 0 ? autotuneInitialRows : 100000;
        String groupIdKey = StreamConfigProperties.constructStreamProperty(this._type, "hlc.group.id");
        this._groupId = streamConfigMap.get(groupIdKey);
        String rate = streamConfigMap.get("topic.consumption.rate.limit");
        this._topicConsumptionRateLimit = rate != null ? Double.parseDouble(rate) : -1.0;
        this._streamConfigMap.putAll(streamConfigMap);
    }

    public static void validateConsumerType(String streamType, Map<String, String> streamConfigMap) {
        String consumerTypesKey = StreamConfigProperties.constructStreamProperty(streamType, "consumer.type");
        String consumerTypes = streamConfigMap.get(consumerTypesKey);
        if (consumerTypes == null) {
            return;
        }
        for (String consumerType : StringUtils.split((String)consumerTypes, (char)',')) {
            Preconditions.checkState((!consumerType.equalsIgnoreCase("highlevel") ? 1 : 0) != 0, (Object)"Realtime tables with HLC consumer (consumer.type=highlevel) is no longer supported in Apache Pinot");
        }
    }

    @Nullable
    public Boolean isServerUploadToDeepStore() {
        return this._serverUploadToDeepStore;
    }

    public static double extractFlushThresholdVarianceFraction(Map<String, String> streamConfigMap) {
        String key = "realtime.segment.flush.threshold.variance.fraction";
        String flushThresholdVarianceFractionStr = streamConfigMap.get(key);
        if (flushThresholdVarianceFractionStr != null) {
            try {
                double segmentSizeVariationFraction = Double.parseDouble(flushThresholdVarianceFractionStr);
                if (segmentSizeVariationFraction < 0.0 || segmentSizeVariationFraction >= 0.5) {
                    LOGGER.warn("Segment size variation fraction: {} should be in the range of [0, 0.5]. Using default {}", (Object)segmentSizeVariationFraction, (Object)0.0);
                    return 0.0;
                }
                return segmentSizeVariationFraction;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid config " + key + ": " + flushThresholdVarianceFractionStr);
            }
        }
        return 0.0;
    }

    public static long extractFlushThresholdSegmentSize(Map<String, String> streamConfigMap) {
        String key = "realtime.segment.flush.threshold.segment.size";
        String flushThresholdSegmentSizeStr = streamConfigMap.get(key);
        if (flushThresholdSegmentSizeStr == null) {
            key = "realtime.segment.flush.desired.size";
            flushThresholdSegmentSizeStr = streamConfigMap.get(key);
        }
        if (flushThresholdSegmentSizeStr != null) {
            try {
                return DataSizeUtils.toBytes(flushThresholdSegmentSizeStr);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid config " + key + ": " + flushThresholdSegmentSizeStr);
            }
        }
        return -1L;
    }

    public static int extractFlushThresholdRows(Map<String, String> streamConfigMap) {
        String key = "realtime.segment.flush.threshold.rows";
        String flushThresholdRowsStr = streamConfigMap.get(key);
        if (flushThresholdRowsStr == null) {
            key = "realtime.segment.flush.threshold.size";
            flushThresholdRowsStr = streamConfigMap.get(key);
        }
        if (flushThresholdRowsStr == null) {
            key = "realtime.segment.flush.threshold.size.llc";
            flushThresholdRowsStr = streamConfigMap.get(key);
        }
        if (flushThresholdRowsStr != null) {
            try {
                return Integer.parseInt(flushThresholdRowsStr);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid config " + key + ": " + flushThresholdRowsStr);
            }
        }
        return -1;
    }

    public static int extractFlushThresholdSegmentRows(Map<String, String> streamConfigMap) {
        String key = "realtime.segment.flush.threshold.segment.rows";
        String flushThresholdSegmentRowsStr = streamConfigMap.get(key);
        if (flushThresholdSegmentRowsStr != null) {
            try {
                return Integer.parseInt(flushThresholdSegmentRowsStr);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid config " + key + ": " + flushThresholdSegmentRowsStr);
            }
        }
        return -1;
    }

    public static long extractFlushThresholdTimeMillis(Map<String, String> streamConfigMap) {
        String key = "realtime.segment.flush.threshold.time";
        String flushThresholdTimeStr = streamConfigMap.get(key);
        if (flushThresholdTimeStr == null) {
            key = "realtime.segment.flush.threshold.time.llc";
            flushThresholdTimeStr = streamConfigMap.get(key);
        }
        if (flushThresholdTimeStr != null) {
            try {
                return TimeUtils.convertPeriodToMillis(flushThresholdTimeStr);
            }
            catch (Exception e) {
                try {
                    return Long.parseLong(flushThresholdTimeStr);
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException("Invalid config " + key + ": " + flushThresholdTimeStr);
                }
            }
        }
        return DEFAULT_FLUSH_THRESHOLD_TIME_MILLIS;
    }

    public String getType() {
        return this._type;
    }

    public String getTopicName() {
        return this._topicName;
    }

    @Deprecated
    public boolean hasHighLevelConsumerType() {
        return false;
    }

    @Deprecated
    public boolean hasLowLevelConsumerType() {
        return true;
    }

    public String getConsumerFactoryClassName() {
        return this._consumerFactoryClassName;
    }

    public OffsetCriteria getOffsetCriteria() {
        return this._offsetCriteria;
    }

    public void setOffsetCriteria(OffsetCriteria offsetCriteria) {
        this._offsetCriteria = offsetCriteria;
    }

    public String getDecoderClass() {
        return this._decoderClass;
    }

    public Map<String, String> getDecoderProperties() {
        return this._decoderProperties;
    }

    public long getConnectionTimeoutMillis() {
        return this._connectionTimeoutMillis;
    }

    public int getFetchTimeoutMillis() {
        return this._fetchTimeoutMillis;
    }

    public long getIdleTimeoutMillis() {
        return this._idleTimeoutMillis;
    }

    public int getFlushThresholdRows() {
        return this._flushThresholdRows;
    }

    public int getFlushThresholdSegmentRows() {
        return this._flushThresholdSegmentRows;
    }

    public long getFlushThresholdTimeMillis() {
        return this._flushThresholdTimeMillis;
    }

    public long getFlushThresholdSegmentSizeBytes() {
        return this._flushThresholdSegmentSizeBytes;
    }

    public double getFlushThresholdVarianceFraction() {
        return this._flushThresholdVarianceFraction;
    }

    public int getFlushAutotuneInitialRows() {
        return this._flushAutotuneInitialRows;
    }

    public String getGroupId() {
        return this._groupId;
    }

    public Optional<Double> getTopicConsumptionRateLimit() {
        return this._topicConsumptionRateLimit == -1.0 ? Optional.empty() : Optional.of(this._topicConsumptionRateLimit);
    }

    public String getTableNameWithType() {
        return this._tableNameWithType;
    }

    public Map<String, String> getStreamConfigsMap() {
        return this._streamConfigMap;
    }

    public String toString() {
        return "StreamConfig{_type='" + this._type + "', _topicName='" + this._topicName + "', _tableNameWithType='" + this._tableNameWithType + "', _consumerFactoryClassName='" + this._consumerFactoryClassName + "', _decoderClass='" + this._decoderClass + "', _decoderProperties=" + this._decoderProperties + ", _connectionTimeoutMillis=" + this._connectionTimeoutMillis + ", _fetchTimeoutMillis=" + this._fetchTimeoutMillis + ", _idleTimeoutMillis=" + this._idleTimeoutMillis + ", _flushThresholdRows=" + this._flushThresholdRows + ", _flushThresholdSegmentRows=" + this._flushThresholdSegmentRows + ", _flushThresholdTimeMillis=" + this._flushThresholdTimeMillis + ", _flushThresholdSegmentSizeBytes=" + this._flushThresholdSegmentSizeBytes + ", _flushThresholdVarianceFraction=" + this._flushThresholdVarianceFraction + ", _flushAutotuneInitialRows=" + this._flushAutotuneInitialRows + ", _groupId='" + this._groupId + "', _topicConsumptionRateLimit=" + this._topicConsumptionRateLimit + ", _streamConfigMap=" + this._streamConfigMap + ", _offsetCriteria=" + this._offsetCriteria + ", _serverUploadToDeepStore=" + this._serverUploadToDeepStore + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamConfig that = (StreamConfig)o;
        return this._connectionTimeoutMillis == that._connectionTimeoutMillis && this._fetchTimeoutMillis == that._fetchTimeoutMillis && this._idleTimeoutMillis == that._idleTimeoutMillis && this._flushThresholdRows == that._flushThresholdRows && this._flushThresholdSegmentRows == that._flushThresholdSegmentRows && this._flushThresholdTimeMillis == that._flushThresholdTimeMillis && this._flushThresholdSegmentSizeBytes == that._flushThresholdSegmentSizeBytes && this._flushAutotuneInitialRows == that._flushAutotuneInitialRows && Double.compare(this._topicConsumptionRateLimit, that._topicConsumptionRateLimit) == 0 && Objects.equals(this._serverUploadToDeepStore, that._serverUploadToDeepStore) && Objects.equals(this._type, that._type) && Objects.equals(this._topicName, that._topicName) && Objects.equals(this._tableNameWithType, that._tableNameWithType) && Objects.equals(this._consumerFactoryClassName, that._consumerFactoryClassName) && Objects.equals(this._decoderClass, that._decoderClass) && Objects.equals(this._decoderProperties, that._decoderProperties) && Objects.equals(this._groupId, that._groupId) && Objects.equals(this._streamConfigMap, that._streamConfigMap) && Objects.equals(this._offsetCriteria, that._offsetCriteria) && Objects.equals(this._flushThresholdVarianceFraction, that._flushThresholdVarianceFraction);
    }

    public int hashCode() {
        return Objects.hash(this._type, this._topicName, this._tableNameWithType, this._consumerFactoryClassName, this._decoderClass, this._decoderProperties, this._connectionTimeoutMillis, this._fetchTimeoutMillis, this._idleTimeoutMillis, this._flushThresholdRows, this._flushThresholdSegmentRows, this._flushThresholdTimeMillis, this._flushThresholdSegmentSizeBytes, this._flushAutotuneInitialRows, this._groupId, this._topicConsumptionRateLimit, this._streamConfigMap, this._offsetCriteria, this._serverUploadToDeepStore, this._flushThresholdVarianceFraction);
    }
}

