/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.stream;

import java.nio.charset.StandardCharsets;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.stream.StreamDataDecoder;
import org.apache.pinot.spi.stream.StreamDataDecoderResult;
import org.apache.pinot.spi.stream.StreamMessage;
import org.apache.pinot.spi.stream.StreamMessageDecoder;
import org.apache.pinot.spi.stream.StreamMessageMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamDataDecoderImpl
implements StreamDataDecoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamDataDecoderImpl.class);
    public static final String KEY = "__key";
    public static final String HEADER_KEY_PREFIX = "__header$";
    public static final String METADATA_KEY_PREFIX = "__metadata$";
    public static final String RECORD_SERIALIZED_VALUE_SIZE_KEY = "__metadata$recordSerializedValueSize";
    private final StreamMessageDecoder _valueDecoder;
    private final GenericRow _reuse = new GenericRow();

    public static boolean isSpecialKeyType(String key) {
        return key.equals(KEY) || key.startsWith(HEADER_KEY_PREFIX) || key.startsWith(METADATA_KEY_PREFIX);
    }

    public StreamDataDecoderImpl(StreamMessageDecoder valueDecoder) {
        this._valueDecoder = valueDecoder;
    }

    @Override
    public StreamDataDecoderResult decode(StreamMessage message) {
        assert (message.getValue() != null);
        try {
            this._reuse.clear();
            GenericRow row = this._valueDecoder.decode(message.getValue(), 0, message.getLength(), this._reuse);
            if (row != null) {
                StreamMessageMetadata metadata;
                if (message.getKey() != null) {
                    row.putValue(KEY, new String(message.getKey(), StandardCharsets.UTF_8));
                }
                if ((metadata = message.getMetadata()) != null) {
                    if (metadata.getHeaders() != null) {
                        metadata.getHeaders().getFieldToValueMap().forEach((key, value) -> row.putValue(HEADER_KEY_PREFIX + key, value));
                    }
                    if (metadata.getRecordMetadata() != null) {
                        metadata.getRecordMetadata().forEach((key, value) -> row.putValue(METADATA_KEY_PREFIX + key, value));
                    }
                    row.putValue(RECORD_SERIALIZED_VALUE_SIZE_KEY, message.getLength());
                }
                return new StreamDataDecoderResult(row, null);
            }
            return new StreamDataDecoderResult(null, new RuntimeException("Encountered unknown exception when decoding a Stream message"));
        }
        catch (Exception e) {
            LOGGER.error("Failed to decode StreamMessage", (Throwable)e);
            return new StreamDataDecoderResult(null, e);
        }
    }
}

