/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.stream;

import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.pinot.spi.data.readers.GenericRow;

public interface StreamDataProducer
extends AutoCloseable {
    public void init(Properties var1);

    public void produce(String var1, byte[] var2);

    public void produce(String var1, byte[] var2, byte[] var3);

    default public void produce(String topic, byte[] key, byte[] payload, GenericRow headers) {
        this.produce(topic, key, payload);
    }

    @Override
    public void close();

    default public void produceBatch(String topic, List<byte[]> rows) {
        for (byte[] row : rows) {
            this.produce(topic, row);
        }
    }

    default public void produceKeyedBatch(String topic, List<RowWithKey> payloadWithKey, boolean includeHeaders) {
        for (RowWithKey rowWithKey : payloadWithKey) {
            if (rowWithKey.getKey() == null) {
                this.produce(topic, rowWithKey.getPayload());
                continue;
            }
            if (includeHeaders) {
                GenericRow header = new GenericRow();
                header.putValue("header1", System.currentTimeMillis());
                this.produce(topic, rowWithKey.getKey(), rowWithKey.getPayload(), header);
                continue;
            }
            this.produce(topic, rowWithKey.getKey(), rowWithKey.getPayload());
        }
    }

    default public void produceKeyedBatch(String topic, List<RowWithKey> payloadWithKey) {
        this.produceKeyedBatch(topic, payloadWithKey, false);
    }

    public static class RowWithKey {
        private final byte[] _key;
        private final byte[] _payload;

        public RowWithKey(@Nullable byte[] key, byte[] payload) {
            this._key = key;
            this._payload = payload;
        }

        public byte[] getKey() {
            return this._key;
        }

        public byte[] getPayload() {
            return this._payload;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RowWithKey that = (RowWithKey)o;
            return Arrays.equals(this._key, that._key) && Arrays.equals(this._payload, that._payload);
        }

        public int hashCode() {
            int result = Arrays.hashCode(this._key);
            result = 31 * result + Arrays.hashCode(this._payload);
            return result;
        }
    }
}

