/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.utils;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetUtils.class);
    private static final int HTTP_PORT = 80;
    private static final String DUMMY_OUT_IPV4 = "8.8.8.8";
    private static final String DUMMY_OUT_IPV6 = "2001:4860:4860::8888";

    private NetUtils() {
    }

    public static String getHostAddress() throws SocketException, UnknownHostException {
        boolean isIPv6Preferred = Boolean.parseBoolean(System.getProperty("java.net.preferIPv6Addresses"));
        DatagramSocket ds = new DatagramSocket();
        try {
            ds.connect(isIPv6Preferred ? Inet6Address.getByName(DUMMY_OUT_IPV6) : Inet4Address.getByName(DUMMY_OUT_IPV4), 80);
        }
        catch (UncheckedIOException e) {
            LOGGER.warn(e.getMessage());
            if (isIPv6Preferred) {
                LOGGER.warn("No IPv6 route available on host, falling back to IPv4");
                ds.connect(Inet4Address.getByName(DUMMY_OUT_IPV4), 80);
            }
            LOGGER.warn("No IPv4 route available on host, falling back to IPv6");
            ds.connect(Inet6Address.getByName(DUMMY_OUT_IPV6), 80);
        }
        InetAddress localAddress = ds.getLocalAddress();
        if (localAddress.isAnyLocalAddress()) {
            localAddress = isIPv6Preferred ? NetUtils.getLocalIPv6Address() : InetAddress.getLocalHost();
        }
        return localAddress.getHostAddress();
    }

    private static InetAddress getLocalIPv6Address() throws UnknownHostException {
        for (InetAddress address : InetAddress.getAllByName(InetAddress.getLocalHost().getHostName())) {
            if (!(address instanceof Inet6Address) || address.isAnyLocalAddress()) continue;
            return address;
        }
        LOGGER.warn("Failed to find a non-wildcard IPv6 address, falling back to localhost");
        return Inet4Address.getLocalHost();
    }

    public static String getHostnameOrAddress() {
        try {
            return InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException ignored) {
            try {
                return NetUtils.getHostAddress();
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    public static int findOpenPort() throws IOException {
        try (ServerSocket socket = new ServerSocket(0);){
            int n = socket.getLocalPort();
            return n;
        }
    }

    public static int findOpenPort(int basePort) {
        while (!NetUtils.available(basePort)) {
            ++basePort;
        }
        return basePort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean available(int port) {
        ServerSocket ss = null;
        DatagramSocket ds = null;
        try {
            ss = new ServerSocket(port);
            ss.setReuseAddress(true);
            ds = new DatagramSocket(port);
            ds.setReuseAddress(true);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (ds != null) {
                ds.close();
            }
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

