/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.MethodAnnotationsScanner;
import org.reflections.scanners.Scanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PinotReflectionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(PinotReflectionUtils.class);
    private static final String PINOT_PACKAGE_NAME = "org.apache.pinot";
    private static final Object REFLECTION_LOCK = new Object();

    private PinotReflectionUtils() {
    }

    public static Set<Class<?>> getClassesThroughReflection(String regexPattern, Class<? extends Annotation> annotation) {
        return PinotReflectionUtils.getClassesThroughReflection(PINOT_PACKAGE_NAME, regexPattern, annotation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Class<?>> getClassesThroughReflection(String packageName, String regexPattern, Class<? extends Annotation> annotation) {
        try {
            Object object = REFLECTION_LOCK;
            synchronized (object) {
                return new Reflections((Configuration)new ConfigurationBuilder().setUrls(ClasspathHelper.forPackage((String)packageName, (ClassLoader[])new ClassLoader[0])).filterInputsBy((Predicate)new FilterBuilder().include(regexPattern))).getTypesAnnotatedWith(annotation);
            }
        }
        catch (Throwable t) {
            LOGGER.error("Error scanning classes within package: '{}' with regex pattern: '{}', annotation: {}", new Object[]{packageName, regexPattern, annotation.getSimpleName(), t});
            throw t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Class<?>> getClassesThroughReflection(List<String> packages, String regexPattern, Class<? extends Annotation> annotation) {
        try {
            Object object = REFLECTION_LOCK;
            synchronized (object) {
                ArrayList urls = new ArrayList();
                for (String packageName : packages) {
                    urls.addAll(ClasspathHelper.forPackage((String)packageName, (ClassLoader[])new ClassLoader[0]));
                }
                return new Reflections((Configuration)new ConfigurationBuilder().setUrls(urls).filterInputsBy((Predicate)new FilterBuilder().include(regexPattern))).getTypesAnnotatedWith(annotation);
            }
        }
        catch (Throwable t) {
            LOGGER.error("Error scanning classes within packages: {} with regex pattern: '{}', annotation: {}", new Object[]{packages, regexPattern, annotation.getSimpleName(), t});
            throw t;
        }
    }

    public static Set<Method> getMethodsThroughReflection(String regexPattern, Class<? extends Annotation> annotation) {
        return PinotReflectionUtils.getMethodsThroughReflection(PINOT_PACKAGE_NAME, regexPattern, annotation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Method> getMethodsThroughReflection(String packageName, String regexPattern, Class<? extends Annotation> annotation) {
        try {
            Object object = REFLECTION_LOCK;
            synchronized (object) {
                return new Reflections((Configuration)new ConfigurationBuilder().setUrls(ClasspathHelper.forPackage((String)packageName, (ClassLoader[])new ClassLoader[0])).filterInputsBy((Predicate)new FilterBuilder().include(regexPattern)).setScanners(new Scanner[]{new MethodAnnotationsScanner()})).getMethodsAnnotatedWith(annotation);
            }
        }
        catch (Throwable t) {
            LOGGER.error("Error scanning methods within package: '{}' with regex pattern: '{}', annotation: {}", new Object[]{packageName, regexPattern, annotation.getSimpleName(), t});
            throw t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runWithLock(Runnable runnable) {
        Object object = REFLECTION_LOCK;
        synchronized (object) {
            runnable.run();
        }
    }

    @Deprecated
    public static Object getReflectionLock() {
        return REFLECTION_LOCK;
    }
}

