/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.pinot;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.airlift.units.Duration;
import io.trino.plugin.base.session.PropertyMetadataUtil;
import io.trino.plugin.pinot.PinotConfig;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.session.PropertyMetadata;
import java.util.List;

public class PinotSessionProperties {
    private static final String PREFER_BROKER_QUERIES = "prefer_broker_queries";
    private static final String FORBID_SEGMENT_QUERIES = "forbid_segment_queries";
    private static final String RETRY_COUNT = "retry_count";
    private static final String NON_AGGREGATE_LIMIT_FOR_BROKER_QUERIES = "non_aggregate_limit_for_broker_queries";
    private static final String CONNECTION_TIMEOUT = "connection_timeout";
    private static final String SEGMENTS_PER_SPLIT = "segments_per_split";
    private static final String AGGREGATION_PUSHDOWN_ENABLED = "aggregation_pushdown_enabled";
    private static final String COUNT_DISTINCT_PUSHDOWN_ENABLED = "count_distinct_pushdown_enabled";
    private final List<PropertyMetadata<?>> sessionProperties;

    @Inject
    public PinotSessionProperties(PinotConfig pinotConfig) {
        this.sessionProperties = ImmutableList.of((Object)PropertyMetadata.booleanProperty((String)PREFER_BROKER_QUERIES, (String)"Prefer queries to broker even when parallel scan is enabled for aggregation queries", (Boolean)pinotConfig.isPreferBrokerQueries(), (boolean)false), (Object)PropertyMetadata.booleanProperty((String)FORBID_SEGMENT_QUERIES, (String)"Forbid segment queries", (Boolean)pinotConfig.isForbidSegmentQueries(), (boolean)false), (Object)PropertyMetadata.integerProperty((String)RETRY_COUNT, (String)"Retry count for retriable pinot data fetch calls", (Integer)pinotConfig.getFetchRetryCount(), (boolean)false), (Object)PropertyMetadata.integerProperty((String)NON_AGGREGATE_LIMIT_FOR_BROKER_QUERIES, (String)"Max limit for non aggregate queries to the pinot broker", (Integer)pinotConfig.getNonAggregateLimitForBrokerQueries(), (boolean)false), (Object)PropertyMetadataUtil.durationProperty((String)CONNECTION_TIMEOUT, (String)"Connection Timeout to talk to Pinot servers", (Duration)pinotConfig.getConnectionTimeout(), (boolean)false), (Object)PropertyMetadata.integerProperty((String)SEGMENTS_PER_SPLIT, (String)"Number of segments of the same host per split", (Integer)pinotConfig.getSegmentsPerSplit(), value -> Preconditions.checkArgument((value > 0 ? 1 : 0) != 0, (Object)"Number of segments per split must be more than zero"), (boolean)false), (Object)PropertyMetadata.booleanProperty((String)AGGREGATION_PUSHDOWN_ENABLED, (String)"Enable aggregation pushdown", (Boolean)pinotConfig.isAggregationPushdownEnabled(), (boolean)false), (Object)PropertyMetadata.booleanProperty((String)COUNT_DISTINCT_PUSHDOWN_ENABLED, (String)"Enable count distinct pushdown", (Boolean)pinotConfig.isCountDistinctPushdownEnabled(), (boolean)false));
    }

    public static boolean isPreferBrokerQueries(ConnectorSession session) {
        return (Boolean)session.getProperty(PREFER_BROKER_QUERIES, Boolean.class);
    }

    public static boolean isForbidSegmentQueries(ConnectorSession session) {
        return (Boolean)session.getProperty(FORBID_SEGMENT_QUERIES, Boolean.class);
    }

    public static int getPinotRetryCount(ConnectorSession session) {
        return (Integer)session.getProperty(RETRY_COUNT, Integer.class);
    }

    public static int getNonAggregateLimitForBrokerQueries(ConnectorSession session) {
        return (Integer)session.getProperty(NON_AGGREGATE_LIMIT_FOR_BROKER_QUERIES, Integer.class);
    }

    public static Duration getConnectionTimeout(ConnectorSession session) {
        return (Duration)session.getProperty(CONNECTION_TIMEOUT, Duration.class);
    }

    public static int getSegmentsPerSplit(ConnectorSession session) {
        int segmentsPerSplit = (Integer)session.getProperty(SEGMENTS_PER_SPLIT, Integer.class);
        return segmentsPerSplit <= 0 ? Integer.MAX_VALUE : segmentsPerSplit;
    }

    public static boolean isAggregationPushdownEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(AGGREGATION_PUSHDOWN_ENABLED, Boolean.class);
    }

    public static boolean isCountDistinctPushdownEnabled(ConnectorSession session) {
        Verify.verify((boolean)PinotSessionProperties.isAggregationPushdownEnabled(session), (String)"%s must be enabled when %s is enabled", (Object)AGGREGATION_PUSHDOWN_ENABLED, (Object)COUNT_DISTINCT_PUSHDOWN_ENABLED);
        return (Boolean)session.getProperty(COUNT_DISTINCT_PUSHDOWN_ENABLED, Boolean.class);
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }
}

