/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.pinot;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.SizeOf;
import io.trino.spi.connector.ConnectorSplit;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class PinotSplit
implements ConnectorSplit {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(PinotSplit.class);
    private final SplitType splitType;
    private final Optional<String> suffix;
    private final List<String> segments;
    private final Optional<String> segmentHost;
    private final Optional<String> timePredicate;

    @JsonCreator
    public PinotSplit(@JsonProperty(value="splitType") SplitType splitType, @JsonProperty(value="suffix") Optional<String> suffix, @JsonProperty(value="segments") List<String> segments, @JsonProperty(value="segmentHost") Optional<String> segmentHost, @JsonProperty(value="timePredicate") Optional<String> timePredicate) {
        this.splitType = Objects.requireNonNull(splitType, "splitType id is null");
        this.suffix = Objects.requireNonNull(suffix, "suffix is null");
        this.segments = ImmutableList.copyOf((Collection)Objects.requireNonNull(segments, "segments is null"));
        this.segmentHost = Objects.requireNonNull(segmentHost, "segmentHost is null");
        this.timePredicate = Objects.requireNonNull(timePredicate, "timePredicate is null");
        if (splitType == SplitType.SEGMENT) {
            Preconditions.checkArgument((boolean)suffix.isPresent(), (Object)"Suffix is missing from this split");
            Preconditions.checkArgument((!segments.isEmpty() ? 1 : 0) != 0, (Object)"Segments are missing from the split");
            Preconditions.checkArgument((boolean)segmentHost.isPresent(), (Object)"Segment host address is missing from the split");
        }
    }

    public static PinotSplit createBrokerSplit() {
        return new PinotSplit(SplitType.BROKER, Optional.empty(), (List<String>)ImmutableList.of(), Optional.empty(), Optional.empty());
    }

    public static PinotSplit createSegmentSplit(String suffix, List<String> segments, String segmentHost, Optional<String> timePredicate) {
        return new PinotSplit(SplitType.SEGMENT, Optional.of(Objects.requireNonNull(suffix, "suffix is null")), Objects.requireNonNull(segments, "segments are null"), Optional.of(Objects.requireNonNull(segmentHost, "segmentHost is null")), Objects.requireNonNull(timePredicate, "timePredicate is null"));
    }

    @JsonProperty
    public SplitType getSplitType() {
        return this.splitType;
    }

    @JsonProperty
    public Optional<String> getSuffix() {
        return this.suffix;
    }

    @JsonProperty
    public Optional<String> getSegmentHost() {
        return this.segmentHost;
    }

    @JsonProperty
    public List<String> getSegments() {
        return this.segments;
    }

    @JsonProperty
    public Optional<String> getTimePredicate() {
        return this.timePredicate;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("splitType", (Object)this.splitType).add("suffix", this.suffix).add("segments", this.segments).add("segmentHost", this.segmentHost).toString();
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf(this.suffix, SizeOf::estimatedSizeOf) + SizeOf.estimatedSizeOf(this.segments, SizeOf::estimatedSizeOf) + SizeOf.sizeOf(this.segmentHost, SizeOf::estimatedSizeOf) + SizeOf.sizeOf(this.timePredicate, SizeOf::estimatedSizeOf);
    }

    public static enum SplitType {
        SEGMENT,
        BROKER;

    }
}

