/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.pinot;

import com.google.common.base.Suppliers;
import com.google.inject.Inject;
import io.trino.plugin.pinot.PinotErrorCode;
import io.trino.plugin.pinot.PinotException;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.spi.data.DateTimeFieldSpec;
import org.apache.pinot.spi.data.DateTimeFormatSpec;
import org.apache.pinot.spi.data.FieldSpec;

public class PinotTypeConverter {
    private final Supplier<Type> jsonTypeSupplier;

    @Inject
    public PinotTypeConverter(TypeManager typeManager) {
        Objects.requireNonNull(typeManager, "typeManager is null");
        this.jsonTypeSupplier = Suppliers.memoize(() -> typeManager.getType(new TypeSignature("json", new TypeSignatureParameter[0])));
    }

    public Type toTrinoType(FieldSpec field) {
        return this.toTrinoType(field.getDataType(), field.isSingleValueField(), PinotTypeConverter.getFormatSpec(field));
    }

    private static Optional<DateTimeFormatSpec> getFormatSpec(FieldSpec field) {
        if (field instanceof DateTimeFieldSpec) {
            DateTimeFieldSpec spec = (DateTimeFieldSpec)field;
            return Optional.of(spec.getFormatSpec());
        }
        return Optional.empty();
    }

    private static boolean isDateType(DateTimeFormatSpec formatSpec) {
        return formatSpec.getColumnUnit() == TimeUnit.DAYS && formatSpec.getTimeFormat() == DateTimeFieldSpec.TimeFormat.EPOCH && formatSpec.getColumnSize() == 1;
    }

    public Type toTrinoType(TransformResultMetadata transformResultMetadata) {
        return this.toTrinoType(transformResultMetadata.getDataType(), transformResultMetadata.isSingleValue(), Optional.empty());
    }

    private Type toTrinoType(FieldSpec.DataType dataType, boolean isSingleValue, Optional<DateTimeFormatSpec> formatSpec) {
        Type type = this.toTrinoType(dataType, formatSpec);
        if (isSingleValue) {
            return type;
        }
        return new ArrayType(type);
    }

    private Type toTrinoType(FieldSpec.DataType dataType, Optional<DateTimeFormatSpec> formatSpec) {
        return switch (dataType) {
            case FieldSpec.DataType.BOOLEAN -> BooleanType.BOOLEAN;
            case FieldSpec.DataType.FLOAT -> RealType.REAL;
            case FieldSpec.DataType.DOUBLE -> DoubleType.DOUBLE;
            case FieldSpec.DataType.INT -> {
                if (formatSpec.map(PinotTypeConverter::isDateType).orElse(false).booleanValue()) {
                    yield DateType.DATE;
                }
                yield IntegerType.INTEGER;
            }
            case FieldSpec.DataType.LONG -> {
                if (formatSpec.map(PinotTypeConverter::isDateType).orElse(false).booleanValue()) {
                    yield DateType.DATE;
                }
                yield BigintType.BIGINT;
            }
            case FieldSpec.DataType.STRING -> VarcharType.VARCHAR;
            case FieldSpec.DataType.JSON -> this.jsonTypeSupplier.get();
            case FieldSpec.DataType.BYTES -> VarbinaryType.VARBINARY;
            case FieldSpec.DataType.TIMESTAMP -> TimestampType.TIMESTAMP_MILLIS;
            default -> throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_COLUMN_TYPE, Optional.empty(), "Unsupported type conversion for pinot data type: " + String.valueOf(dataType));
        };
    }

    public Type toTrinoType(DataSchema.ColumnDataType columnDataType) {
        return switch (columnDataType) {
            case DataSchema.ColumnDataType.INT -> IntegerType.INTEGER;
            case DataSchema.ColumnDataType.LONG -> BigintType.BIGINT;
            case DataSchema.ColumnDataType.FLOAT -> RealType.REAL;
            case DataSchema.ColumnDataType.DOUBLE -> DoubleType.DOUBLE;
            case DataSchema.ColumnDataType.STRING -> VarcharType.VARCHAR;
            case DataSchema.ColumnDataType.JSON -> this.jsonTypeSupplier.get();
            case DataSchema.ColumnDataType.BYTES -> VarbinaryType.VARBINARY;
            case DataSchema.ColumnDataType.INT_ARRAY -> new ArrayType((Type)IntegerType.INTEGER);
            case DataSchema.ColumnDataType.LONG_ARRAY -> new ArrayType((Type)BigintType.BIGINT);
            case DataSchema.ColumnDataType.DOUBLE_ARRAY -> new ArrayType((Type)DoubleType.DOUBLE);
            case DataSchema.ColumnDataType.STRING_ARRAY -> new ArrayType((Type)VarcharType.VARCHAR);
            default -> throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_COLUMN_TYPE, Optional.empty(), "Unsupported column data type: " + String.valueOf(columnDataType));
        };
    }

    public boolean isJsonType(Type type) {
        Objects.requireNonNull(type, "type is null");
        return type.equals((Object)this.jsonTypeSupplier.get());
    }
}

