/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.pinot.decoders;

import io.trino.plugin.pinot.decoders.Decoder;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.BooleanType;
import java.util.function.Supplier;

public class BooleanDecoder
implements Decoder {
    @Override
    public void decode(Supplier<Object> getter, BlockBuilder output) {
        Object value = getter.get();
        if (value == null) {
            output.appendNull();
        } else if (value instanceof Boolean) {
            Boolean booleanValue = (Boolean)value;
            BooleanType.BOOLEAN.writeBoolean(output, booleanValue.booleanValue());
        } else {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, String.format("Expected a boolean value of type BOOLEAN: %s [%s]", value, value.getClass().getSimpleName()));
        }
    }
}

