/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.pinot.decoders;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.plugin.base.util.JsonTypeUtil;
import io.trino.plugin.pinot.decoders.Decoder;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.VariableWidthBlockBuilder;
import java.util.function.Supplier;

public class JsonDecoder
implements Decoder {
    @Override
    public void decode(Supplier<Object> getter, BlockBuilder output) {
        Object value = getter.get();
        if (value == null) {
            output.appendNull();
        } else if (value instanceof String) {
            String string = (String)value;
            Slice slice = JsonTypeUtil.jsonParse((Slice)Slices.utf8Slice((String)string));
            ((VariableWidthBlockBuilder)output).writeEntry(slice);
        } else {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, String.format("Expected a json value of type STRING: %s [%s]", value, value.getClass().getSimpleName()));
        }
    }
}

