/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.pinot.query;

import com.google.common.base.Preconditions;
import io.trino.plugin.pinot.PinotColumnHandle;
import io.trino.plugin.pinot.query.DynamicTablePqlExtractor;
import java.util.Objects;

public record AggregateExpression(String function, String argument, boolean returnNullOnEmptyGroup) {
    public AggregateExpression {
        Objects.requireNonNull(function, "function is null");
        Objects.requireNonNull(argument, "argument is null");
    }

    public static AggregateExpression replaceIdentifier(AggregateExpression aggregationExpression, PinotColumnHandle columnHandle) {
        return new AggregateExpression(aggregationExpression.function(), AggregateExpression.stripDoubleQuotes(columnHandle.getExpression()), aggregationExpression.returnNullOnEmptyGroup());
    }

    private static String stripDoubleQuotes(String expression) {
        Preconditions.checkState((expression.startsWith("\"") && expression.endsWith("\"") && expression.length() >= 3 ? 1 : 0) != 0, (Object)"expression is not enclosed in double quotes");
        return expression.substring(1, expression.length() - 1).replaceAll("\"\"", "\"");
    }

    public String fieldName() {
        return String.format("%s(%s)", this.function, this.argument);
    }

    public String expression() {
        return String.format("%s(%s)", this.function, DynamicTablePqlExtractor.quoteIdentifier(this.argument));
    }
}

