/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.pinot.query;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.plugin.pinot.PinotColumnHandle;
import io.trino.plugin.pinot.query.OrderByExpression;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;

public record DynamicTable(String tableName, Optional<String> suffix, List<PinotColumnHandle> projections, Optional<String> filter, List<PinotColumnHandle> groupingColumns, List<PinotColumnHandle> aggregateColumns, Optional<String> havingExpression, List<OrderByExpression> orderBy, OptionalLong limit, OptionalLong offset, Map<String, String> queryOptions, String query) {
    public DynamicTable {
        Objects.requireNonNull(tableName, "tableName is null");
        Objects.requireNonNull(suffix, "suffix is null");
        projections = ImmutableList.copyOf((Collection)Objects.requireNonNull(projections, "projections is null"));
        Objects.requireNonNull(filter, "filter is null");
        groupingColumns = ImmutableList.copyOf((Collection)Objects.requireNonNull(groupingColumns, "groupingColumns is null"));
        aggregateColumns = ImmutableList.copyOf((Collection)Objects.requireNonNull(aggregateColumns, "aggregateColumns is null"));
        Objects.requireNonNull(havingExpression, "havingExpression is null");
        orderBy = ImmutableList.copyOf((Collection)Objects.requireNonNull(orderBy, "orderBy is null"));
        Objects.requireNonNull(limit, "limit is null");
        Objects.requireNonNull(offset, "offset is null");
        queryOptions = ImmutableMap.copyOf(Objects.requireNonNull(queryOptions, "queryOptions is null"));
        Objects.requireNonNull(query, "query is null");
    }

    public boolean aggregateInProjections() {
        return this.projections.stream().anyMatch(PinotColumnHandle::isAggregate);
    }
}

