/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.pinot.query;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.pinot.common.function.FunctionRegistry;
import org.apache.pinot.common.function.TransformFunctionType;
import org.apache.pinot.common.request.context.FunctionContext;
import org.apache.pinot.core.operator.transform.function.TransformFunctionFactory;

public final class PinotTransformFunctionTypeResolver {
    private static final Map<String, TransformFunctionType> TRANSFORM_FUNCTION_TYPE_MAP;

    private PinotTransformFunctionTypeResolver() {
    }

    public static Optional<TransformFunctionType> getTransformFunctionType(FunctionContext function) {
        Objects.requireNonNull(function, "function is null");
        String canonicalizedFunctionName = TransformFunctionFactory.canonicalize((String)function.getFunctionName());
        TransformFunctionType transformFunctionType = TRANSFORM_FUNCTION_TYPE_MAP.get(canonicalizedFunctionName);
        if (transformFunctionType != null) {
            return Optional.of(transformFunctionType);
        }
        if (FunctionRegistry.contains((String)canonicalizedFunctionName)) {
            return Optional.of(TransformFunctionType.SCALAR);
        }
        return Optional.empty();
    }

    static {
        HashMap<String, TransformFunctionType> builder = new HashMap<String, TransformFunctionType>();
        for (TransformFunctionType transformFunctionType : TransformFunctionType.values()) {
            for (String alias : transformFunctionType.getNames()) {
                TransformFunctionType previousValue = builder.put(TransformFunctionFactory.canonicalize((String)alias), transformFunctionType);
                Preconditions.checkState((previousValue == null || previousValue == transformFunctionType ? 1 : 0) != 0, (String)"Duplicate key with different values for alias '%s', transform function type '%s' and previous value '%s'", (Object)TransformFunctionFactory.canonicalize((String)alias), (Object)transformFunctionType, (Object)previousValue);
            }
        }
        TRANSFORM_FUNCTION_TYPE_MAP = Map.copyOf(builder);
    }
}

