/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.pinot.query.aggregation;

import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.plugin.base.aggregation.AggregateFunctionPatterns;
import io.trino.plugin.base.aggregation.AggregateFunctionRule;
import io.trino.plugin.base.expression.ConnectorExpressionPatterns;
import io.trino.plugin.pinot.PinotColumnHandle;
import io.trino.plugin.pinot.query.AggregateExpression;
import io.trino.spi.connector.AggregateFunction;
import io.trino.spi.expression.Variable;
import io.trino.spi.type.BigintType;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public class ImplementApproxDistinct
implements AggregateFunctionRule<AggregateExpression, Void> {
    private static final Capture<Variable> ARGUMENT = Capture.newCapture();
    private final Function<String, String> identifierQuote;

    public ImplementApproxDistinct(Function<String, String> identifierQuote) {
        this.identifierQuote = Objects.requireNonNull(identifierQuote, "identifierQuote is null");
    }

    public Pattern<AggregateFunction> getPattern() {
        return AggregateFunctionPatterns.basicAggregation().with(AggregateFunctionPatterns.functionName().equalTo((Object)"approx_distinct")).with(AggregateFunctionPatterns.outputType().equalTo((Object)BigintType.BIGINT)).with(AggregateFunctionPatterns.singleArgument().matching(ConnectorExpressionPatterns.variable().capturedAs(ARGUMENT)));
    }

    public Optional<AggregateExpression> rewrite(AggregateFunction aggregateFunction, Captures captures, AggregateFunctionRule.RewriteContext<Void> context) {
        Variable argument = (Variable)captures.get(ARGUMENT);
        PinotColumnHandle columnHandle = (PinotColumnHandle)context.getAssignment(argument.getName());
        return Optional.of(new AggregateExpression("distinctcounthll", this.identifierQuote.apply(columnHandle.getColumnName()), false));
    }
}

