/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.tsdb.spi;

import com.google.common.base.Preconditions;
import java.time.Duration;

public class RangeTimeSeriesRequest {
    private final String _language;
    private final String _query;
    private final long _startSeconds;
    private final long _endSeconds;
    private final long _stepSeconds;
    private final Duration _timeout;
    private final String _fullQueryString;

    public RangeTimeSeriesRequest(String language, String query, long startSeconds, long endSeconds, long stepSeconds, Duration timeout, String fullQueryString) {
        Preconditions.checkState((endSeconds >= startSeconds ? 1 : 0) != 0, (String)"Invalid range. startSeconds should be greater than or equal to endSeconds. Found startSeconds=%s and endSeconds=%s", (long)startSeconds, (long)endSeconds);
        this._language = language;
        this._query = query;
        this._startSeconds = startSeconds;
        this._endSeconds = endSeconds;
        this._stepSeconds = stepSeconds;
        this._timeout = timeout;
        this._fullQueryString = fullQueryString;
    }

    public String getLanguage() {
        return this._language;
    }

    public String getQuery() {
        return this._query;
    }

    public long getStartSeconds() {
        return this._startSeconds;
    }

    public long getEndSeconds() {
        return this._endSeconds;
    }

    public long getStepSeconds() {
        return this._stepSeconds;
    }

    public Duration getTimeout() {
        return this._timeout;
    }

    public String getFullQueryString() {
        return this._fullQueryString;
    }
}

