/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.tsdb.spi;

import java.time.Duration;
import java.util.Arrays;
import java.util.Objects;

public class TimeBuckets {
    private final Long[] _timeBuckets;
    private final Duration _bucketSize;

    private TimeBuckets(Long[] timeBuckets, Duration bucketSize) {
        this._timeBuckets = timeBuckets;
        this._bucketSize = bucketSize;
    }

    public Long[] getTimeBuckets() {
        return this._timeBuckets;
    }

    public Duration getBucketSize() {
        return this._bucketSize;
    }

    public long getTimeRangeStartExclusive() {
        return this._timeBuckets[0] - this._bucketSize.getSeconds();
    }

    public long getTimeRangeEndInclusive() {
        return this._timeBuckets[this._timeBuckets.length - 1];
    }

    public long getRangeSeconds() {
        return this.getTimeRangeEndInclusive() - this.getTimeRangeStartExclusive();
    }

    public int getNumBuckets() {
        return this._timeBuckets.length;
    }

    public int resolveIndex(long timeValue) {
        if (this._timeBuckets.length == 0) {
            return -1;
        }
        if (timeValue <= this.getTimeRangeStartExclusive() || timeValue > this.getTimeRangeEndInclusive()) {
            return -1;
        }
        long offsetFromRangeStart = timeValue - this.getTimeRangeStartExclusive();
        return (int)((offsetFromRangeStart - 1L) / this._bucketSize.getSeconds());
    }

    public boolean equals(Object o) {
        if (!(o instanceof TimeBuckets)) {
            return false;
        }
        TimeBuckets other = (TimeBuckets)o;
        return this.getTimeRangeStartExclusive() == other.getTimeRangeStartExclusive() && this.getTimeRangeEndInclusive() == other.getTimeRangeEndInclusive() && this.getBucketSize().equals(other.getBucketSize());
    }

    public int hashCode() {
        int result = Objects.hash(this._bucketSize);
        result = 31 * result + Arrays.hashCode((Object[])this._timeBuckets);
        return result;
    }

    public static TimeBuckets ofSeconds(long firstBucketValue, Duration bucketSize, int numElements) {
        long stepSize = bucketSize.getSeconds();
        Long[] timeBuckets = new Long[numElements];
        for (int i = 0; i < numElements; ++i) {
            timeBuckets[i] = firstBucketValue + (long)i * stepSize;
        }
        return new TimeBuckets(timeBuckets, bucketSize);
    }
}

