/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.tsdb.spi.plan;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.pinot.tsdb.spi.AggInfo;
import org.apache.pinot.tsdb.spi.TimeBuckets;
import org.apache.pinot.tsdb.spi.operator.BaseTimeSeriesOperator;
import org.apache.pinot.tsdb.spi.plan.BaseTimeSeriesPlanNode;

public class LeafTimeSeriesPlanNode
extends BaseTimeSeriesPlanNode {
    private final String _tableName;
    private final String _timeColumn;
    private final TimeUnit _timeUnit;
    private final Long _offsetSeconds;
    private final String _filterExpression;
    private final String _valueExpression;
    private final AggInfo _aggInfo;
    private final List<String> _groupByExpressions;

    @JsonCreator
    public LeafTimeSeriesPlanNode(@JsonProperty(value="id") String id, @JsonProperty(value="inputs") List<BaseTimeSeriesPlanNode> inputs, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="timeColumn") String timeColumn, @JsonProperty(value="timeUnit") TimeUnit timeUnit, @JsonProperty(value="offsetSeconds") Long offsetSeconds, @JsonProperty(value="filterExpression") String filterExpression, @JsonProperty(value="valueExpression") String valueExpression, @JsonProperty(value="aggInfo") AggInfo aggInfo, @JsonProperty(value="groupByExpressions") List<String> groupByExpressions) {
        super(id, inputs);
        this._tableName = tableName;
        this._timeColumn = timeColumn;
        this._timeUnit = timeUnit;
        this._offsetSeconds = offsetSeconds;
        this._filterExpression = filterExpression;
        this._valueExpression = valueExpression;
        this._aggInfo = aggInfo;
        this._groupByExpressions = groupByExpressions;
    }

    public LeafTimeSeriesPlanNode withAggInfo(AggInfo newAggInfo) {
        return new LeafTimeSeriesPlanNode(this._id, this._inputs, this._tableName, this._timeColumn, this._timeUnit, this._offsetSeconds, this._filterExpression, this._valueExpression, newAggInfo, this._groupByExpressions);
    }

    @Override
    public BaseTimeSeriesPlanNode withInputs(List<BaseTimeSeriesPlanNode> newInputs) {
        return new LeafTimeSeriesPlanNode(this._id, newInputs, this._tableName, this._timeColumn, this._timeUnit, this._offsetSeconds, this._filterExpression, this._valueExpression, this._aggInfo, this._groupByExpressions);
    }

    @Override
    public String getKlass() {
        return LeafTimeSeriesPlanNode.class.getName();
    }

    @Override
    public String getExplainName() {
        return String.format("LEAF_TIME_SERIES_PLAN_NODE(%s, table=%s, timeExpr=%s, valueExpr=%s, aggInfo=%s, groupBy=%s, filter=%s, offsetSeconds=%s)", this._id, this._tableName, this._timeColumn, this._valueExpression, this._aggInfo.getAggFunction(), this._groupByExpressions, this._filterExpression, this._offsetSeconds);
    }

    @Override
    public BaseTimeSeriesOperator run() {
        throw new UnsupportedOperationException("Leaf plan node is replaced with a physical plan node at runtime");
    }

    public String getTableName() {
        return this._tableName;
    }

    public String getTimeColumn() {
        return this._timeColumn;
    }

    public TimeUnit getTimeUnit() {
        return this._timeUnit;
    }

    public Long getOffsetSeconds() {
        return this._offsetSeconds;
    }

    public String getFilterExpression() {
        return this._filterExpression;
    }

    public String getValueExpression() {
        return this._valueExpression;
    }

    public AggInfo getAggInfo() {
        return this._aggInfo;
    }

    public List<String> getGroupByExpressions() {
        return this._groupByExpressions;
    }

    public String getEffectiveFilter(TimeBuckets timeBuckets) {
        String filter = this._filterExpression == null ? "" : this._filterExpression;
        long startTime = this._timeUnit.convert(Duration.ofSeconds(timeBuckets.getTimeRangeStartExclusive() - this._offsetSeconds));
        long endTime = this._timeUnit.convert(Duration.ofSeconds(timeBuckets.getTimeRangeEndInclusive() - this._offsetSeconds));
        String timeFilter = String.format("%s > %d AND %s <= %d", this._timeColumn, startTime, this._timeColumn, endTime);
        if (filter.strip().isEmpty()) {
            return timeFilter;
        }
        return String.format("(%s) AND (%s)", filter, timeFilter);
    }
}

