/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.tsdb.spi.series.builders;

import java.util.List;
import org.apache.pinot.tsdb.spi.TimeBuckets;
import org.apache.pinot.tsdb.spi.series.BaseTimeSeriesBuilder;
import org.apache.pinot.tsdb.spi.series.TimeSeries;

public class SummingTimeSeriesBuilder
extends BaseTimeSeriesBuilder {
    private final Double[] _values;

    public SummingTimeSeriesBuilder(String id, TimeBuckets timeBuckets, List<String> tagNames, Object[] tagValues) {
        super(id, null, timeBuckets, tagNames, tagValues);
        this._values = new Double[timeBuckets.getNumBuckets()];
    }

    @Override
    public void addValueAtIndex(int timeBucketIndex, Double value) {
        if (value != null) {
            this._values[timeBucketIndex] = (this._values[timeBucketIndex] == null ? 0.0 : this._values[timeBucketIndex]) + value;
        }
    }

    @Override
    public void addValue(long timeValue, Double value) {
        int timeBucketIndex = this._timeBuckets.resolveIndex(timeValue);
        this.addValueAtIndex(timeBucketIndex, value);
    }

    @Override
    public TimeSeries build() {
        return new TimeSeries(this._id, null, this._timeBuckets, this._values, this._tagNames, this._tagValues);
    }
}

