/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.hash4j.distinctcount;

import java.util.Objects;

class DistinctCountUtil {
    private static final double C0 = -0.3333333333333333;
    private static final double C1 = 0.022222222222222223;
    private static final double C2 = 0.0021164021164021165;
    private static final int MAX_NLZ_IN_TOKEN = 38;
    private static final double RELATIVE_ERROR_LIMIT = 1.0E-6;
    private static final int INVALID_TOKEN_INDEX = -1;

    private DistinctCountUtil() {
    }

    static IllegalArgumentException getUnexpectedStateLengthException() {
        return new IllegalArgumentException("unexpected state length!");
    }

    static boolean isUnsignedPowerOfTwo(int x) {
        return (x & x - 1) == 0;
    }

    static void checkPrecisionParameter(int p, int minP, int maxP) {
        if (p < minP || p > maxP) {
            throw new IllegalArgumentException("illegal precision parameter");
        }
    }

    static double solveMaximumLikelihoodEquation(double a, int[] b, int n, double relativeErrorLimit) {
        int kMax;
        if (a == 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        for (kMax = n; kMax >= 0 && b[kMax] == 0; --kMax) {
        }
        if (kMax < 0) {
            return 0.0;
        }
        int kMin = kMax;
        int t = b[kMax];
        long s1 = t;
        double s2 = Double.longBitsToDouble(Double.doubleToRawLongBits(t) + ((long)kMax << 52));
        for (int k = kMax - 1; k >= 0; --k) {
            t = b[k];
            if (t <= 0) continue;
            s1 += (long)t;
            s2 += Double.longBitsToDouble(Double.doubleToRawLongBits(t) + ((long)k << 52));
            kMin = k;
        }
        double gPrevious = 0.0;
        double x = s2 <= 1.5 * a ? (double)s1 / (0.5 * s2 + a) : Math.log1p(s2 / a) * ((double)s1 / s2);
        double deltaX = x;
        while (deltaX > x * relativeErrorLimit) {
            long rawX = Double.doubleToRawLongBits(x);
            int kappa = (int)((rawX & 0x7FF0000000000000L) >> 52) - 1021;
            double xPrime = Double.longBitsToDouble(rawX - ((long)Math.max(kMax, kappa) + 1L << 52));
            double xPrime2 = xPrime * xPrime;
            double h = xPrime + xPrime2 * (-0.3333333333333333 + xPrime2 * (0.022222222222222223 - xPrime2 * 0.0021164021164021165));
            for (int k = kappa - 1; k >= kMax; --k) {
                double hPrime = 1.0 - h;
                h = (xPrime + h * hPrime) / (xPrime + hPrime);
                xPrime += xPrime;
            }
            double g = (double)b[kMax] * h;
            for (int k = kMax - 1; k >= kMin; --k) {
                double hPrime = 1.0 - h;
                h = (xPrime + h * hPrime) / (xPrime + hPrime);
                xPrime += xPrime;
                g += (double)b[k] * h;
            }
            deltaX = gPrevious < (g += x * a) && g <= (double)s1 ? (deltaX *= (g - (double)s1) / (gPrevious - g)) : 0.0;
            x += deltaX;
            gPrevious = g;
        }
        return x;
    }

    static int computeToken1(long hashValue) {
        int idx = (int)(hashValue >>> 38);
        int nlz = Long.numberOfLeadingZeros((hashValue ^ 0xFFFFFFFFFFFFFFFFL) << 26 ^ 0xFFFFFFFFFFFFFFFFL);
        return idx << 6 | nlz;
    }

    static long reconstructHash1(int token) {
        long idx = (long)token & 0xFFFFFFC0L;
        return 0x3FFFFFFFFFL >>> token | idx << 32;
    }

    static boolean isValidToken(int token) {
        int nlz = token & 0x3F;
        return nlz <= 38;
    }

    static double estimateDistinctCountFromTokens(TokenIterable tokenIterable) {
        Objects.requireNonNull(tokenIterable);
        TokenIterator tokenIterator = tokenIterable.iterator();
        int[] b = new int[38];
        int currentIdx = -1;
        long currentFlags = 0L;
        while (tokenIterator.hasNext()) {
            long mask;
            int token = tokenIterator.nextToken();
            if (!DistinctCountUtil.isValidToken(token)) continue;
            int idx = token >>> 6;
            if (currentIdx != idx) {
                currentFlags = 0L;
                currentIdx = idx;
            }
            if ((currentFlags & (mask = 1L << token)) != 0L) continue;
            currentFlags |= mask;
            int nlz = token & 0x3F;
            if (nlz < 38) {
                int n = nlz;
                b[n] = b[n] + 1;
                continue;
            }
            b[37] = b[37] + 1;
        }
        double a = 1.34217728E8;
        int maxNonZeroIndex = 0;
        for (int i = 0; i < 38; ++i) {
            if (b[i] == 0) continue;
            a -= (double)b[i] * Double.longBitsToDouble(1023L - (long)i << 52);
            maxNonZeroIndex = i;
        }
        return DistinctCountUtil.solveMaximumLikelihoodEquation(a, b, maxNonZeroIndex, 1.0E-6) * 1.34217728E8;
    }

    static double unsignedLongToDouble(long l) {
        double d = l & Long.MAX_VALUE;
        if (l < 0L) {
            d += 9.223372036854776E18;
        }
        return d;
    }

    static interface TokenIterable {
        public TokenIterator iterator();
    }

    static interface TokenIterator {
        public boolean hasNext();

        public int nextToken();
    }
}

