/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.hash4j.hashing;

import com.dynatrace.hash4j.hashing.AbstractHashStream64;
import com.dynatrace.hash4j.hashing.AbstractHasher;
import com.dynatrace.hash4j.hashing.AbstractHasher64;
import com.dynatrace.hash4j.hashing.HashStream64;

abstract class AbstractFarmHash
extends AbstractHasher64 {
    protected static final long K0 = -4348849565147123417L;
    protected static final long K1 = -5435081209227447693L;
    protected static final long K2 = -7286425919675154353L;
    protected static final long K_MUL = -7070675565921424023L;

    AbstractFarmHash() {
    }

    protected static final long shiftMix(long val) {
        return val ^ val >>> 47;
    }

    protected static final long hashLen16(long u, long v, long mul) {
        long a = AbstractFarmHash.shiftMix((u ^ v) * mul);
        return AbstractFarmHash.shiftMix((v ^ a) * mul) * mul;
    }

    protected static final long mul(int bufferCount) {
        return -7286425919675154369L + (long)(bufferCount << 1);
    }

    protected static final long hash1To3Bytes(int bufferCount, int firstByte, int midOrLastByte, int lastByte) {
        int y = firstByte + (midOrLastByte << 8);
        int z = bufferCount - 8 + (lastByte << 2);
        return AbstractFarmHash.shiftMix((long)y * -7286425919675154353L ^ (long)z * -4348849565147123417L) * -7286425919675154353L;
    }

    protected static final long hash4To7Bytes(int bufferCount, long first4Bytes, long last4Bytes) {
        long mul = AbstractFarmHash.mul(bufferCount);
        return AbstractFarmHash.hashLen16((long)(bufferCount - 8) + (first4Bytes << 3), last4Bytes, mul);
    }

    protected static final long hash8To16Bytes(int bufferCount, long first8Bytes, long last8Bytes) {
        long mul = AbstractFarmHash.mul(bufferCount);
        long a = first8Bytes + -7286425919675154353L;
        long c = Long.rotateRight(last8Bytes, 37) * mul + a;
        long d = (Long.rotateRight(a, 25) + last8Bytes) * mul;
        return AbstractFarmHash.hashLen16(c, d, mul);
    }

    @Override
    public long hashBytesToLong(byte[] input, int off, int len) {
        if (len <= 32) {
            if (len <= 16) {
                return this.finalizeHash(AbstractFarmHash.hashBytesToLongLength0to16(input, off, len));
            }
            return this.finalizeHash(AbstractFarmHash.hashBytesToLongLength17to32(input, off, len));
        }
        if (len <= 64) {
            return this.finalizeHash(AbstractFarmHash.hashBytesToLongLength33To64(input, off, len));
        }
        return this.hashBytesToLongLength65Plus(input, off, len);
    }

    protected abstract long hashBytesToLongLength65Plus(byte[] var1, int var2, int var3);

    protected long finalizeHash(long hash) {
        return hash;
    }

    private static long hashBytesToLongLength0to16(byte[] bytes, int offset, int length) {
        if (length >= 8) {
            long mul = -7286425919675154353L + (long)(length << 1);
            long a = AbstractFarmHash.getLong(bytes, offset) + -7286425919675154353L;
            long b = AbstractFarmHash.getLong(bytes, offset + length - 8);
            long c = Long.rotateRight(b, 37) * mul + a;
            long d = (Long.rotateRight(a, 25) + b) * mul;
            return AbstractFarmHash.hashLength16(c, d, mul);
        }
        if (length >= 4) {
            long mul = -7286425919675154353L + (long)(length << 1);
            long a = (long)AbstractFarmHash.getInt(bytes, offset) & 0xFFFFFFFFL;
            return AbstractFarmHash.hashLength16((long)length + (a << 3), (long)AbstractFarmHash.getInt(bytes, offset + length - 4) & 0xFFFFFFFFL, mul);
        }
        if (length > 0) {
            byte a = bytes[offset];
            byte b = bytes[offset + (length >> 1)];
            byte c = bytes[offset + (length - 1)];
            int y = (a & 0xFF) + ((b & 0xFF) << 8);
            int z = length + ((c & 0xFF) << 2);
            return AbstractFarmHash.shiftMix((long)y * -7286425919675154353L ^ (long)z * -4348849565147123417L) * -7286425919675154353L;
        }
        return -7286425919675154353L;
    }

    private static long hashCharsToLongLength0to8(CharSequence input) {
        int len = input.length();
        if (len >= 4) {
            long mul = -7286425919675154353L + (long)(len << 2);
            long b = AbstractFarmHash.getLong(input, 0);
            long a = b + -7286425919675154353L;
            if (len >= 5) {
                b >>>= 16;
                b |= (long)input.charAt(4) << 48;
                if (len >= 6) {
                    b >>>= 16;
                    b |= (long)input.charAt(5) << 48;
                    if (len >= 7) {
                        b >>>= 16;
                        b |= (long)input.charAt(6) << 48;
                        if (len >= 8) {
                            b >>>= 16;
                            b |= (long)input.charAt(7) << 48;
                        }
                    }
                }
            }
            long c = Long.rotateRight(b, 37) * mul + a;
            long d = (Long.rotateRight(a, 25) + b) * mul;
            return AbstractFarmHash.hashLength16(c, d, mul);
        }
        if (len >= 2) {
            long a;
            long mul = -7286425919675154353L + (long)(len << 2);
            long b = a = (long)AbstractFarmHash.getInt(input, 0) & 0xFFFFFFFFL;
            if (len >= 3) {
                b >>>= 16;
                b |= (long)input.charAt(2) << 16;
            }
            return AbstractFarmHash.hashLength16((long)(len << 1) + (a << 3), b, mul);
        }
        if (len >= 1) {
            char y = input.charAt(0);
            int z = (len << 1) + (y >>> 8 << 2);
            return AbstractFarmHash.shiftMix((long)y * -7286425919675154353L ^ (long)z * -4348849565147123417L) * -7286425919675154353L;
        }
        return -7286425919675154353L;
    }

    private static long hashBytesToLongLength17to32(byte[] bytes, int offset, int length) {
        long mul = -7286425919675154353L + (long)(length << 1);
        long a = AbstractFarmHash.getLong(bytes, offset) * -5435081209227447693L;
        long b = AbstractFarmHash.getLong(bytes, offset + 8);
        long c = AbstractFarmHash.getLong(bytes, offset + length - 8) * mul;
        long d = AbstractFarmHash.getLong(bytes, offset + length - 16) * -7286425919675154353L;
        return AbstractFarmHash.hashLength16(Long.rotateRight(a + b, 43) + Long.rotateRight(c, 30) + d, a + Long.rotateRight(b + -7286425919675154353L, 18) + c, mul);
    }

    private static long hashCharsToLongLength9to16(CharSequence input) {
        int len = input.length();
        long mul = -7286425919675154353L + (long)(len << 2);
        long a = AbstractFarmHash.getLong(input, 0) * -5435081209227447693L;
        long b = AbstractFarmHash.getLong(input, 4);
        long c = AbstractFarmHash.getLong(input, len - 4) * mul;
        long d = AbstractFarmHash.getLong(input, len - 8) * -7286425919675154353L;
        return AbstractFarmHash.hashLength16(Long.rotateRight(a + b, 43) + Long.rotateRight(c, 30) + d, a + Long.rotateRight(b + -7286425919675154353L, 18) + c, mul);
    }

    private static long hashBytesToLongLength33To64(byte[] bytes, int offset, int length) {
        long mul = -7286425919675154353L + (long)(length << 1);
        long a = AbstractFarmHash.getLong(bytes, offset) * -7286425919675154353L;
        long b = AbstractFarmHash.getLong(bytes, offset + 8);
        long c = AbstractFarmHash.getLong(bytes, offset + length - 8) * mul;
        long d = AbstractFarmHash.getLong(bytes, offset + length - 16) * -7286425919675154353L;
        long y = Long.rotateRight(a + b, 43) + Long.rotateRight(c, 30) + d;
        long z = AbstractFarmHash.hashLength16(y, a + Long.rotateRight(b + -7286425919675154353L, 18) + c, mul);
        long e = AbstractFarmHash.getLong(bytes, offset + 16) * mul;
        long f = AbstractFarmHash.getLong(bytes, offset + 24);
        long g = (y + AbstractFarmHash.getLong(bytes, offset + length - 32)) * mul;
        long h = (z + AbstractFarmHash.getLong(bytes, offset + length - 24)) * mul;
        return AbstractFarmHash.hashLength16(Long.rotateRight(e + f, 43) + Long.rotateRight(g, 30) + h, e + Long.rotateRight(f + a, 18) + g, mul);
    }

    private static long hashCharsToLongLength17To32(CharSequence input) {
        int len = input.length();
        long mul = -7286425919675154353L + (long)(len << 2);
        long a = AbstractFarmHash.getLong(input, 0) * -7286425919675154353L;
        long b = AbstractFarmHash.getLong(input, 4);
        long c = AbstractFarmHash.getLong(input, len - 4) * mul;
        long d = AbstractFarmHash.getLong(input, len - 8) * -7286425919675154353L;
        long y = Long.rotateRight(a + b, 43) + Long.rotateRight(c, 30) + d;
        long z = AbstractFarmHash.hashLength16(y, a + Long.rotateRight(b + -7286425919675154353L, 18) + c, mul);
        long e = AbstractFarmHash.getLong(input, 8) * mul;
        long f = AbstractFarmHash.getLong(input, 12);
        long g = (y + AbstractFarmHash.getLong(input, len - 16)) * mul;
        long h = (z + AbstractFarmHash.getLong(input, len - 12)) * mul;
        return AbstractFarmHash.hashLength16(Long.rotateRight(e + f, 43) + Long.rotateRight(g, 30) + h, e + Long.rotateRight(f + a, 18) + g, mul);
    }

    private static long hashLength16(long u, long v, long mul) {
        long a = (u ^ v) * mul;
        a ^= a >>> 47;
        long b = (v ^ a) * mul;
        b ^= b >>> 47;
        return b *= mul;
    }

    @Override
    public final long hashCharsToLong(CharSequence input) {
        long len = input.length();
        if (len <= 16L) {
            if (len <= 8L) {
                return this.finalizeHash(AbstractFarmHash.hashCharsToLongLength0to8(input));
            }
            return this.finalizeHash(AbstractFarmHash.hashCharsToLongLength9to16(input));
        }
        if (len <= 32L) {
            return this.finalizeHash(AbstractFarmHash.hashCharsToLongLength17To32(input));
        }
        return this.hashCharsToLongLength33Plus(input);
    }

    protected abstract long hashCharsToLongLength33Plus(CharSequence var1);

    @Override
    public final long hashLongLongToLong(long v1, long v2) {
        long mul = -7286425919675154321L;
        long a = v1 + -7286425919675154353L;
        return this.finalizeHash(AbstractFarmHash.hashLength16(Long.rotateRight(v2, 37) * mul + a, (Long.rotateRight(a, 25) + v2) * mul, mul));
    }

    @Override
    public final long hashLongLongLongToLong(long v1, long v2, long v3) {
        long mul = -7286425919675154305L;
        long a = v1 * -5435081209227447693L;
        long c = v3 * mul;
        return this.finalizeHash(AbstractFarmHash.hashLength16(Long.rotateRight(a + v2, 43) + Long.rotateRight(c, 30) + v2 * -7286425919675154353L, a + Long.rotateRight(v2 + -7286425919675154353L, 18) + c, mul));
    }

    protected static abstract class FarmHashStreamImpl
    extends AbstractHashStream64 {
        protected final byte[] buffer = new byte[80];
        protected int bufferCount = 8;
        protected boolean init = true;

        protected FarmHashStreamImpl() {
        }

        protected abstract void processBuffer(long var1, long var3, long var5, long var7, long var9, long var11, long var13, long var15);

        private void processBuffer() {
            long b0 = AbstractHasher.getLong(this.buffer, 8);
            long b1 = AbstractHasher.getLong(this.buffer, 16);
            long b2 = AbstractHasher.getLong(this.buffer, 24);
            long b3 = AbstractHasher.getLong(this.buffer, 32);
            long b4 = AbstractHasher.getLong(this.buffer, 40);
            long b5 = AbstractHasher.getLong(this.buffer, 48);
            long b6 = AbstractHasher.getLong(this.buffer, 56);
            long b7 = AbstractHasher.getLong(this.buffer, 64);
            this.processBuffer(b0, b1, b2, b3, b4, b5, b6, b7);
        }

        @Override
        public final HashStream64 putByte(byte v) {
            if (this.bufferCount >= 72) {
                this.processBuffer();
                this.bufferCount = 8;
            }
            this.buffer[this.bufferCount] = v;
            ++this.bufferCount;
            return this;
        }

        @Override
        public final HashStream64 putShort(short v) {
            AbstractHasher.setShort(this.buffer, this.bufferCount, v);
            if (this.bufferCount >= 71) {
                this.processBuffer();
                this.bufferCount -= 64;
                AbstractHasher.setShort(this.buffer, this.bufferCount, v);
            }
            this.bufferCount += 2;
            return this;
        }

        @Override
        public final HashStream64 putChar(char v) {
            AbstractHasher.setChar(this.buffer, this.bufferCount, v);
            if (this.bufferCount >= 71) {
                this.processBuffer();
                this.bufferCount -= 64;
                AbstractHasher.setChar(this.buffer, this.bufferCount, v);
            }
            this.bufferCount += 2;
            return this;
        }

        @Override
        public final HashStream64 putInt(int v) {
            AbstractHasher.setInt(this.buffer, this.bufferCount, v);
            if (this.bufferCount >= 69) {
                this.processBuffer();
                this.bufferCount -= 64;
                AbstractHasher.setInt(this.buffer, this.bufferCount, v);
            }
            this.bufferCount += 4;
            return this;
        }

        @Override
        public final HashStream64 putLong(long v) {
            AbstractHasher.setLong(this.buffer, this.bufferCount, v);
            if (this.bufferCount >= 65) {
                this.processBuffer();
                this.bufferCount -= 64;
                AbstractHasher.setLong(this.buffer, this.bufferCount, v);
            }
            this.bufferCount += 8;
            return this;
        }

        @Override
        public final HashStream64 putBytes(byte[] b, int off, int len) {
            int regularBlockStartIdx = 8 - this.bufferCount & 0x3F;
            int regularBlockEndIdx = len - 64 + (-len + regularBlockStartIdx & 0x3F);
            if (regularBlockEndIdx < regularBlockStartIdx) {
                System.arraycopy(b, off, this.buffer, this.bufferCount, len);
                this.bufferCount += len;
                return this;
            }
            System.arraycopy(b, off, this.buffer, this.bufferCount, regularBlockStartIdx);
            if (this.bufferCount > 8) {
                long b0 = AbstractHasher.getLong(this.buffer, 8);
                long b1 = AbstractHasher.getLong(this.buffer, 16);
                long b2 = AbstractHasher.getLong(this.buffer, 24);
                long b3 = AbstractHasher.getLong(this.buffer, 32);
                long b4 = AbstractHasher.getLong(this.buffer, 40);
                long b5 = AbstractHasher.getLong(this.buffer, 48);
                long b6 = AbstractHasher.getLong(this.buffer, 56);
                long b7 = AbstractHasher.getLong(this.buffer, 64);
                this.processBuffer(b0, b1, b2, b3, b4, b5, b6, b7);
            }
            int remainingBytes = len - regularBlockEndIdx;
            if (regularBlockEndIdx > regularBlockStartIdx) {
                for (int i = off + regularBlockStartIdx; i < off + regularBlockEndIdx; i += 64) {
                    long b0 = AbstractHasher.getLong(b, i);
                    long b1 = AbstractHasher.getLong(b, i + 8);
                    long b2 = AbstractHasher.getLong(b, i + 16);
                    long b3 = AbstractHasher.getLong(b, i + 24);
                    long b4 = AbstractHasher.getLong(b, i + 32);
                    long b5 = AbstractHasher.getLong(b, i + 40);
                    long b6 = AbstractHasher.getLong(b, i + 48);
                    long b7 = AbstractHasher.getLong(b, i + 56);
                    this.processBuffer(b0, b1, b2, b3, b4, b5, b6, b7);
                }
                System.arraycopy(b, off - 64 + len, this.buffer, 8 + remainingBytes, 64 - remainingBytes);
            }
            System.arraycopy(b, off + regularBlockEndIdx, this.buffer, 8, remainingBytes);
            this.bufferCount = 8 + remainingBytes;
            return this;
        }

        @Override
        public final HashStream64 putChars(CharSequence s) {
            int idx = 0;
            if (s.length() >= 74 - this.bufferCount >> 1) {
                idx = 73 - this.bufferCount >>> 1;
                AbstractHasher.copyCharsToByteArray(s, 0, this.buffer, this.bufferCount, idx);
                this.processBuffer();
                int a = this.bufferCount & 1;
                this.bufferCount = 8 - a;
                int lenMinus32 = s.length() - 32;
                if ((idx -= a) < lenMinus32) {
                    long b7;
                    long b6;
                    long b5;
                    long b4;
                    long b3;
                    long b2;
                    long b1;
                    long b0;
                    do {
                        b0 = AbstractHasher.getLong(s, idx);
                        b1 = AbstractHasher.getLong(s, idx + 4);
                        b2 = AbstractHasher.getLong(s, idx + 8);
                        b3 = AbstractHasher.getLong(s, idx + 12);
                        b4 = AbstractHasher.getLong(s, idx + 16);
                        b5 = AbstractHasher.getLong(s, idx + 20);
                        b6 = AbstractHasher.getLong(s, idx + 24);
                        b7 = AbstractHasher.getLong(s, idx + 28);
                        if (a != 0) {
                            b0 = b0 >>> 8 | b1 << 56;
                            b1 = b1 >>> 8 | b2 << 56;
                            b2 = b2 >>> 8 | b3 << 56;
                            b3 = b3 >>> 8 | b4 << 56;
                            b4 = b4 >>> 8 | b5 << 56;
                            b5 = b5 >>> 8 | b6 << 56;
                            b6 = b6 >>> 8 | b7 << 56;
                            b7 = b7 >>> 8 | (long)s.charAt(idx + 32) << 56;
                        }
                        this.processBuffer(b0, b1, b2, b3, b4, b5, b6, b7);
                    } while ((idx += 32) < lenMinus32);
                    AbstractHasher.setLong(this.buffer, 8, b0);
                    AbstractHasher.setLong(this.buffer, 16, b1);
                    AbstractHasher.setLong(this.buffer, 24, b2);
                    AbstractHasher.setLong(this.buffer, 32, b3);
                    AbstractHasher.setLong(this.buffer, 40, b4);
                    AbstractHasher.setLong(this.buffer, 48, b5);
                    AbstractHasher.setLong(this.buffer, 56, b6);
                    AbstractHasher.setLong(this.buffer, 64, b7);
                }
            }
            AbstractHasher.copyCharsToByteArray(s, idx, this.buffer, this.bufferCount, s.length() - idx);
            this.bufferCount += s.length() - idx << 1;
            return this;
        }

        protected final long hashLen0To16(int bufferCount) {
            if (bufferCount >= 16) {
                long a = AbstractHasher.getLong(this.buffer, 8);
                long b = AbstractHasher.getLong(this.buffer, bufferCount - 8);
                return AbstractFarmHash.hash8To16Bytes(bufferCount, a, b);
            }
            if (bufferCount >= 12) {
                long a = (long)AbstractHasher.getInt(this.buffer, 8) & 0xFFFFFFFFL;
                long b = (long)AbstractHasher.getInt(this.buffer, bufferCount - 4) & 0xFFFFFFFFL;
                return AbstractFarmHash.hash4To7Bytes(bufferCount, a, b);
            }
            if (bufferCount > 8) {
                int a = this.buffer[8] & 0xFF;
                int b = this.buffer[(bufferCount >>> 1) + 4] & 0xFF;
                int c = this.buffer[bufferCount - 1] & 0xFF;
                return AbstractFarmHash.hash1To3Bytes(bufferCount, a, b, c);
            }
            return -7286425919675154353L;
        }

        protected final long hashLen17To32(int bufferCount) {
            long mul = AbstractFarmHash.mul(bufferCount);
            long a = AbstractHasher.getLong(this.buffer, 8) * -5435081209227447693L;
            long b = AbstractHasher.getLong(this.buffer, 16);
            long c = AbstractHasher.getLong(this.buffer, bufferCount - 8) * mul;
            long d = AbstractHasher.getLong(this.buffer, bufferCount - 16) * -7286425919675154353L;
            return AbstractFarmHash.hashLen16(Long.rotateRight(a + b, 43) + Long.rotateRight(c, 30) + d, a + Long.rotateRight(b + -7286425919675154353L, 18) + c, mul);
        }

        protected final long hashLen33To64(int bufferCount) {
            long mul = AbstractFarmHash.mul(bufferCount);
            long a = AbstractHasher.getLong(this.buffer, 8) * -7286425919675154353L;
            long b = AbstractHasher.getLong(this.buffer, 16);
            long c = AbstractHasher.getLong(this.buffer, bufferCount - 8) * mul;
            long d = AbstractHasher.getLong(this.buffer, bufferCount - 16) * -7286425919675154353L;
            long yy = Long.rotateRight(a + b, 43) + Long.rotateRight(c, 30) + d;
            long zz = AbstractFarmHash.hashLen16(yy, a + Long.rotateRight(b + -7286425919675154353L, 18) + c, mul);
            long e = AbstractHasher.getLong(this.buffer, 24) * mul;
            long f = AbstractHasher.getLong(this.buffer, 32);
            long g = (yy + AbstractHasher.getLong(this.buffer, bufferCount - 32)) * mul;
            long h = (zz + AbstractHasher.getLong(this.buffer, bufferCount - 24)) * mul;
            return AbstractFarmHash.hashLen16(Long.rotateRight(e + f, 43) + Long.rotateRight(g, 30) + h, e + Long.rotateRight(f + a, 18) + g, mul);
        }
    }
}

