/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.hash4j.hashing;

import com.dynatrace.hash4j.hashing.AbstractHashStream;
import com.dynatrace.hash4j.hashing.HashFunnel;
import com.dynatrace.hash4j.hashing.HashStream32;
import com.dynatrace.hash4j.hashing.HashStream64;
import com.dynatrace.hash4j.hashing.Hasher64;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.UUID;
import java.util.function.ToLongFunction;

abstract class AbstractHashStream32
extends AbstractHashStream
implements HashStream32 {
    AbstractHashStream32() {
    }

    @Override
    public int getHashBitSize() {
        return 32;
    }

    @Override
    public HashStream32 putBoolean(boolean v) {
        super.putBoolean(v);
        return this;
    }

    @Override
    public HashStream32 putBooleans(boolean[] x) {
        super.putBooleans(x);
        return this;
    }

    @Override
    public HashStream32 putBooleans(boolean[] x, int off, int len) {
        super.putBooleans(x, off, len);
        return this;
    }

    @Override
    public HashStream32 putBooleanArray(boolean[] x) {
        super.putBooleanArray(x);
        return this;
    }

    @Override
    public HashStream32 putBytes(byte[] b) {
        super.putBytes(b);
        return this;
    }

    @Override
    public HashStream32 putBytes(byte[] b, int off, int len) {
        super.putBytes(b, off, len);
        return this;
    }

    @Override
    public HashStream32 putByteArray(byte[] x) {
        super.putByteArray(x);
        return this;
    }

    @Override
    public HashStream32 putChar(char v) {
        super.putChar(v);
        return this;
    }

    @Override
    public HashStream32 putChars(char[] x) {
        super.putChars(x);
        return this;
    }

    @Override
    public HashStream32 putChars(char[] x, int off, int len) {
        super.putChars(x, off, len);
        return this;
    }

    @Override
    public HashStream32 putChars(CharSequence s) {
        super.putChars(s);
        return this;
    }

    @Override
    public HashStream32 putCharArray(char[] x) {
        super.putCharArray(x);
        return this;
    }

    @Override
    public HashStream32 putString(String s) {
        super.putString(s);
        return this;
    }

    @Override
    public HashStream32 putShort(short v) {
        super.putShort(v);
        return this;
    }

    @Override
    public HashStream32 putShortArray(short[] x) {
        super.putShortArray(x);
        return this;
    }

    @Override
    public HashStream32 putShorts(short[] x) {
        super.putShorts(x);
        return this;
    }

    @Override
    public HashStream32 putShorts(short[] x, int off, int len) {
        super.putShorts(x, off, len);
        return this;
    }

    @Override
    public HashStream32 putInt(int v) {
        super.putInt(v);
        return this;
    }

    @Override
    public HashStream32 putIntArray(int[] x) {
        super.putIntArray(x);
        return this;
    }

    @Override
    public HashStream32 putInts(int[] x) {
        super.putInts(x);
        return this;
    }

    @Override
    public HashStream32 putInts(int[] x, int off, int len) {
        super.putInts(x, off, len);
        return this;
    }

    @Override
    public HashStream32 putLong(long v) {
        super.putLong(v);
        return this;
    }

    @Override
    public HashStream32 putLongArray(long[] x) {
        super.putLongArray(x);
        return this;
    }

    @Override
    public HashStream32 putLongs(long[] x) {
        super.putLongs(x);
        return this;
    }

    @Override
    public HashStream32 putLongs(long[] x, int off, int len) {
        super.putLongs(x, off, len);
        return this;
    }

    @Override
    public HashStream32 putFloat(float v) {
        super.putFloat(v);
        return this;
    }

    @Override
    public HashStream32 putFloats(float[] x) {
        super.putFloats(x);
        return this;
    }

    @Override
    public HashStream32 putFloats(float[] x, int off, int len) {
        super.putFloats(x, off, len);
        return this;
    }

    @Override
    public HashStream32 putFloatArray(float[] x) {
        super.putFloatArray(x);
        return this;
    }

    @Override
    public HashStream32 putDouble(double v) {
        super.putDouble(v);
        return this;
    }

    @Override
    public HashStream32 putDoubleArray(double[] x) {
        super.putDoubleArray(x);
        return this;
    }

    @Override
    public HashStream32 putDoubles(double[] x) {
        super.putDoubles(x);
        return this;
    }

    @Override
    public HashStream32 putDoubles(double[] x, int off, int len) {
        super.putDoubles(x, off, len);
        return this;
    }

    @Override
    public HashStream32 putUUID(UUID uuid) {
        super.putUUID(uuid);
        return this;
    }

    @Override
    public <T> HashStream32 put(T data, HashFunnel<T> funnel) {
        super.put((Object)data, (HashFunnel)funnel);
        return this;
    }

    @Override
    public <T> HashStream32 putNullable(T data, HashFunnel<T> funnel) {
        super.putNullable((Object)data, (HashFunnel)funnel);
        return this;
    }

    @Override
    public <T> HashStream32 putOrderedIterable(Iterable<T> data, HashFunnel<? super T> funnel) {
        super.putOrderedIterable((Iterable)data, (HashFunnel)funnel);
        return this;
    }

    @Override
    public <T> HashStream32 putUnorderedIterable(Iterable<T> data, HashFunnel<? super T> funnel, Hasher64 hasher) {
        super.putUnorderedIterable((Iterable)data, (HashFunnel)funnel, hasher);
        return this;
    }

    @Override
    public <T> HashStream32 putUnorderedIterable(Iterable<T> data, HashFunnel<? super T> funnel, HashStream64 hashStream) {
        super.putUnorderedIterable((Iterable)data, (HashFunnel)funnel, hashStream);
        return this;
    }

    @Override
    public <T> HashStream32 putUnorderedIterable(Iterable<T> data, ToLongFunction<? super T> elementHashFunction) {
        super.putUnorderedIterable((Iterable)data, (ToLongFunction)elementHashFunction);
        return this;
    }

    @Override
    public <T> HashStream32 putOptional(Optional<T> obj, HashFunnel<? super T> funnel) {
        super.putOptional((Optional)obj, (HashFunnel)funnel);
        return this;
    }

    @Override
    public HashStream32 putOptionalInt(OptionalInt v) {
        super.putOptionalInt(v);
        return this;
    }

    @Override
    public HashStream32 putOptionalLong(OptionalLong v) {
        super.putOptionalLong(v);
        return this;
    }

    @Override
    public HashStream32 putOptionalDouble(OptionalDouble v) {
        super.putOptionalDouble(v);
        return this;
    }

    @Override
    public <T> int resetAndHashToInt(T obj, HashFunnel<T> funnel) {
        funnel.put(obj, this.reset());
        return this.getAsInt();
    }
}

