/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.hash4j.hashing;

import com.dynatrace.hash4j.hashing.AbstractFarmHash;
import com.dynatrace.hash4j.hashing.AbstractHasher;
import com.dynatrace.hash4j.hashing.HashStream64;
import com.dynatrace.hash4j.hashing.Hasher64;

class FarmHashNa
extends AbstractFarmHash {
    private static final long START_X = 95310865018149119L;
    private static final long START_Y = 2480279821605975764L;
    private static final long START_Z = 1390051526045402406L;
    private static final FarmHashNa INSTANCE = new FarmHashNa();

    FarmHashNa() {
    }

    static Hasher64 create() {
        return INSTANCE;
    }

    static Hasher64 create(final long seed) {
        return new FarmHashNa(){

            @Override
            protected long finalizeHash(long hash) {
                return 1.hashLen16(hash - -7286425919675154353L, seed, -7070675565921424023L);
            }
        };
    }

    static Hasher64 create(final long seed0, final long seed1) {
        return new FarmHashNa(){

            @Override
            protected long finalizeHash(long hash) {
                return 2.hashLen16(hash - seed0, seed1, -7070675565921424023L);
            }
        };
    }

    @Override
    public HashStream64 hashStream() {
        return new HashStreamImpl();
    }

    @Override
    protected long hashBytesToLongLength65Plus(byte[] bytes, int offset, int length) {
        long b7;
        long b6;
        long b5;
        long b4;
        long b3;
        long b2;
        long b1;
        long b0;
        int seed = 81;
        long x = seed;
        long y = (long)seed * -5435081209227447693L + 113L;
        long z = FarmHashNa.shiftMix(y * -7286425919675154353L + 113L) * -7286425919675154353L;
        long v0 = 0L;
        long v1 = 0L;
        long w0 = 0L;
        long w1 = 0L;
        int end = offset + (length - 1 & 0xFFFFFFC0);
        int last64offset = offset + length - 64;
        x = x * -7286425919675154353L + FarmHashNa.getLong(bytes, offset);
        do {
            b0 = FarmHashNa.getLong(bytes, offset);
            b1 = FarmHashNa.getLong(bytes, offset + 8);
            b2 = FarmHashNa.getLong(bytes, offset + 16);
            b3 = FarmHashNa.getLong(bytes, offset + 24);
            b4 = FarmHashNa.getLong(bytes, offset + 32);
            b5 = FarmHashNa.getLong(bytes, offset + 40);
            b6 = FarmHashNa.getLong(bytes, offset + 48);
            b7 = FarmHashNa.getLong(bytes, offset + 56);
            x = Long.rotateRight(x + y + v0 + b1, 37) * -5435081209227447693L ^ w1;
            y = Long.rotateRight(y + v1 + b6, 42) * -5435081209227447693L + v0 + b5;
            z = Long.rotateRight(z + w0, 33) * -5435081209227447693L;
            v1 *= -5435081209227447693L;
            v0 = (v1 += b0) + (b1 + b2);
            v1 += Long.rotateRight(x + w0 + v1 + b3, 21);
            v1 += Long.rotateRight(v0, 44);
            w0 = (w1 += z + b4) + (b5 + b6);
            w1 += Long.rotateRight(y + w1 + b2 + b7, 21);
            w1 += Long.rotateRight(w0, 44);
            v0 += b3;
            w0 += b7;
            long t = z;
            z = x;
            x = t;
        } while ((offset += 64) != end);
        b0 = FarmHashNa.getLong(bytes, last64offset);
        b1 = FarmHashNa.getLong(bytes, last64offset + 8);
        b2 = FarmHashNa.getLong(bytes, last64offset + 16);
        b3 = FarmHashNa.getLong(bytes, last64offset + 24);
        b4 = FarmHashNa.getLong(bytes, last64offset + 32);
        b5 = FarmHashNa.getLong(bytes, last64offset + 40);
        b6 = FarmHashNa.getLong(bytes, last64offset + 48);
        b7 = FarmHashNa.getLong(bytes, last64offset + 56);
        return this.finalizeHash(x, y, z, v0, v1, w0 += (long)(length - 1 & 0x3F), w1, b0, b1, b2, b3, b4, b5, b6, b7);
    }

    @Override
    protected long hashCharsToLongLength33Plus(CharSequence input) {
        long b7;
        long b6;
        long b5;
        long b4;
        long b3;
        long b2;
        long b1;
        long b0;
        int len = input.length();
        int seed = 81;
        long x = seed;
        long y = (long)seed * -5435081209227447693L + 113L;
        long z = FarmHashNa.shiftMix(y * -7286425919675154353L + 113L) * -7286425919675154353L;
        long v0 = 0L;
        long v1 = 0L;
        long w0 = 0L;
        long w1 = 0L;
        int end = len - 1 & 0xFFFFFFE0;
        int last64offset = len - 32;
        x = x * -7286425919675154353L + FarmHashNa.getLong(input, 0);
        int offset = 0;
        do {
            b0 = FarmHashNa.getLong(input, offset + 0);
            b1 = FarmHashNa.getLong(input, offset + 4);
            b2 = FarmHashNa.getLong(input, offset + 8);
            b3 = FarmHashNa.getLong(input, offset + 12);
            b4 = FarmHashNa.getLong(input, offset + 16);
            b5 = FarmHashNa.getLong(input, offset + 20);
            b6 = FarmHashNa.getLong(input, offset + 24);
            b7 = FarmHashNa.getLong(input, offset + 28);
            x = Long.rotateRight(x + y + v0 + b1, 37) * -5435081209227447693L ^ w1;
            y = Long.rotateRight(y + v1 + b6, 42) * -5435081209227447693L + v0 + b5;
            z = Long.rotateRight(z + w0, 33) * -5435081209227447693L;
            v1 *= -5435081209227447693L;
            v0 = (v1 += b0) + (b1 + b2);
            v1 += Long.rotateRight(x + w0 + v1 + b3, 21);
            v1 += Long.rotateRight(v0, 44);
            w0 = (w1 += z + b4) + (b5 + b6);
            w1 += Long.rotateRight(y + w1 + b2 + b7, 21);
            w1 += Long.rotateRight(w0, 44);
            v0 += b3;
            w0 += b7;
            long t = z;
            z = x;
            x = t;
        } while ((offset += 32) != end);
        b0 = FarmHashNa.getLong(input, last64offset);
        b1 = FarmHashNa.getLong(input, last64offset + 4);
        b2 = FarmHashNa.getLong(input, last64offset + 8);
        b3 = FarmHashNa.getLong(input, last64offset + 12);
        b4 = FarmHashNa.getLong(input, last64offset + 16);
        b5 = FarmHashNa.getLong(input, last64offset + 20);
        b6 = FarmHashNa.getLong(input, last64offset + 24);
        b7 = FarmHashNa.getLong(input, last64offset + 28);
        return this.finalizeHash(x, y, z, v0, v1, w0 += (long)((len << 1) - 1 & 0x3F), w1, b0, b1, b2, b3, b4, b5, b6, b7);
    }

    private long finalizeHash(long x, long y, long z, long v0, long v1, long w0, long w1, long b0, long b1, long b2, long b3, long b4, long b5, long b6, long b7) {
        long mul = -5435081209227447693L + ((z & 0xFFL) << 1);
        v0 += w0;
        x = Long.rotateRight(x + y + v0 + b1, 37) * mul;
        y = Long.rotateRight(y + v1 + b6, 42) * mul;
        z = Long.rotateRight(z + (w0 += v0), 33) * mul;
        long c0 = v1 * mul + b0;
        long a0 = c0 + (b1 + b2);
        long c1 = z + w1 + b4;
        long a1 = c1 + (b5 + b6);
        return this.finalizeHash(FarmHashNa.hashLen16(FarmHashNa.hashLen16(a0 + b3, a1 + b7, mul) + FarmHashNa.shiftMix(y += v0 * 9L + b5) * -4348849565147123417L + (x ^= w1 * 9L), FarmHashNa.hashLen16(Long.rotateRight(x + w0 + c0 + b3, 21) + Long.rotateRight(a0, 44) + c0, Long.rotateRight(y + b2 + c1 + b7, 21) + Long.rotateRight(a1, 44) + c1, mul) + z, mul));
    }

    private class HashStreamImpl
    extends AbstractFarmHash.FarmHashStreamImpl {
        private long x = 95310865018149119L;
        private long y = 2480279821605975764L;
        private long z = 1390051526045402406L;
        private long v0 = 0L;
        private long v1 = 0L;
        private long w0 = 0L;
        private long w1 = 0L;

        private HashStreamImpl() {
        }

        @Override
        public HashStream64 reset() {
            this.x = 95310865018149119L;
            this.y = 2480279821605975764L;
            this.z = 1390051526045402406L;
            this.v0 = 0L;
            this.v1 = 0L;
            this.w0 = 0L;
            this.w1 = 0L;
            this.bufferCount = 8;
            this.init = true;
            return this;
        }

        @Override
        public HashStream64 copy() {
            HashStreamImpl hashStream = new HashStreamImpl();
            hashStream.x = this.x;
            hashStream.y = this.y;
            hashStream.z = this.z;
            hashStream.v0 = this.v0;
            hashStream.v1 = this.v1;
            hashStream.w0 = this.w0;
            hashStream.w1 = this.w1;
            hashStream.bufferCount = this.bufferCount;
            hashStream.init = this.init;
            System.arraycopy(this.buffer, 0, hashStream.buffer, 0, this.buffer.length);
            return hashStream;
        }

        @Override
        protected void processBuffer(long b0, long b1, long b2, long b3, long b4, long b5, long b6, long b7) {
            if (this.init) {
                this.x += b0;
            }
            this.init = false;
            this.x = Long.rotateRight(this.x + this.y + this.v0 + b1, 37) * -5435081209227447693L ^ this.w1;
            this.y = Long.rotateRight(this.y + this.v1 + b6, 42) * -5435081209227447693L + this.v0 + b5;
            this.z = Long.rotateRight(this.z + this.w0, 33) * -5435081209227447693L;
            this.v1 *= -5435081209227447693L;
            this.v1 += b0;
            this.v0 = this.v1 + (b1 + b2);
            this.v1 += Long.rotateRight(this.x + this.w0 + this.v1 + b3, 21);
            this.v1 += Long.rotateRight(this.v0, 44);
            this.w1 += this.z + b4;
            this.w0 = this.w1 + (b5 + b6);
            this.w1 += Long.rotateRight(this.y + this.w1 + b2 + b7, 21);
            this.w1 += Long.rotateRight(this.w0, 44);
            this.v0 += b3;
            this.w0 += b7;
            long t = this.z;
            this.z = this.x;
            this.x = t;
        }

        @Override
        public long getAsLong() {
            if (this.init) {
                if (this.bufferCount <= 40) {
                    if (this.bufferCount <= 24) {
                        return FarmHashNa.this.finalizeHash(this.hashLen0To16(this.bufferCount));
                    }
                    return FarmHashNa.this.finalizeHash(this.hashLen17To32(this.bufferCount));
                }
                return FarmHashNa.this.finalizeHash(this.hashLen33To64(this.bufferCount));
            }
            AbstractHasher.setLong(this.buffer, 0, AbstractHasher.getLong(this.buffer, 64));
            long b0 = AbstractHasher.getLong(this.buffer, this.bufferCount & 0x3F);
            long b1 = AbstractHasher.getLong(this.buffer, this.bufferCount + 8 & 0x3F);
            long b2 = AbstractHasher.getLong(this.buffer, this.bufferCount + 16 & 0x3F);
            long b3 = AbstractHasher.getLong(this.buffer, this.bufferCount + 24 & 0x3F);
            long b4 = AbstractHasher.getLong(this.buffer, this.bufferCount + 32 & 0x3F);
            long b5 = AbstractHasher.getLong(this.buffer, this.bufferCount + 40 & 0x3F);
            long b6 = AbstractHasher.getLong(this.buffer, this.bufferCount + 48 & 0x3F);
            long b7 = AbstractHasher.getLong(this.buffer, this.bufferCount - 8);
            return FarmHashNa.this.finalizeHash(this.x, this.y, this.z, this.v0, this.v1, this.w0 + (long)this.bufferCount - 9L, this.w1, b0, b1, b2, b3, b4, b5, b6, b7);
        }
    }
}

