/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.hash4j.hashing;

import com.dynatrace.hash4j.hashing.AbstractHashStream64;
import com.dynatrace.hash4j.hashing.AbstractHasher;
import com.dynatrace.hash4j.hashing.AbstractHasher64;
import com.dynatrace.hash4j.hashing.HashStream64;
import com.dynatrace.hash4j.hashing.Hasher64;
import com.dynatrace.hash4j.hashing.UnsignedMultiplyUtil;

class XXH3_64
extends AbstractHasher64 {
    private static final long SECRET_00 = -4734510112055689544L;
    private static final long SECRET_01 = 2066345149520216444L;
    private static final long SECRET_02 = -2623469361688619810L;
    private static final long SECRET_03 = 2262974939099578482L;
    private static final long SECRET_04 = 8711581037947681227L;
    private static final long SECRET_05 = 2410270004345854594L;
    private static final long SECRET_06 = -8204357891075471176L;
    private static final long SECRET_07 = 5487137525590930912L;
    private static final long SECRET_08 = -3818837453329782724L;
    private static final long SECRET_09 = -6688317018830679928L;
    private static final long SECRET_10 = 5690594596133299313L;
    private static final long SECRET_11 = -2833645246901970632L;
    private static final long SECRET_12 = 4554437623014685352L;
    private static final long SECRET_13 = 2111919702937427193L;
    private static final long SECRET_14 = 3556072174620004746L;
    private static final long SECRET_15 = 7238261902898274248L;
    private static final long SECRET_16 = -4329134394285701654L;
    private static final long SECRET_17 = -1485321483350670907L;
    private static final long SECRET_18 = 5321830579834785047L;
    private static final long SECRET_19 = -7032137544937171245L;
    private static final long SECRET_20 = -242834301215959509L;
    private static final long SECRET_21 = -3588858202114426737L;
    private static final long SECRET_22 = 2883454493032893253L;
    private static final long SECRET_23 = 9097354517224871855L;
    private static final long INIT_ACC_0 = 3266489917L;
    private static final long INIT_ACC_1 = -7046029288634856825L;
    private static final long INIT_ACC_2 = -4417276706812531889L;
    private static final long INIT_ACC_3 = 1609587929392839161L;
    private static final long INIT_ACC_4 = -8796714831421723037L;
    private static final long INIT_ACC_5 = 2246822519L;
    private static final long INIT_ACC_6 = 2870177450012600261L;
    private static final long INIT_ACC_7 = 2654435761L;
    private static final int BLOCK_LEN_EXP = 10;
    private final long secShift00;
    private final long secShift01;
    private final long secShift02;
    private final long secShift03;
    private final long secShift04;
    private final long secShift05;
    private final long secShift06;
    private final long secShift07;
    private final long secShift08;
    private final long secShift09;
    private final long secShift10;
    private final long secShift11;
    private final long secShift12;
    private final long secShift13;
    private final long secShift14;
    private final long secShift15;
    private final long secShift16;
    private final long secShift17;
    private final long secShift18;
    private final long secShift19;
    private final long secShift20;
    private final long secShift21;
    private final long secShift22;
    private final long secShift23;
    private final long secShiftFinal0;
    private final long secShiftFinal1;
    private final long secShiftFinal2;
    private final long secShiftFinal3;
    private final long secShiftFinal4;
    private final long secShiftFinal5;
    private final long secShiftFinal6;
    private final long secShiftFinal7;
    private final long secret00;
    private final long secret01;
    private final long secret02;
    private final long secret03;
    private final long secret04;
    private final long secret05;
    private final long secret06;
    private final long secret07;
    private final long secret08;
    private final long secret09;
    private final long secret10;
    private final long secret11;
    private final long secret12;
    private final long secret13;
    private final long secret14;
    private final long secret15;
    private final long secret16;
    private final long secret17;
    private final long secret18;
    private final long secret19;
    private final long secret20;
    private final long secret21;
    private final long secret22;
    private final long secret23;
    private final long bitflip00;
    private final long bitflip12;
    private final long bitflip34;
    private final long bitflip56;
    private final long hash0;
    private final long[] secret;
    private static final Hasher64 DEFAULT_HASHER_INSTANCE = new XXH3_64();

    private XXH3_64(long seed) {
        this.secret00 = -4734510112055689544L + seed;
        this.secret01 = 2066345149520216444L - seed;
        this.secret02 = -2623469361688619810L + seed;
        this.secret03 = 2262974939099578482L - seed;
        this.secret04 = 8711581037947681227L + seed;
        this.secret05 = 2410270004345854594L - seed;
        this.secret06 = -8204357891075471176L + seed;
        this.secret07 = 5487137525590930912L - seed;
        this.secret08 = -3818837453329782724L + seed;
        this.secret09 = -6688317018830679928L - seed;
        this.secret10 = 5690594596133299313L + seed;
        this.secret11 = -2833645246901970632L - seed;
        this.secret12 = 4554437623014685352L + seed;
        this.secret13 = 2111919702937427193L - seed;
        this.secret14 = 3556072174620004746L + seed;
        this.secret15 = 7238261902898274248L - seed;
        this.secret16 = -4329134394285701654L + seed;
        this.secret17 = -1485321483350670907L - seed;
        this.secret18 = 5321830579834785047L + seed;
        this.secret19 = -7032137544937171245L - seed;
        this.secret20 = -242834301215959509L + seed;
        this.secret21 = -3588858202114426737L - seed;
        this.secret22 = 2883454493032893253L + seed;
        this.secret23 = 9097354517224871855L - seed;
        this.secShift00 = -9150895811085458631L + seed;
        this.secShift01 = 7914194659941938988L - seed;
        this.secShift02 = -6611157965513653271L + seed;
        this.secShift03 = -1839215637059881052L - seed;
        this.secShift04 = -3433288310154277810L + seed;
        this.secShift05 = 5046485836271438973L - seed;
        this.secShift06 = -8055285457383852172L + seed;
        this.secShift07 = 5920048007935066598L - seed;
        this.secShift08 = 7336514198459093435L + seed;
        this.secShift09 = 5216419214072683403L - seed;
        this.secShift10 = -1217880312389983593L + seed;
        this.secShift11 = 8573350489219836230L - seed;
        this.secShift12 = -4909775443879730369L + seed;
        this.secShift13 = -2282891677615274041L - seed;
        this.secShift14 = 8320639771003045937L + seed;
        this.secShift15 = -1453760514566526364L - seed;
        this.secShift16 = this.secret15 >>> 8 | this.secret16 << 56;
        this.secShift17 = this.secret16 >>> 8 | this.secret17 << 56;
        this.secShift18 = this.secret17 >>> 8 | this.secret18 << 56;
        this.secShift19 = this.secret18 >>> 8 | this.secret19 << 56;
        this.secShift20 = this.secret19 >>> 8 | this.secret20 << 56;
        this.secShift21 = this.secret20 >>> 8 | this.secret21 << 56;
        this.secShift22 = this.secret21 >>> 8 | this.secret22 << 56;
        this.secShift23 = this.secret22 >>> 8 | this.secret23 << 56;
        this.secShiftFinal0 = this.secret01 >>> 24 | this.secret02 << 40;
        this.secShiftFinal1 = this.secret02 >>> 24 | this.secret03 << 40;
        this.secShiftFinal2 = this.secret03 >>> 24 | this.secret04 << 40;
        this.secShiftFinal3 = this.secret04 >>> 24 | this.secret05 << 40;
        this.secShiftFinal4 = this.secret05 >>> 24 | this.secret06 << 40;
        this.secShiftFinal5 = this.secret06 >>> 24 | this.secret07 << 40;
        this.secShiftFinal6 = this.secret07 >>> 24 | this.secret08 << 40;
        this.secShiftFinal7 = this.secret08 >>> 24 | this.secret09 << 40;
        this.bitflip00 = 2267503259L + seed;
        this.bitflip12 = -4090762196417718878L - (seed ^ Long.reverseBytes(seed & 0xFFFFFFFFL));
        this.bitflip34 = 7458650908927343033L + seed;
        this.bitflip56 = -5812251307325107654L - seed;
        this.hash0 = XXH3_64.avalanche64(seed ^ 0x8726F9105DC21DDCL);
        this.secret = new long[]{this.secret00, this.secret01, this.secret02, this.secret03, this.secret04, this.secret05, this.secret06, this.secret07, this.secret08, this.secret09, this.secret10, this.secret11, this.secret12, this.secret13, this.secret14, this.secret15, this.secret16, this.secret17, this.secret18, this.secret19, this.secret20, this.secret21, this.secret22, this.secret23};
    }

    private XXH3_64() {
        this(0L);
    }

    public static Hasher64 create() {
        return DEFAULT_HASHER_INSTANCE;
    }

    public static Hasher64 create(long seed) {
        return new XXH3_64(seed);
    }

    @Override
    public HashStream64 hashStream() {
        return new HashStreamImpl();
    }

    private static long unsignedLongMulXorFold(long lhs, long rhs) {
        long upper = UnsignedMultiplyUtil.unsignedMultiplyHigh(lhs, rhs);
        long lower = lhs * rhs;
        return lower ^ upper;
    }

    private static long avalanche3(long h64) {
        h64 ^= h64 >>> 37;
        return (h64 *= 1609587791953885689L) ^ h64 >>> 32;
    }

    private static long rrmxmx(long h64, long length) {
        h64 ^= Long.rotateLeft(h64, 49) ^ Long.rotateLeft(h64, 24);
        h64 *= -6939452855193903323L;
        h64 ^= (h64 >>> 35) + length;
        return (h64 *= -6939452855193903323L) ^ h64 >>> 28;
    }

    private static long avalanche64(long h64) {
        h64 ^= h64 >>> 33;
        h64 *= -4417276706812531889L;
        h64 ^= h64 >>> 29;
        return (h64 *= 1609587929392839161L) ^ h64 >>> 32;
    }

    private static long mix16B(byte[] input, int offIn, long sec0, long sec1) {
        long lo = XXH3_64.getLong(input, offIn);
        long hi = XXH3_64.getLong(input, offIn + 8);
        return XXH3_64.mix2Accs(lo, hi, sec0, sec1);
    }

    private static long mix16B(CharSequence input, int offIn, long sec0, long sec1) {
        long lo = XXH3_64.getLong(input, offIn);
        long hi = XXH3_64.getLong(input, offIn + 4);
        return XXH3_64.mix2Accs(lo, hi, sec0, sec1);
    }

    private static long mix2Accs(long lh, long rh, long sec0, long sec8) {
        return XXH3_64.unsignedLongMulXorFold(lh ^ sec0, rh ^ sec8);
    }

    private static long mixAcc(long acc, long sec) {
        return (acc ^ acc >>> 47 ^ sec) * 2654435761L;
    }

    @Override
    public long hashBytesToLong(byte[] input, int off, int length) {
        long b7;
        long b6;
        long b5;
        long b4;
        long b3;
        long b2;
        long b1;
        long b0;
        int offStripe;
        int s;
        int offBlock;
        if (length <= 16) {
            if (length > 8) {
                long lo = XXH3_64.getLong(input, off) ^ this.bitflip34;
                long hi = XXH3_64.getLong(input, off + length - 8) ^ this.bitflip56;
                long acc = (long)length + Long.reverseBytes(lo) + hi + XXH3_64.unsignedLongMulXorFold(lo, hi);
                return XXH3_64.avalanche3(acc);
            }
            if (length >= 4) {
                long input1 = XXH3_64.getInt(input, off);
                long input2 = XXH3_64.getInt(input, off + length - 4);
                long keyed = (input2 & 0xFFFFFFFFL) + (input1 << 32) ^ this.bitflip12;
                return XXH3_64.rrmxmx(keyed, length);
            }
            if (length != 0) {
                int c1 = input[off] & 0xFF;
                byte c2 = input[off + (length >> 1)];
                int c3 = input[off + length - 1] & 0xFF;
                long combined = (long)(c1 << 16 | c2 << 24 | c3 | length << 8) & 0xFFFFFFFFL;
                return XXH3_64.avalanche64(combined ^ this.bitflip00);
            }
            return this.hash0;
        }
        if (length <= 128) {
            long acc = (long)length * -7046029288634856825L;
            if (length > 32) {
                if (length > 64) {
                    if (length > 96) {
                        acc += XXH3_64.mix16B(input, off + 48, this.secret12, this.secret13);
                        acc += XXH3_64.mix16B(input, off + length - 64, this.secret14, this.secret15);
                    }
                    acc += XXH3_64.mix16B(input, off + 32, this.secret08, this.secret09);
                    acc += XXH3_64.mix16B(input, off + length - 48, this.secret10, this.secret11);
                }
                acc += XXH3_64.mix16B(input, off + 16, this.secret04, this.secret05);
                acc += XXH3_64.mix16B(input, off + length - 32, this.secret06, this.secret07);
            }
            acc += XXH3_64.mix16B(input, off, this.secret00, this.secret01);
            return XXH3_64.avalanche3(acc += XXH3_64.mix16B(input, off + length - 16, this.secret02, this.secret03));
        }
        if (length <= 240) {
            long acc = (long)length * -7046029288634856825L;
            acc += XXH3_64.mix16B(input, off + 0, this.secret00, this.secret01);
            acc += XXH3_64.mix16B(input, off + 16, this.secret02, this.secret03);
            acc += XXH3_64.mix16B(input, off + 32, this.secret04, this.secret05);
            acc += XXH3_64.mix16B(input, off + 48, this.secret06, this.secret07);
            acc += XXH3_64.mix16B(input, off + 64, this.secret08, this.secret09);
            acc += XXH3_64.mix16B(input, off + 80, this.secret10, this.secret11);
            acc += XXH3_64.mix16B(input, off + 96, this.secret12, this.secret13);
            acc += XXH3_64.mix16B(input, off + 112, this.secret14, this.secret15);
            acc = XXH3_64.avalanche3(acc);
            if (length >= 144) {
                acc += XXH3_64.mix16B(input, off + 128, this.secShift00, this.secShift01);
                if (length >= 160) {
                    acc += XXH3_64.mix16B(input, off + 144, this.secShift02, this.secShift03);
                    if (length >= 176) {
                        acc += XXH3_64.mix16B(input, off + 160, this.secShift04, this.secShift05);
                        if (length >= 192) {
                            acc += XXH3_64.mix16B(input, off + 176, this.secShift06, this.secShift07);
                            if (length >= 208) {
                                acc += XXH3_64.mix16B(input, off + 192, this.secShift08, this.secShift09);
                                if (length >= 224) {
                                    acc += XXH3_64.mix16B(input, off + 208, this.secShift10, this.secShift11);
                                    if (length >= 240) {
                                        acc += XXH3_64.mix16B(input, off + 224, this.secShift12, this.secShift13);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            return XXH3_64.avalanche3(acc += XXH3_64.mix16B(input, off + length - 16, this.secShift14, this.secShift15));
        }
        long acc0 = 3266489917L;
        long acc1 = -7046029288634856825L;
        long acc2 = -4417276706812531889L;
        long acc3 = 1609587929392839161L;
        long acc4 = -8796714831421723037L;
        long acc5 = 2246822519L;
        long acc6 = 2870177450012600261L;
        long acc7 = 2654435761L;
        int nbBlocks = length - 1 >>> 10;
        for (int n = 0; n < nbBlocks; ++n) {
            offBlock = off + (n << 10);
            for (s = 0; s < 16; ++s) {
                offStripe = offBlock + (s << 6);
                b0 = XXH3_64.getLong(input, offStripe + 0);
                b1 = XXH3_64.getLong(input, offStripe + 8);
                b2 = XXH3_64.getLong(input, offStripe + 16);
                b3 = XXH3_64.getLong(input, offStripe + 24);
                b4 = XXH3_64.getLong(input, offStripe + 32);
                b5 = XXH3_64.getLong(input, offStripe + 40);
                b6 = XXH3_64.getLong(input, offStripe + 48);
                b7 = XXH3_64.getLong(input, offStripe + 56);
                acc0 += b1 + XXH3_64.contrib(b0, this.secret[s + 0]);
                acc1 += b0 + XXH3_64.contrib(b1, this.secret[s + 1]);
                acc2 += b3 + XXH3_64.contrib(b2, this.secret[s + 2]);
                acc3 += b2 + XXH3_64.contrib(b3, this.secret[s + 3]);
                acc4 += b5 + XXH3_64.contrib(b4, this.secret[s + 4]);
                acc5 += b4 + XXH3_64.contrib(b5, this.secret[s + 5]);
                acc6 += b7 + XXH3_64.contrib(b6, this.secret[s + 6]);
                acc7 += b6 + XXH3_64.contrib(b7, this.secret[s + 7]);
            }
            acc0 = XXH3_64.mixAcc(acc0, this.secret16);
            acc1 = XXH3_64.mixAcc(acc1, this.secret17);
            acc2 = XXH3_64.mixAcc(acc2, this.secret18);
            acc3 = XXH3_64.mixAcc(acc3, this.secret19);
            acc4 = XXH3_64.mixAcc(acc4, this.secret20);
            acc5 = XXH3_64.mixAcc(acc5, this.secret21);
            acc6 = XXH3_64.mixAcc(acc6, this.secret22);
            acc7 = XXH3_64.mixAcc(acc7, this.secret23);
        }
        int nbStripes = length - 1 - (nbBlocks << 10) >>> 6;
        offBlock = off + (nbBlocks << 10);
        for (s = 0; s < nbStripes; ++s) {
            offStripe = offBlock + (s << 6);
            b0 = XXH3_64.getLong(input, offStripe + 0);
            b1 = XXH3_64.getLong(input, offStripe + 8);
            b2 = XXH3_64.getLong(input, offStripe + 16);
            b3 = XXH3_64.getLong(input, offStripe + 24);
            b4 = XXH3_64.getLong(input, offStripe + 32);
            b5 = XXH3_64.getLong(input, offStripe + 40);
            b6 = XXH3_64.getLong(input, offStripe + 48);
            b7 = XXH3_64.getLong(input, offStripe + 56);
            acc0 += b1 + XXH3_64.contrib(b0, this.secret[s + 0]);
            acc1 += b0 + XXH3_64.contrib(b1, this.secret[s + 1]);
            acc2 += b3 + XXH3_64.contrib(b2, this.secret[s + 2]);
            acc3 += b2 + XXH3_64.contrib(b3, this.secret[s + 3]);
            acc4 += b5 + XXH3_64.contrib(b4, this.secret[s + 4]);
            acc5 += b4 + XXH3_64.contrib(b5, this.secret[s + 5]);
            acc6 += b7 + XXH3_64.contrib(b6, this.secret[s + 6]);
            acc7 += b6 + XXH3_64.contrib(b7, this.secret[s + 7]);
        }
        int offStripe2 = off + length - 64;
        long b02 = XXH3_64.getLong(input, offStripe2 + 0);
        long b12 = XXH3_64.getLong(input, offStripe2 + 8);
        long b22 = XXH3_64.getLong(input, offStripe2 + 16);
        long b32 = XXH3_64.getLong(input, offStripe2 + 24);
        long b42 = XXH3_64.getLong(input, offStripe2 + 32);
        long b52 = XXH3_64.getLong(input, offStripe2 + 40);
        long b62 = XXH3_64.getLong(input, offStripe2 + 48);
        long b72 = XXH3_64.getLong(input, offStripe2 + 56);
        return this.finalizeHash(length, acc0 += b12 + XXH3_64.contrib(b02, this.secShift16), acc1 += b02 + XXH3_64.contrib(b12, this.secShift17), acc2 += b32 + XXH3_64.contrib(b22, this.secShift18), acc3 += b22 + XXH3_64.contrib(b32, this.secShift19), acc4 += b52 + XXH3_64.contrib(b42, this.secShift20), acc5 += b42 + XXH3_64.contrib(b52, this.secShift21), acc6 += b72 + XXH3_64.contrib(b62, this.secShift22), acc7 += b62 + XXH3_64.contrib(b72, this.secShift23));
    }

    private long finalizeHash(long length, long acc0, long acc1, long acc2, long acc3, long acc4, long acc5, long acc6, long acc7) {
        long result64 = length * -7046029288634856825L + XXH3_64.mix2Accs(acc0, acc1, this.secShiftFinal0, this.secShiftFinal1) + XXH3_64.mix2Accs(acc2, acc3, this.secShiftFinal2, this.secShiftFinal3) + XXH3_64.mix2Accs(acc4, acc5, this.secShiftFinal4, this.secShiftFinal5) + XXH3_64.mix2Accs(acc6, acc7, this.secShiftFinal6, this.secShiftFinal7);
        return XXH3_64.avalanche3(result64);
    }

    private static long contrib(long a, long b) {
        long k = a ^ b;
        return (0xFFFFFFFFL & k) * (k >>> 32);
    }

    @Override
    public long hashCharsToLong(CharSequence charSequence) {
        long b7;
        long b6;
        long b5;
        long b4;
        long b3;
        long b2;
        long b1;
        long b0;
        int offStripe;
        int s;
        int offBlock;
        int len = charSequence.length();
        if (len <= 8) {
            if (len > 4) {
                long lo = XXH3_64.getLong(charSequence, 0) ^ this.bitflip34;
                long hi = XXH3_64.getLong(charSequence, len - 4) ^ this.bitflip56;
                long acc = (long)(len << 1) + Long.reverseBytes(lo) + hi + XXH3_64.unsignedLongMulXorFold(lo, hi);
                return XXH3_64.avalanche3(acc);
            }
            if (len >= 2) {
                long input1 = XXH3_64.getInt(charSequence, 0);
                long input2 = XXH3_64.getInt(charSequence, len - 2);
                long keyed = (input2 & 0xFFFFFFFFL) + (input1 << 32) ^ this.bitflip12;
                return XXH3_64.rrmxmx(keyed, len << 1);
            }
            if (len != 0) {
                long c = charSequence.charAt(0);
                long combined = c << 16 | c >>> 8 | 0x200L;
                return XXH3_64.avalanche64(combined ^ this.bitflip00);
            }
            return this.hash0;
        }
        if (len <= 64) {
            long acc = (long)len * 4354685496439837966L;
            if (len > 16) {
                if (len > 32) {
                    if (len > 48) {
                        acc += XXH3_64.mix16B(charSequence, 24, this.secret12, this.secret13);
                        acc += XXH3_64.mix16B(charSequence, len - 32, this.secret14, this.secret15);
                    }
                    acc += XXH3_64.mix16B(charSequence, 16, this.secret08, this.secret09);
                    acc += XXH3_64.mix16B(charSequence, len - 24, this.secret10, this.secret11);
                }
                acc += XXH3_64.mix16B(charSequence, 8, this.secret04, this.secret05);
                acc += XXH3_64.mix16B(charSequence, len - 16, this.secret06, this.secret07);
            }
            acc += XXH3_64.mix16B(charSequence, 0, this.secret00, this.secret01);
            return XXH3_64.avalanche3(acc += XXH3_64.mix16B(charSequence, len - 8, this.secret02, this.secret03));
        }
        if (len <= 120) {
            long acc = (long)len * 4354685496439837966L;
            acc += XXH3_64.mix16B(charSequence, 0, this.secret00, this.secret01);
            acc += XXH3_64.mix16B(charSequence, 8, this.secret02, this.secret03);
            acc += XXH3_64.mix16B(charSequence, 16, this.secret04, this.secret05);
            acc += XXH3_64.mix16B(charSequence, 24, this.secret06, this.secret07);
            acc += XXH3_64.mix16B(charSequence, 32, this.secret08, this.secret09);
            acc += XXH3_64.mix16B(charSequence, 40, this.secret10, this.secret11);
            acc += XXH3_64.mix16B(charSequence, 48, this.secret12, this.secret13);
            acc += XXH3_64.mix16B(charSequence, 56, this.secret14, this.secret15);
            acc = XXH3_64.avalanche3(acc);
            if (len >= 72) {
                acc += XXH3_64.mix16B(charSequence, 64, this.secShift00, this.secShift01);
                if (len >= 80) {
                    acc += XXH3_64.mix16B(charSequence, 72, this.secShift02, this.secShift03);
                    if (len >= 88) {
                        acc += XXH3_64.mix16B(charSequence, 80, this.secShift04, this.secShift05);
                        if (len >= 96) {
                            acc += XXH3_64.mix16B(charSequence, 88, this.secShift06, this.secShift07);
                            if (len >= 104) {
                                acc += XXH3_64.mix16B(charSequence, 96, this.secShift08, this.secShift09);
                                if (len >= 112) {
                                    acc += XXH3_64.mix16B(charSequence, 104, this.secShift10, this.secShift11);
                                    if (len >= 120) {
                                        acc += XXH3_64.mix16B(charSequence, 112, this.secShift12, this.secShift13);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            return XXH3_64.avalanche3(acc += XXH3_64.mix16B(charSequence, len - 8, this.secShift14, this.secShift15));
        }
        long acc0 = 3266489917L;
        long acc1 = -7046029288634856825L;
        long acc2 = -4417276706812531889L;
        long acc3 = 1609587929392839161L;
        long acc4 = -8796714831421723037L;
        long acc5 = 2246822519L;
        long acc6 = 2870177450012600261L;
        long acc7 = 2654435761L;
        int nbBlocks = len - 1 >>> 9;
        for (int n = 0; n < nbBlocks; ++n) {
            offBlock = n << 9;
            for (s = 0; s < 16; ++s) {
                offStripe = offBlock + (s << 5);
                b0 = XXH3_64.getLong(charSequence, offStripe + 0);
                b1 = XXH3_64.getLong(charSequence, offStripe + 4);
                b2 = XXH3_64.getLong(charSequence, offStripe + 8);
                b3 = XXH3_64.getLong(charSequence, offStripe + 12);
                b4 = XXH3_64.getLong(charSequence, offStripe + 16);
                b5 = XXH3_64.getLong(charSequence, offStripe + 20);
                b6 = XXH3_64.getLong(charSequence, offStripe + 24);
                b7 = XXH3_64.getLong(charSequence, offStripe + 28);
                acc0 += b1 + XXH3_64.contrib(b0, this.secret[s + 0]);
                acc1 += b0 + XXH3_64.contrib(b1, this.secret[s + 1]);
                acc2 += b3 + XXH3_64.contrib(b2, this.secret[s + 2]);
                acc3 += b2 + XXH3_64.contrib(b3, this.secret[s + 3]);
                acc4 += b5 + XXH3_64.contrib(b4, this.secret[s + 4]);
                acc5 += b4 + XXH3_64.contrib(b5, this.secret[s + 5]);
                acc6 += b7 + XXH3_64.contrib(b6, this.secret[s + 6]);
                acc7 += b6 + XXH3_64.contrib(b7, this.secret[s + 7]);
            }
            acc0 = XXH3_64.mixAcc(acc0, this.secret16);
            acc1 = XXH3_64.mixAcc(acc1, this.secret17);
            acc2 = XXH3_64.mixAcc(acc2, this.secret18);
            acc3 = XXH3_64.mixAcc(acc3, this.secret19);
            acc4 = XXH3_64.mixAcc(acc4, this.secret20);
            acc5 = XXH3_64.mixAcc(acc5, this.secret21);
            acc6 = XXH3_64.mixAcc(acc6, this.secret22);
            acc7 = XXH3_64.mixAcc(acc7, this.secret23);
        }
        int nbStripes = len - 1 - (nbBlocks << 9) >>> 5;
        offBlock = nbBlocks << 9;
        for (s = 0; s < nbStripes; ++s) {
            offStripe = offBlock + (s << 5);
            b0 = XXH3_64.getLong(charSequence, offStripe + 0);
            b1 = XXH3_64.getLong(charSequence, offStripe + 4);
            b2 = XXH3_64.getLong(charSequence, offStripe + 8);
            b3 = XXH3_64.getLong(charSequence, offStripe + 12);
            b4 = XXH3_64.getLong(charSequence, offStripe + 16);
            b5 = XXH3_64.getLong(charSequence, offStripe + 20);
            b6 = XXH3_64.getLong(charSequence, offStripe + 24);
            b7 = XXH3_64.getLong(charSequence, offStripe + 28);
            acc0 += b1 + XXH3_64.contrib(b0, this.secret[s + 0]);
            acc1 += b0 + XXH3_64.contrib(b1, this.secret[s + 1]);
            acc2 += b3 + XXH3_64.contrib(b2, this.secret[s + 2]);
            acc3 += b2 + XXH3_64.contrib(b3, this.secret[s + 3]);
            acc4 += b5 + XXH3_64.contrib(b4, this.secret[s + 4]);
            acc5 += b4 + XXH3_64.contrib(b5, this.secret[s + 5]);
            acc6 += b7 + XXH3_64.contrib(b6, this.secret[s + 6]);
            acc7 += b6 + XXH3_64.contrib(b7, this.secret[s + 7]);
        }
        int offStripe2 = len - 32;
        long b02 = XXH3_64.getLong(charSequence, offStripe2 + 0);
        long b12 = XXH3_64.getLong(charSequence, offStripe2 + 4);
        long b22 = XXH3_64.getLong(charSequence, offStripe2 + 8);
        long b32 = XXH3_64.getLong(charSequence, offStripe2 + 12);
        long b42 = XXH3_64.getLong(charSequence, offStripe2 + 16);
        long b52 = XXH3_64.getLong(charSequence, offStripe2 + 20);
        long b62 = XXH3_64.getLong(charSequence, offStripe2 + 24);
        long b72 = XXH3_64.getLong(charSequence, offStripe2 + 28);
        return this.finalizeHash((long)len << 1, acc0 += b12 + XXH3_64.contrib(b02, this.secShift16), acc1 += b02 + XXH3_64.contrib(b12, this.secShift17), acc2 += b32 + XXH3_64.contrib(b22, this.secShift18), acc3 += b22 + XXH3_64.contrib(b32, this.secShift19), acc4 += b52 + XXH3_64.contrib(b42, this.secShift20), acc5 += b42 + XXH3_64.contrib(b52, this.secShift21), acc6 += b72 + XXH3_64.contrib(b62, this.secShift22), acc7 += b62 + XXH3_64.contrib(b72, this.secShift23));
    }

    @Override
    public long hashLongLongToLong(long v1, long v2) {
        long lo = v1 ^ this.bitflip34;
        long hi = v2 ^ this.bitflip56;
        long acc = 16L + Long.reverseBytes(lo) + hi + XXH3_64.unsignedLongMulXorFold(lo, hi);
        return XXH3_64.avalanche3(acc);
    }

    @Override
    public long hashLongLongLongToLong(long v1, long v2, long v3) {
        long acc = -3084006263850599256L;
        acc += XXH3_64.mix2Accs(v1, v2, this.secret00, this.secret01);
        return XXH3_64.avalanche3(acc += XXH3_64.mix2Accs(v2, v3, this.secret02, this.secret03));
    }

    private final class HashStreamImpl
    extends AbstractHashStream64 {
        private static final int BULK_SIZE = 256;
        private static final int BULK_SIZE_HALF = 128;
        private static final int BULK_SIZE_MASK = 255;
        private long acc0 = 3266489917L;
        private long acc1 = -7046029288634856825L;
        private long acc2 = -4417276706812531889L;
        private long acc3 = 1609587929392839161L;
        private long acc4 = -8796714831421723037L;
        private long acc5 = 2246822519L;
        private long acc6 = 2870177450012600261L;
        private long acc7 = 2654435761L;
        private final byte[] buffer = new byte[264];
        private int offset = 0;
        private long byteCount = 0L;

        private HashStreamImpl() {
        }

        @Override
        public long getAsLong() {
            if (this.byteCount <= 256L) {
                return XXH3_64.this.hashBytesToLong(this.buffer, 0, (int)this.byteCount);
            }
            AbstractHasher.setLong(this.buffer, 256, AbstractHasher.getLong(this.buffer, 0));
            long acc0Loc = this.acc0;
            long acc1Loc = this.acc1;
            long acc2Loc = this.acc2;
            long acc3Loc = this.acc3;
            long acc4Loc = this.acc4;
            long acc5Loc = this.acc5;
            long acc6Loc = this.acc6;
            long acc7Loc = this.acc7;
            int off = 0;
            int s = (int)this.byteCount - 1 >>> 6 & 0xC;
            while (off + 64 <= ((int)this.byteCount - 1 & 0xFF)) {
                long b0 = AbstractHasher.getLong(this.buffer, off + 0);
                long b1 = AbstractHasher.getLong(this.buffer, off + 8);
                long b2 = AbstractHasher.getLong(this.buffer, off + 16);
                long b3 = AbstractHasher.getLong(this.buffer, off + 24);
                long b4 = AbstractHasher.getLong(this.buffer, off + 32);
                long b5 = AbstractHasher.getLong(this.buffer, off + 40);
                long b6 = AbstractHasher.getLong(this.buffer, off + 48);
                long b7 = AbstractHasher.getLong(this.buffer, off + 56);
                acc0Loc += b1 + XXH3_64.contrib(b0, XXH3_64.this.secret[s + 0]);
                acc1Loc += b0 + XXH3_64.contrib(b1, XXH3_64.this.secret[s + 1]);
                acc2Loc += b3 + XXH3_64.contrib(b2, XXH3_64.this.secret[s + 2]);
                acc3Loc += b2 + XXH3_64.contrib(b3, XXH3_64.this.secret[s + 3]);
                acc4Loc += b5 + XXH3_64.contrib(b4, XXH3_64.this.secret[s + 4]);
                acc5Loc += b4 + XXH3_64.contrib(b5, XXH3_64.this.secret[s + 5]);
                acc6Loc += b7 + XXH3_64.contrib(b6, XXH3_64.this.secret[s + 6]);
                acc7Loc += b6 + XXH3_64.contrib(b7, XXH3_64.this.secret[s + 7]);
                off += 64;
                ++s;
            }
            long b0 = AbstractHasher.getLong(this.buffer, this.offset - 64 & 0xFF);
            long b1 = AbstractHasher.getLong(this.buffer, this.offset - 56 & 0xFF);
            long b2 = AbstractHasher.getLong(this.buffer, this.offset - 48 & 0xFF);
            long b3 = AbstractHasher.getLong(this.buffer, this.offset - 40 & 0xFF);
            long b4 = AbstractHasher.getLong(this.buffer, this.offset - 32 & 0xFF);
            long b5 = AbstractHasher.getLong(this.buffer, this.offset - 24 & 0xFF);
            long b6 = AbstractHasher.getLong(this.buffer, this.offset - 16 & 0xFF);
            long b7 = AbstractHasher.getLong(this.buffer, this.offset - 8 & 0xFF);
            return XXH3_64.this.finalizeHash(this.byteCount, acc0Loc += b1 + XXH3_64.contrib(b0, XXH3_64.this.secShift16), acc1Loc += b0 + XXH3_64.contrib(b1, XXH3_64.this.secShift17), acc2Loc += b3 + XXH3_64.contrib(b2, XXH3_64.this.secShift18), acc3Loc += b2 + XXH3_64.contrib(b3, XXH3_64.this.secShift19), acc4Loc += b5 + XXH3_64.contrib(b4, XXH3_64.this.secShift20), acc5Loc += b4 + XXH3_64.contrib(b5, XXH3_64.this.secShift21), acc6Loc += b7 + XXH3_64.contrib(b6, XXH3_64.this.secShift22), acc7Loc += b6 + XXH3_64.contrib(b7, XXH3_64.this.secShift23));
        }

        @Override
        public HashStream64 putByte(byte v) {
            if (this.offset >= 256) {
                this.processBuffer();
                this.offset -= 256;
            }
            this.buffer[this.offset] = v;
            ++this.offset;
            ++this.byteCount;
            return this;
        }

        @Override
        public HashStream64 putShort(short v) {
            AbstractHasher.setShort(this.buffer, this.offset, v);
            if (this.offset >= 255) {
                this.processBuffer();
                this.offset -= 256;
                AbstractHasher.setShort(this.buffer, 0, (short)(v >>> (-this.offset << 3)));
            }
            this.offset += 2;
            this.byteCount += 2L;
            return this;
        }

        @Override
        public HashStream64 putChar(char v) {
            AbstractHasher.setChar(this.buffer, this.offset, v);
            if (this.offset >= 255) {
                this.processBuffer();
                this.offset -= 256;
                AbstractHasher.setChar(this.buffer, 0, (char)(v >>> (-this.offset << 3)));
            }
            this.offset += 2;
            this.byteCount += 2L;
            return this;
        }

        @Override
        public HashStream64 putInt(int v) {
            AbstractHasher.setInt(this.buffer, this.offset, v);
            if (this.offset >= 253) {
                this.processBuffer();
                this.offset -= 256;
                AbstractHasher.setInt(this.buffer, 0, v >>> (-this.offset << 3));
            }
            this.offset += 4;
            this.byteCount += 4L;
            return this;
        }

        @Override
        public HashStream64 putLong(long v) {
            AbstractHasher.setLong(this.buffer, this.offset, v);
            if (this.offset >= 249) {
                this.processBuffer();
                this.offset -= 256;
                AbstractHasher.setLong(this.buffer, 0, v >>> (-this.offset << 3));
            }
            this.offset += 8;
            this.byteCount += 8L;
            return this;
        }

        @Override
        public HashStream64 putBytes(byte[] b, int off, int len) {
            int remaining = len;
            int x = 256 - this.offset;
            if (len > x) {
                int s = (int)(this.byteCount - 1L >>> 6) & 0xC;
                if (this.offset > 0) {
                    System.arraycopy(b, off, this.buffer, this.offset, x);
                    this.processBuffer(0, this.buffer, s);
                    this.offset = 0;
                    off += x;
                    remaining -= x;
                }
                if (remaining > 256) {
                    do {
                        s += 4;
                        this.processBuffer(off, b, s &= 0xC);
                        off += 256;
                    } while ((remaining -= 256) > 256);
                    if (remaining < 64) {
                        int l = 64 - remaining;
                        System.arraycopy(b, off - l, this.buffer, 256 - l, l);
                    }
                }
            }
            System.arraycopy(b, off, this.buffer, this.offset, remaining);
            this.offset += remaining;
            this.byteCount += (long)len;
            return this;
        }

        @Override
        public HashStream64 putChars(CharSequence c) {
            int off = 0;
            int remaining = c.length();
            int x = 128 - (this.offset >>> 1);
            if ((this.offset & 1) == 0) {
                if (c.length() > x) {
                    int s = (int)(this.byteCount - 1L >>> 6) & 0xC;
                    if (this.offset > 0) {
                        AbstractHasher.copyCharsToByteArray(c, 0, this.buffer, this.offset, x);
                        this.processBuffer(0, this.buffer, s);
                        this.offset = 0;
                        off += x;
                        remaining -= x;
                    }
                    if (remaining > 128) {
                        do {
                            s += 4;
                            this.processBuffer(off, c, s &= 0xC);
                            off += 128;
                        } while ((remaining -= 128) > 128);
                        if (remaining < 32) {
                            int l = 32 - remaining;
                            AbstractHasher.copyCharsToByteArray(c, off - l, this.buffer, 256 - (l << 1), l);
                        }
                    }
                }
            } else if (c.length() >= x) {
                int s = (int)(this.byteCount - 1L >>> 6) & 0xC;
                AbstractHasher.copyCharsToByteArray(c, 0, this.buffer, this.offset, x);
                long extraByte = (long)this.buffer[256] & 0xFFL;
                this.processBuffer(0, this.buffer, s);
                this.offset = 1;
                off += x;
                if ((remaining -= x) >= 128) {
                    do {
                        s += 4;
                        extraByte = this.processBuffer(off, c, s &= 0xC, extraByte);
                        off += 128;
                    } while ((remaining -= 128) >= 128);
                    if (remaining < 32) {
                        int l = 32 - remaining;
                        AbstractHasher.copyCharsToByteArray(c, off - l, this.buffer, 257 - (l << 1), l);
                    }
                }
                this.buffer[0] = (byte)extraByte;
            }
            AbstractHasher.copyCharsToByteArray(c, off, this.buffer, this.offset, remaining);
            this.offset += remaining << 1;
            this.byteCount += (long)c.length() << 1;
            return this;
        }

        private void processBuffer() {
            int s = (int)(this.byteCount - 1L >>> 6) & 0xC;
            this.processBuffer(0, this.buffer, s);
        }

        private void mixAcc() {
            this.acc0 = XXH3_64.mixAcc(this.acc0, XXH3_64.this.secret16);
            this.acc1 = XXH3_64.mixAcc(this.acc1, XXH3_64.this.secret17);
            this.acc2 = XXH3_64.mixAcc(this.acc2, XXH3_64.this.secret18);
            this.acc3 = XXH3_64.mixAcc(this.acc3, XXH3_64.this.secret19);
            this.acc4 = XXH3_64.mixAcc(this.acc4, XXH3_64.this.secret20);
            this.acc5 = XXH3_64.mixAcc(this.acc5, XXH3_64.this.secret21);
            this.acc6 = XXH3_64.mixAcc(this.acc6, XXH3_64.this.secret22);
            this.acc7 = XXH3_64.mixAcc(this.acc7, XXH3_64.this.secret23);
        }

        private void processBuffer(int off, byte[] buffer, int s) {
            for (int i = 0; i < 4; ++i) {
                int o = off + (i << 6);
                long b0 = AbstractHasher.getLong(buffer, o + 0);
                long b1 = AbstractHasher.getLong(buffer, o + 8);
                long b2 = AbstractHasher.getLong(buffer, o + 16);
                long b3 = AbstractHasher.getLong(buffer, o + 24);
                long b4 = AbstractHasher.getLong(buffer, o + 32);
                long b5 = AbstractHasher.getLong(buffer, o + 40);
                long b6 = AbstractHasher.getLong(buffer, o + 48);
                long b7 = AbstractHasher.getLong(buffer, o + 56);
                this.processBuffer(b0, b1, b2, b3, b4, b5, b6, b7, s + i);
            }
            if (s == 12) {
                this.mixAcc();
            }
        }

        private void processBuffer(int off, CharSequence c, int s) {
            for (int i = 0; i < 4; ++i) {
                int o = off + (i << 5);
                long b0 = AbstractHasher.getLong(c, o + 0);
                long b1 = AbstractHasher.getLong(c, o + 4);
                long b2 = AbstractHasher.getLong(c, o + 8);
                long b3 = AbstractHasher.getLong(c, o + 12);
                long b4 = AbstractHasher.getLong(c, o + 16);
                long b5 = AbstractHasher.getLong(c, o + 20);
                long b6 = AbstractHasher.getLong(c, o + 24);
                long b7 = AbstractHasher.getLong(c, o + 28);
                this.processBuffer(b0, b1, b2, b3, b4, b5, b6, b7, s + i);
            }
            if (s == 12) {
                this.mixAcc();
            }
        }

        private long processBuffer(int off, CharSequence c, int s, long extraByte) {
            for (int i = 0; i < 4; ++i) {
                int o = off + (i << 5);
                long b0 = AbstractHasher.getLong(c, o + 0);
                long b1 = AbstractHasher.getLong(c, o + 4);
                long b2 = AbstractHasher.getLong(c, o + 8);
                long b3 = AbstractHasher.getLong(c, o + 12);
                long b4 = AbstractHasher.getLong(c, o + 16);
                long b5 = AbstractHasher.getLong(c, o + 20);
                long b6 = AbstractHasher.getLong(c, o + 24);
                long b7 = AbstractHasher.getLong(c, o + 28);
                long y = b7 >>> 56;
                b7 = b6 >>> 56 | b7 << 8;
                b6 = b5 >>> 56 | b6 << 8;
                b5 = b4 >>> 56 | b5 << 8;
                b4 = b3 >>> 56 | b4 << 8;
                b3 = b2 >>> 56 | b3 << 8;
                b2 = b1 >>> 56 | b2 << 8;
                b1 = b0 >>> 56 | b1 << 8;
                b0 = extraByte | b0 << 8;
                extraByte = y;
                this.processBuffer(b0, b1, b2, b3, b4, b5, b6, b7, s + i);
            }
            if (s == 12) {
                this.mixAcc();
            }
            return extraByte;
        }

        private void processBuffer(long b0, long b1, long b2, long b3, long b4, long b5, long b6, long b7, int s) {
            this.acc0 += b1 + XXH3_64.contrib(b0, XXH3_64.this.secret[s + 0]);
            this.acc1 += b0 + XXH3_64.contrib(b1, XXH3_64.this.secret[s + 1]);
            this.acc2 += b3 + XXH3_64.contrib(b2, XXH3_64.this.secret[s + 2]);
            this.acc3 += b2 + XXH3_64.contrib(b3, XXH3_64.this.secret[s + 3]);
            this.acc4 += b5 + XXH3_64.contrib(b4, XXH3_64.this.secret[s + 4]);
            this.acc5 += b4 + XXH3_64.contrib(b5, XXH3_64.this.secret[s + 5]);
            this.acc6 += b7 + XXH3_64.contrib(b6, XXH3_64.this.secret[s + 6]);
            this.acc7 += b6 + XXH3_64.contrib(b7, XXH3_64.this.secret[s + 7]);
        }

        @Override
        public HashStream64 reset() {
            this.acc0 = 3266489917L;
            this.acc1 = -7046029288634856825L;
            this.acc2 = -4417276706812531889L;
            this.acc3 = 1609587929392839161L;
            this.acc4 = -8796714831421723037L;
            this.acc5 = 2246822519L;
            this.acc6 = 2870177450012600261L;
            this.acc7 = 2654435761L;
            this.offset = 0;
            this.byteCount = 0L;
            return this;
        }

        @Override
        public HashStream64 copy() {
            HashStreamImpl hashStream = new HashStreamImpl();
            hashStream.acc0 = this.acc0;
            hashStream.acc1 = this.acc1;
            hashStream.acc2 = this.acc2;
            hashStream.acc3 = this.acc3;
            hashStream.acc4 = this.acc4;
            hashStream.acc5 = this.acc5;
            hashStream.acc6 = this.acc6;
            hashStream.acc7 = this.acc7;
            hashStream.offset = this.offset;
            hashStream.byteCount = this.byteCount;
            System.arraycopy(this.buffer, 0, hashStream.buffer, 0, this.buffer.length);
            return hashStream;
        }
    }
}

