/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.hash4j.similarity;

import com.dynatrace.hash4j.random.PseudoRandomGenerator;
import com.dynatrace.hash4j.random.PseudoRandomGeneratorProvider;
import com.dynatrace.hash4j.similarity.AbstractSimilarityHashPolicy;
import com.dynatrace.hash4j.similarity.ElementHashProvider;
import com.dynatrace.hash4j.similarity.SimilarityHasher;
import com.dynatrace.hash4j.util.Preconditions;
import java.util.Arrays;
import java.util.Objects;

final class SimHashPolicy_v1
extends AbstractSimilarityHashPolicy {
    public SimHashPolicy_v1(int numberOfComponents, PseudoRandomGeneratorProvider pseudoRandomGeneratorProvider) {
        super(numberOfComponents, 1, pseudoRandomGeneratorProvider);
    }

    @Override
    public SimilarityHasher createHasher() {
        return new Hasher();
    }

    private class Hasher
    implements SimilarityHasher {
        private final int[] counts;
        private final PseudoRandomGenerator pseudoRandomGenerator;

        private Hasher() {
            this.counts = new int[SimHashPolicy_v1.this.numberOfComponents];
            this.pseudoRandomGenerator = SimHashPolicy_v1.this.pseudoRandomGeneratorProvider.create();
        }

        @Override
        public byte[] compute(ElementHashProvider elementHashProvider) {
            Objects.requireNonNull(elementHashProvider);
            int numberOfElements = elementHashProvider.getNumberOfElements();
            Preconditions.checkArgument(numberOfElements > 0, "Number of elements must be positive!");
            Arrays.fill(this.counts, 0);
            int numChunks = SimHashPolicy_v1.this.numberOfComponents >>> 6;
            int numRemaining = SimHashPolicy_v1.this.numberOfComponents & 0x3F;
            for (int k = 0; k < numberOfElements; ++k) {
                long elementHash = elementHashProvider.getElementHash(k);
                this.pseudoRandomGenerator.reset(elementHash);
                for (int j = 0; j < numChunks; ++j) {
                    long randomValue = this.pseudoRandomGenerator.nextLong();
                    int off = j << 6;
                    for (int h = 0; h < 64; ++h) {
                        int n = off + h;
                        this.counts[n] = this.counts[n] + ((int)(randomValue >>> h) & 1);
                    }
                }
                if (numRemaining <= 0) continue;
                long randomValue = this.pseudoRandomGenerator.nextLong();
                int off = numChunks << 6;
                for (int h = 0; h < numRemaining; ++h) {
                    int n = off + h;
                    this.counts[n] = this.counts[n] + ((int)(randomValue >>> h) & 1);
                }
            }
            long limit = numberOfElements >>> 1;
            return SimHashPolicy_v1.this.packedArrayHandler.create(i -> (long)(this.counts[i] + (i & (~numberOfElements & 1))) > limit ? 1L : 0L, SimHashPolicy_v1.this.numberOfComponents);
        }
    }
}

