/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.hash4j.similarity;

import com.dynatrace.hash4j.random.PermutationGenerator;
import com.dynatrace.hash4j.random.PseudoRandomGenerator;
import com.dynatrace.hash4j.random.PseudoRandomGeneratorProvider;
import com.dynatrace.hash4j.similarity.AbstractSimilarityHashPolicy;
import com.dynatrace.hash4j.similarity.DistinctElementHashProvider;
import com.dynatrace.hash4j.similarity.ElementHashProvider;
import com.dynatrace.hash4j.similarity.SimilarityHasher;
import com.dynatrace.hash4j.util.Preconditions;
import java.util.Arrays;
import java.util.Objects;

final class SuperMinHashPolicy_v1b
extends AbstractSimilarityHashPolicy {
    private static final double FIRST_ATTEMPT_SUCCESS_PROBABILITY = 0.99;
    private final double cycleLimitEstimationConstant;

    public SuperMinHashPolicy_v1b(int numberOfComponents, int bitsPerComponent, PseudoRandomGeneratorProvider pseudoRandomGeneratorProvider) {
        super(numberOfComponents, bitsPerComponent, pseudoRandomGeneratorProvider);
        this.cycleLimitEstimationConstant = Math.log(-Math.expm1(Math.log(0.99) / (double)numberOfComponents));
    }

    int estimateCycleLimit(int numberOfDistinctElements) {
        return (int)Math.max(1.0, Math.ceil((double)this.numberOfComponents * -Math.expm1(this.cycleLimitEstimationConstant / (double)numberOfDistinctElements)));
    }

    @Override
    public SimilarityHasher createHasher() {
        return new Hasher();
    }

    private class Hasher
    implements SimilarityHasher {
        private final PseudoRandomGenerator pseudoRandomGenerator;
        private final PermutationGenerator permutationGenerator;
        private final long[] hashValuesFractionalPart;
        private final int[] hashValuesIntegralPart;
        private final DistinctElementHashProvider distinctElementHashProvider;

        private Hasher() {
            this.pseudoRandomGenerator = SuperMinHashPolicy_v1b.this.pseudoRandomGeneratorProvider.create();
            this.permutationGenerator = new PermutationGenerator(SuperMinHashPolicy_v1b.this.numberOfComponents);
            this.hashValuesFractionalPart = new long[SuperMinHashPolicy_v1b.this.numberOfComponents];
            this.hashValuesIntegralPart = new int[SuperMinHashPolicy_v1b.this.numberOfComponents];
            this.distinctElementHashProvider = new DistinctElementHashProvider(SuperMinHashPolicy_v1b.this.pseudoRandomGeneratorProvider);
        }

        @Override
        public byte[] compute(ElementHashProvider elementHashProvider) {
            int oldLimit;
            int elementIdx;
            Objects.requireNonNull(elementHashProvider);
            int numberOfElements = elementHashProvider.getNumberOfElements();
            Preconditions.checkArgument(numberOfElements > 0, "Number of elements must be positive!");
            this.distinctElementHashProvider.reset(elementHashProvider);
            Arrays.fill(this.hashValuesIntegralPart, Integer.MAX_VALUE);
            int numberOfDistinctElements = this.distinctElementHashProvider.getNumberOfElements();
            int limit = SuperMinHashPolicy_v1b.this.estimateCycleLimit(numberOfDistinctElements);
            int numberOfEmptyComponents = SuperMinHashPolicy_v1b.this.numberOfComponents;
            if (limit <= 1) {
                for (elementIdx = 0; elementIdx < numberOfDistinctElements; ++elementIdx) {
                    this.pseudoRandomGenerator.reset(this.distinctElementHashProvider.getElementHash(elementIdx));
                    long hashValueFractionalPart = this.pseudoRandomGenerator.nextLong();
                    int idx = this.pseudoRandomGenerator.uniformInt(SuperMinHashPolicy_v1b.this.numberOfComponents);
                    int currentHashValuesIntegralPart = this.hashValuesIntegralPart[idx];
                    if (currentHashValuesIntegralPart == Integer.MAX_VALUE) {
                        --numberOfEmptyComponents;
                        this.hashValuesFractionalPart[idx] = hashValueFractionalPart;
                        this.hashValuesIntegralPart[idx] = 0;
                        continue;
                    }
                    if (hashValueFractionalPart >= this.hashValuesFractionalPart[idx]) continue;
                    this.hashValuesFractionalPart[idx] = hashValueFractionalPart;
                }
                oldLimit = 1;
                limit = 2;
            } else {
                oldLimit = 0;
            }
            while (numberOfEmptyComponents > 0) {
                for (elementIdx = 0; elementIdx < numberOfDistinctElements; ++elementIdx) {
                    int hashValueIntegralPart;
                    this.pseudoRandomGenerator.reset(this.distinctElementHashProvider.getElementHash(elementIdx));
                    this.permutationGenerator.reset();
                    for (hashValueIntegralPart = 0; hashValueIntegralPart < oldLimit; ++hashValueIntegralPart) {
                        this.pseudoRandomGenerator.nextLong();
                        this.permutationGenerator.next(this.pseudoRandomGenerator);
                    }
                    for (hashValueIntegralPart = oldLimit; hashValueIntegralPart < limit; ++hashValueIntegralPart) {
                        long hashValueFractionalPart = this.pseudoRandomGenerator.nextLong();
                        int idx = this.permutationGenerator.next(this.pseudoRandomGenerator);
                        int currentHashValuesIntegralPart = this.hashValuesIntegralPart[idx];
                        if (currentHashValuesIntegralPart > hashValueIntegralPart) {
                            if (currentHashValuesIntegralPart == Integer.MAX_VALUE) {
                                --numberOfEmptyComponents;
                            }
                            this.hashValuesFractionalPart[idx] = hashValueFractionalPart;
                            this.hashValuesIntegralPart[idx] = hashValueIntegralPart;
                            continue;
                        }
                        if (currentHashValuesIntegralPart != hashValueIntegralPart || hashValueFractionalPart >= this.hashValuesFractionalPart[idx]) continue;
                        this.hashValuesFractionalPart[idx] = hashValueFractionalPart;
                    }
                }
                oldLimit = limit++;
            }
            return SuperMinHashPolicy_v1b.this.packedArrayHandler.create(i -> this.hashValuesFractionalPart[i], SuperMinHashPolicy_v1b.this.numberOfComponents);
        }
    }
}

