/*
 * Decompiled with CFR 0.152.
 */
package fmpp;

import fmpp.DataModelBuildingException;
import fmpp.EngineXmlUtils;
import fmpp.FmppFileOutputWriter;
import fmpp.FmppOutputWriter;
import fmpp.FmppTemplateLoader;
import fmpp.GenericProcessingException;
import fmpp.IllegalConfigurationException;
import fmpp.LocalDataBuilder;
import fmpp.ProcessingException;
import fmpp.ProgressListener;
import fmpp.TemplateDataModelBuilder;
import fmpp.TemplateEnvironment;
import fmpp.XmlRenderingConfiguration;
import fmpp.util.BorderedReader;
import fmpp.util.BugException;
import fmpp.util.ExceptionCC;
import fmpp.util.FileUtil;
import fmpp.util.InstallationException;
import fmpp.util.MiscUtil;
import fmpp.util.StringUtil;
import freemarker.cache.TemplateConfigurationFactory;
import freemarker.cache.TemplateConfigurationFactoryException;
import freemarker.cache.TemplateLoader;
import freemarker.core.HTMLOutputFormat;
import freemarker.core.OutputFormat;
import freemarker.core.RTFOutputFormat;
import freemarker.core.TemplateConfiguration;
import freemarker.core.UnregisteredOutputFormatException;
import freemarker.core.XHTMLOutputFormat;
import freemarker.core.XMLOutputFormat;
import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.BeansWrapperBuilder;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapperBuilder;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateNodeModel;
import freemarker.template.Version;
import freemarker.template.utility.NullArgumentException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Engine {
    public static final int PMODE_NONE = 0;
    public static final int PMODE_EXECUTE = 1;
    public static final int PMODE_COPY = 2;
    public static final int PMODE_IGNORE = 3;
    public static final int PMODE_RENDER_XML = 4;
    public static final int SKIP_NONE = 0;
    public static final int SKIP_STATIC = 1;
    public static final int SKIP_ALL = 2;
    public static final String PARAMETER_VALUE_SOURCE = "source";
    public static final String PARAMETER_VALUE_OUTPUT = "output";
    public static final String PARAMETER_VALUE_HOST = "host";
    public static final String XPATH_ENGINE_DONT_SET = "dontSet";
    public static final String XPATH_ENGINE_DEFAULT = "default";
    public static final String XPATH_ENGINE_XALAN = "xalan";
    public static final String XPATH_ENGINE_JAXEN = "jaxen";
    public static final Version VERSION_0_9_15 = new Version(0, 9, 15);
    public static final Version VERSION_0_9_16 = new Version(0, 9, 16);
    public static final Version DEFAULT_RECOMMENDED_DEFAULTS = VERSION_0_9_15;
    private static final String IGNOREDIR_FILE = "ignoredir.fmpp";
    private static final String CREATEDIR_FILE = "createdir.fmpp";
    private static final Set<String> STATIC_FILE_EXTS_V1 = new HashSet<String>();
    private static final Set<String> STATIC_FILE_EXTS_V2;
    private static Version cachedVersion;
    private static String cachedBuildInfo;
    private final Version recommendedDefaults;
    private File srcRoot;
    private File outRoot;
    private File dataRoot;
    private boolean dontTraverseDirs;
    private Map<String, List<File>> freemarkerLinks = new HashMap<String, List<File>>();
    private boolean stopOnError = true;
    private Map<String, Object> data = new HashMap<String, Object>();
    private LayeredChooser localDataBuilders = new LayeredChooser();
    private TemplateDataModelBuilder tdmBuilder;
    private String outputEncoding = "source";
    private String urlEscapingCharset = "output";
    private boolean mapCommonExtensionsToOutputFormats;
    private List<OutputFormatChooser> outputFormatChoosers = new ArrayList<OutputFormatChooser>();
    private List<PModeChooser> pModeChoosers = new ArrayList<PModeChooser>();
    private LayeredChooser headerChoosers = new LayeredChooser();
    private LayeredChooser footerChoosers = new LayeredChooser();
    private List<TurnChooser> turnChoosers = new ArrayList<TurnChooser>();
    private boolean csPathCmp = false;
    private boolean expertMode = false;
    private List<String> removeExtensions = new ArrayList<String>();
    private List<String> removePostfixes = new ArrayList<String>();
    private List<String[]> replaceExtensions = new ArrayList<String[]>();
    private boolean removeFreemarkerExtensions;
    private int skipUnchanged;
    private boolean alwaysCrateDirs = false;
    private boolean ignoreCvsFiles = true;
    private boolean ignoreSvnFiles = true;
    private boolean ignoreTemporaryFiles = true;
    private String xpathEngine = "dontSet";
    private Object xmlEntityResolver;
    private boolean validateXml = false;
    private List<XmlRenderingCfgContainer> xmlRendCfgCntrs = new ArrayList<XmlRenderingCfgContainer>();
    private Configuration fmCfg;
    private MultiProgressListener progListeners = new MultiProgressListener();
    private TemplateEnvironment templateEnv;
    private int maxTurn;
    private int currentTurn;
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private Boolean chachedXmlSupportAvailable;
    private boolean parametersLocked;
    private Map<File, Boolean> ignoredDirCache = new HashMap<File, Boolean>();
    private Set<File> processedFiles = new HashSet<File>();
    private static final int MAX_WBLN = 64;
    private static final Map<String, OutputFormat> COMMON_EXTENSIONS_TO_OUTPUT_FORMATS;

    public Engine() {
        this((Version)null);
    }

    public Engine(Version recommendedDefaults) {
        this(recommendedDefaults, null, null);
    }

    public Engine(BeansWrapper objectWrapper) {
        this(objectWrapper, null);
    }

    public Engine(BeansWrapper objectWrapper, Version freemarkerIncompatibleImprovements) {
        this(null, freemarkerIncompatibleImprovements, objectWrapper);
    }

    public Engine(Version recommendedDefaults, Version freemarkerIncompatibleImprovements, BeansWrapper objectWrapper) {
        if (recommendedDefaults == null) {
            recommendedDefaults = DEFAULT_RECOMMENDED_DEFAULTS;
        }
        Engine.validateRecommendedDefaults(recommendedDefaults);
        this.recommendedDefaults = recommendedDefaults;
        if (freemarkerIncompatibleImprovements == null) {
            freemarkerIncompatibleImprovements = Engine.getDefaultFreemarkerIncompatibleImprovements(recommendedDefaults);
        }
        this.fmCfg = new Configuration(freemarkerIncompatibleImprovements);
        if (objectWrapper == null) {
            objectWrapper = Engine.createDefaultObjectWrapper(recommendedDefaults, freemarkerIncompatibleImprovements);
        }
        this.fmCfg.setObjectWrapper((ObjectWrapper)objectWrapper);
        this.fmCfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        this.fmCfg.setTemplateUpdateDelayMilliseconds(2147473647L);
        this.fmCfg.setDefaultEncoding("ISO-8859-1");
        this.fmCfg.setLocale(Locale.US);
        this.fmCfg.setNumberFormat("0.############");
        this.fmCfg.setLocalizedLookup(false);
        this.fmCfg.setAPIBuiltinEnabled(true);
        if (Engine.recommendedDefaultsGE0916(recommendedDefaults)) {
            this.mapCommonExtensionsToOutputFormats = true;
            this.removeFreemarkerExtensions = true;
        }
        this.templateEnv = new TemplateEnvironment(this);
    }

    public static void validateRecommendedDefaults(Version recommendedDefaults) {
        if (recommendedDefaults == null) {
            return;
        }
        if (recommendedDefaults.intValue() < VERSION_0_9_15.intValue()) {
            throw new IllegalArgumentException("\"recommendedDefaults\" setting value \"" + recommendedDefaults + "\" is lower than the allowed minimum, \"" + VERSION_0_9_15 + "\".");
        }
        if (recommendedDefaults.intValue() > Engine.getVersion().intValue()) {
            throw new IllegalArgumentException("\"recommendedDefaults\" setting value \"" + recommendedDefaults + "\" is higher than the current FMPP version, \"" + Engine.getVersion() + "\".");
        }
    }

    private static BeansWrapper createDefaultObjectWrapper(Version recommendedDefaults, Version fmIncompImprovements) {
        BeansWrapper objectWrapper;
        if (Engine.recommendedDefaultsGE0916(recommendedDefaults) && fmIncompImprovements.intValue() >= Configuration.VERSION_2_3_21.intValue()) {
            DefaultObjectWrapperBuilder dowb = new DefaultObjectWrapperBuilder(fmIncompImprovements);
            dowb.setForceLegacyNonListCollections(false);
            dowb.setIterableSupport(true);
            objectWrapper = dowb.build();
        } else if (fmIncompImprovements == null || fmIncompImprovements.intValue() < Configuration.VERSION_2_3_21.intValue()) {
            BeansWrapper bw = fmIncompImprovements != null ? new BeansWrapper(fmIncompImprovements) : new BeansWrapper();
            bw.setSimpleMapWrapper(true);
            objectWrapper = bw;
        } else {
            BeansWrapperBuilder bwb = new BeansWrapperBuilder(fmIncompImprovements);
            bwb.setSimpleMapWrapper(true);
            objectWrapper = bwb.build();
        }
        return objectWrapper;
    }

    public static Version getDefaultFreemarkerIncompatibleImprovements(Version fmppRecommendedDefaults) {
        return Engine.recommendedDefaultsGE0916(fmppRecommendedDefaults) ? Configuration.VERSION_2_3_28 : Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(File[] sources) throws ProcessingException {
        this.progListeners.notifyProgressEvent(this, 1, null, 0, null, null);
        try {
            try {
                this.setupSession();
            }
            catch (IllegalConfigurationException e) {
                throw new ProcessingException(this, null, e);
            }
            try {
                int i;
                File[] srcs = new File[sources.length];
                for (i = 0; i < sources.length; ++i) {
                    File src = sources[i].getCanonicalFile();
                    if (!FileUtil.isInsideOrEquals(src, this.srcRoot)) {
                        throw new IOException("The source file (" + src.getPath() + ") is not inside the source root (" + this.srcRoot.getPath() + ")");
                    }
                    srcs[i] = src;
                }
                while (this.currentTurn <= this.maxTurn) {
                    for (i = 0; i < srcs.length; ++i) {
                        if (srcs[i] == null) continue;
                        File out = new File(this.outRoot, FileUtil.getRelativePath(this.srcRoot, srcs[i]));
                        boolean done = srcs[i].isDirectory() ? this.processDir(srcs[i], out) : this.processFile(srcs[i], out, true);
                        if (!done) continue;
                        srcs[i] = null;
                    }
                    ++this.currentTurn;
                }
            }
            finally {
                this.cleanupSession();
            }
        }
        catch (ProcessingException e) {
            this.progListeners.notifyProgressEvent(this, 4, null, 0, e, null);
            throw e;
        }
        catch (IOException e) {
            this.progListeners.notifyProgressEvent(this, 4, null, 0, e, null);
            throw new ProcessingException(this, null, e);
        }
        this.progListeners.notifyProgressEvent(this, 4, null, 0, null, null);
    }

    private boolean isDirMarkedWithIgnoreFile(File dir) throws IOException {
        File parentDir;
        Boolean ignore = this.ignoredDirCache.get(dir);
        if (ignore != null) {
            return ignore;
        }
        if (!dir.equals(this.srcRoot) && (parentDir = dir.getParentFile()) != null && this.isDirMarkedWithIgnoreFile(parentDir)) {
            this.ignoredDirCache.put(dir, Boolean.TRUE);
            return true;
        }
        boolean ign = new File(dir, IGNOREDIR_FILE).exists();
        this.ignoredDirCache.put(dir, ign ? Boolean.TRUE : Boolean.FALSE);
        return ign;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(File src, File out) throws ProcessingException {
        this.progListeners.notifyProgressEvent(this, 1, null, 0, null, null);
        File oldSrcRoot = this.srcRoot;
        File oldOutRoot = this.outRoot;
        try {
            try {
                if (src == null) {
                    throw new IllegalArgumentException("The source argument can't be null.");
                }
                if (out == null) {
                    throw new IllegalArgumentException("The output argument can't be null.");
                }
                if (!(src = src.getCanonicalFile()).exists()) {
                    throw new IOException("Source file not found: " + src.getPath());
                }
                if (src.isDirectory()) {
                    throw new IOException("Source file can't be a directory: " + src.getPath());
                }
                if ((out = out.getCanonicalFile()).exists() && out.isDirectory()) {
                    throw new IOException("The output file can't be a directory.");
                }
                if (this.srcRoot == null) {
                    this.setSourceRoot(src.getParentFile());
                }
                if (this.outRoot == null) {
                    this.setOutputRoot(out.getParentFile());
                }
                try {
                    this.setupSession();
                }
                catch (IllegalConfigurationException e) {
                    throw new ProcessingException(this, null, e);
                }
                try {
                    if (!FileUtil.isInsideOrEquals(src, this.srcRoot)) {
                        throw new IOException("The source file (" + src.getPath() + ") is not inside the source root (" + this.srcRoot.getPath() + ")");
                    }
                    if (!FileUtil.isInsideOrEquals(out, this.outRoot)) {
                        throw new IOException("The output file (" + out.getPath() + ") is not inside the output root (" + this.outRoot.getPath() + ")");
                    }
                    while (this.currentTurn <= this.maxTurn) {
                        this.processFile(src, out, false);
                        ++this.currentTurn;
                    }
                }
                finally {
                    this.cleanupSession();
                }
            }
            catch (ProcessingException e) {
                this.progListeners.notifyProgressEvent(this, 4, null, 0, e, null);
                throw e;
            }
            catch (IOException e) {
                this.progListeners.notifyProgressEvent(this, 4, null, 0, e, null);
                throw new ProcessingException(this, null, e);
            }
            this.progListeners.notifyProgressEvent(this, 4, null, 0, null, null);
        }
        finally {
            if (oldSrcRoot == null) {
                this.srcRoot = null;
            }
            if (oldOutRoot == null) {
                this.outRoot = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupSession() throws IOException, IllegalConfigurationException {
        if (this.srcRoot == null) {
            throw new IllegalConfigurationException("The source root directory was not set.");
        }
        if (this.outRoot == null) {
            throw new IllegalConfigurationException("The output root directory was not set.");
        }
        if (!this.srcRoot.exists()) {
            throw new IOException("Source root directory does not exists.");
        }
        if (!this.srcRoot.isDirectory()) {
            throw new IOException("Source root is not a directory.");
        }
        if (this.outRoot.exists() && !this.outRoot.isDirectory()) {
            throw new IOException("Output root is not a directory.");
        }
        boolean done = false;
        try {
            if (!this.xpathEngine.equals(XPATH_ENGINE_DONT_SET)) {
                EngineXmlUtils.setFreeMarkerXPathEngine(this.xpathEngine);
            }
            this.maxTurn = 1;
            for (TurnChooser turnChooser : this.turnChoosers) {
                int turn = turnChooser.turn;
                if (turn <= this.maxTurn) continue;
                this.maxTurn = turn;
            }
            this.currentTurn = 1;
            this.fmCfg.setTemplateLoader((TemplateLoader)new FmppTemplateLoader(this));
            this.fmCfg.clearTemplateCache();
            this.fmCfg.clearSharedVariables();
            for (Map.Entry entry : this.data.entrySet()) {
                try {
                    this.fmCfg.setSharedVariable((String)entry.getKey(), entry.getValue());
                }
                catch (TemplateModelException e) {
                    throw new IllegalConfigurationException("Failed to convert data " + StringUtil.jQuote((String)entry.getKey()) + " to FreeMarker variable.", e);
                }
            }
            this.fmCfg.setTemplateConfigurations((TemplateConfigurationFactory)new FMPPTemplateConfigurationFactory());
            this.processedFiles.clear();
            this.ignoredDirCache.clear();
            this.templateEnv.setupForSession();
            this.lockParameters();
            done = true;
        }
        finally {
            if (!done) {
                this.cleanupSession();
            }
        }
    }

    private void cleanupSession() {
        this.unlockParameters();
        this.templateEnv.cleanAfterSession();
        this.processedFiles.clear();
        this.ignoredDirCache.clear();
        this.fmCfg.clearTemplateCache();
        this.fmCfg.clearSharedVariables();
    }

    private boolean processDir(File srcDir, File dstDir) throws IOException, ProcessingException {
        if (this.isDirMarkedWithIgnoreFile(srcDir)) {
            return true;
        }
        String name = srcDir.getName();
        if (this.ignoreCvsFiles && (name.equals("CVS") || !this.csPathCmp && name.equalsIgnoreCase("CVS"))) {
            return true;
        }
        if (this.ignoreSvnFiles && (name.equals(".svn") || !this.csPathCmp && name.equalsIgnoreCase(".svn"))) {
            return true;
        }
        if ((this.alwaysCrateDirs || new File(srcDir, CREATEDIR_FILE).isFile()) && !dstDir.exists()) {
            if (!dstDir.mkdirs()) {
                throw new IOException("Failed to create directory: " + dstDir.getAbsolutePath());
            }
            this.progListeners.notifyProgressEvent(this, 8, srcDir, 0, null, null);
        }
        if (!this.dontTraverseDirs) {
            File[] dir = srcDir.listFiles();
            for (int i = 0; i < dir.length; ++i) {
                File sf = dir[i];
                String fn = sf.getName();
                File df = new File(dstDir, fn);
                if (sf.isDirectory()) {
                    this.processDir(sf, df);
                    continue;
                }
                this.processFile(sf, df, true);
            }
        }
        return false;
    }

    private boolean processFile(File sf, File df, boolean allowOutFAdj) throws IOException, ProcessingException {
        File srcDir;
        if (this.isDirMarkedWithIgnoreFile(sf.getParentFile().getCanonicalFile())) {
            return true;
        }
        if (sf.getName().equalsIgnoreCase(CREATEDIR_FILE) && new File(srcDir = sf.getParentFile(), CREATEDIR_FILE).exists()) {
            File dstDir = df.getParentFile();
            if (!dstDir.exists()) {
                if (!dstDir.mkdirs()) {
                    throw new IOException("Failed to create directory: " + dstDir.getAbsolutePath());
                }
                this.progListeners.notifyProgressEvent(this, 8, srcDir, 0, null, null);
            }
            return true;
        }
        if (this.currentTurn != this.getTurn(sf)) {
            return false;
        }
        if (!this.processedFiles.add(sf)) {
            return true;
        }
        int pmode = this.getProcessingMode(sf);
        Throwable catchedExc = null;
        try {
            if (allowOutFAdj && pmode != 3) {
                df = this.adjustOutputFileName(df);
            }
            if (!this.expertMode && pmode != 3 && sf.equals(df)) {
                throw new IOException("The input and output files are the same (" + sf.getPath() + "); if you want to allow this, you should turn on expert mode.");
            }
            if (pmode != 3 && (this.skipUnchanged == 2 || this.skipUnchanged == 1 && pmode == 2)) {
                long dfl = df.lastModified();
                long sfl = sf.lastModified();
                if (df.exists() && dfl > 0L && sfl > 0L && dfl == sfl) {
                    this.progListeners.notifyProgressEvent(this, 7, sf, pmode, null, null);
                    return true;
                }
            }
        }
        catch (Throwable e) {
            catchedExc = e;
        }
        this.progListeners.notifyProgressEvent(this, 2, sf, pmode, null, null);
        try {
            if (catchedExc != null) {
                throw catchedExc;
            }
            switch (pmode) {
                case 1: {
                    this.executeFile(sf, df);
                    break;
                }
                case 2: {
                    File dstDir = df.getParentFile();
                    if (dstDir != null) {
                        dstDir.mkdirs();
                    }
                    FileUtil.copyFile(sf, df);
                    break;
                }
                case 4: {
                    this.renderXmlFile(sf, df);
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    throw new BugException("Bad processing mode in the procModeChoosers:" + pmode);
                }
            }
        }
        catch (Throwable e) {
            catchedExc = e;
            this.progListeners.notifyProgressEvent(this, 3, sf, pmode, e, null);
        }
        if (catchedExc == null) {
            this.progListeners.notifyProgressEvent(this, 3, sf, pmode, null, null);
        } else if (this.stopOnError || catchedExc instanceof OutOfMemoryError) {
            throw new ProcessingException(this, sf, catchedExc);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeFile(File sf, File df) throws ProcessingException, DataModelBuildingException, TemplateException, IOException {
        Template template = this.fmCfg.getTemplate(FileUtil.pathToUnixStyle(FileUtil.getRelativePath(this.srcRoot, sf)));
        String outEnc = this.getOutputEncoding();
        if (this.outputEncoding.equalsIgnoreCase(PARAMETER_VALUE_SOURCE)) {
            outEnc = template.getEncoding();
        }
        FmppFileOutputWriter out = new FmppFileOutputWriter(this, df, outEnc);
        boolean done = false;
        try {
            this.templateEnv.execute(template, out, sf, null, null, null);
            done = true;
            ((FmppOutputWriter)out).close(!done);
        }
        catch (Throwable throwable) {
            ((FmppOutputWriter)out).close(!done);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void renderXmlFile(File sf, File df) throws ProcessingException, DataModelBuildingException, TemplateException, IOException, InstallationException, GenericProcessingException {
        Template template;
        TemplateNodeModel wrappedDoc;
        boolean doctMustBeValidated;
        XmlRenderingConfiguration xrc;
        int xrccIdx;
        Object loadedDoc = null;
        boolean isLoadedDocumentValidated = false;
        String sfPathForComparison = null;
        int xrccln = this.xmlRendCfgCntrs.size();
        XmlRenderingConfiguration curXRC = null;
        for (xrccIdx = 0; xrccIdx < xrccln; ++xrccIdx) {
            int i;
            XmlRenderingCfgContainer curXRCC = this.xmlRendCfgCntrs.get(xrccIdx);
            curXRC = curXRCC.xmlRenderingCfg;
            int ln = curXRCC.compiledPathPatterns.length;
            if (ln != 0) {
                int i2;
                if (sfPathForComparison == null) {
                    sfPathForComparison = this.normalizePathForComparison(FileUtil.pathToUnixStyle(FileUtil.getRelativePath(this.srcRoot, sf)));
                }
                for (i2 = 0; i2 < ln && !curXRCC.compiledPathPatterns[i2].matcher(sfPathForComparison).matches(); ++i2) {
                }
                if (i2 == ln) continue;
            }
            if ((ln = curXRC.getDocumentElementLocalNames().size()) == 0) break;
            if (loadedDoc == null) {
                Object o = curXRC.getXmlDataLoaderOptions().get("validate");
                if (o == null) {
                    o = this.getValidateXml() ? Boolean.TRUE : Boolean.FALSE;
                }
                isLoadedDocumentValidated = Boolean.TRUE.equals(o);
                while (true) {
                    try {
                        loadedDoc = EngineXmlUtils.loadXmlFile(this, sf, isLoadedDocumentValidated);
                    }
                    catch (Exception e) {
                        if (!isLoadedDocumentValidated) throw new DataModelBuildingException("Failed to load XML source file.", e);
                        isLoadedDocumentValidated = false;
                        continue;
                    }
                    break;
                }
            }
            List localNames = curXRC.getDocumentElementLocalNames();
            List namespaces = curXRC.getDocumentElementNamespaces();
            for (i = 0; i < ln && !EngineXmlUtils.documentElementEquals(loadedDoc, (String)namespaces.get(i), (String)localNames.get(i)); ++i) {
            }
            if (i != ln) break;
        }
        XmlRenderingConfiguration xmlRenderingConfiguration = xrc = xrccIdx != xrccln ? curXRC : null;
        if (xrc == null) {
            throw new GenericProcessingException("The source file has to be processed in \"renderXml\" mode, but there is no matching XML rendering configuration for it. (Check the if... options of the XML rendering configurations)");
        }
        if (xrc.getCopy()) {
            File dstDir = df.getParentFile();
            if (dstDir != null) {
                dstDir.mkdirs();
            }
            FileUtil.copyFile(sf, df);
            return;
        }
        Object xmlDLValidateOpt = xrc.getXmlDataLoaderOptions().get("validate");
        if (xmlDLValidateOpt == null) {
            xmlDLValidateOpt = this.getValidateXml();
        }
        if (isLoadedDocumentValidated != (doctMustBeValidated = Boolean.TRUE.equals(xmlDLValidateOpt))) {
            loadedDoc = null;
        }
        if (loadedDoc == null) {
            try {
                loadedDoc = EngineXmlUtils.loadXmlFile(this, sf, doctMustBeValidated);
            }
            catch (Exception e) {
                throw new DataModelBuildingException("Failed to load the XML source file.", e);
            }
        }
        ArrayList<Object> args = new ArrayList<Object>(2);
        args.add("");
        args.add(xrc.getXmlDataLoaderOptions());
        try {
            wrappedDoc = EngineXmlUtils.loadWithXmlDataLoader(this, args, loadedDoc);
        }
        catch (Exception e) {
            throw new DataModelBuildingException("Failed to load the XML source file.", e);
        }
        try {
            template = this.fmCfg.getTemplate(xrc.getTemplatePath());
        }
        catch (IOException e) {
            throw new GenericProcessingException("Failed to load the template specified by the XML rendering configuration: " + xrc.getTemplatePath(), e);
        }
        String outEnc = this.getOutputEncoding();
        if (this.outputEncoding.equalsIgnoreCase(PARAMETER_VALUE_SOURCE)) {
            outEnc = template.getEncoding();
        }
        FmppFileOutputWriter out = new FmppFileOutputWriter(this, df, outEnc);
        boolean done = false;
        try {
            this.templateEnv.execute(template, out, sf, loadedDoc, wrappedDoc, xrc.getLocalDataBuilders());
            done = true;
            ((FmppOutputWriter)out).close(!done);
        }
        catch (Throwable throwable) {
            ((FmppOutputWriter)out).close(!done);
            throw throwable;
        }
    }

    public Version getRecommendedDefaults() {
        return this.recommendedDefaults;
    }

    public boolean getStopOnError() {
        return this.stopOnError;
    }

    public void setStopOnError(boolean stopOnError) {
        this.checkParameterLock();
        this.stopOnError = stopOnError;
    }

    public File getOutputRoot() {
        return this.outRoot;
    }

    public void setOutputRoot(File outputRoot) throws IOException {
        this.checkParameterLock();
        this.outRoot = outputRoot.getCanonicalFile();
    }

    public File getSourceRoot() {
        return this.srcRoot;
    }

    public void setSourceRoot(File srcRoot) throws IOException {
        this.checkParameterLock();
        this.srcRoot = srcRoot != null ? srcRoot.getCanonicalFile() : null;
    }

    public File getDataRoot() {
        return this.dataRoot != null ? this.dataRoot : this.srcRoot;
    }

    public void setDataRoot(File dataRoot) throws IOException {
        this.checkParameterLock();
        this.dataRoot = dataRoot != null ? dataRoot.getCanonicalFile() : null;
    }

    public void addFreemarkerLink(String name, File fileOrDir) throws IOException {
        this.checkParameterLock();
        NullArgumentException.check((String)"name", (Object)name);
        if (name.startsWith("@")) {
            throw new IllegalArgumentException("The \"name\" argument can't start with @. The @ prefix is used only when you refer to a FreeMarker link. It is not part of the link name. For example, if the link name is \"foo\", then you can refer to it as <#include '/@foo/something.ftl'>.");
        }
        NullArgumentException.check((String)"fileOrDir", (Object)fileOrDir);
        fileOrDir = fileOrDir.getCanonicalFile();
        List<File> dirs = this.freemarkerLinks.get(name);
        if (dirs == null) {
            dirs = new ArrayList<File>();
            this.freemarkerLinks.put(name, dirs);
        }
        dirs.add(fileOrDir);
    }

    public List getFreemarkerLink(String name) {
        return this.freemarkerLinks.get(name);
    }

    public void clearFreemarkerLinks() {
        this.checkParameterLock();
        this.freemarkerLinks.clear();
    }

    public void addProgressListener(ProgressListener listener) {
        this.checkParameterLock();
        this.progListeners.addUserListener(listener);
    }

    public void clearProgressListeners() {
        this.checkParameterLock();
        this.progListeners.clearUserListeners();
    }

    public void setTemplateDataModelBuilder(TemplateDataModelBuilder tdmBuilder) {
        this.checkParameterLock();
        this.tdmBuilder = tdmBuilder;
    }

    public void setTemplateDataModelBuilder(String className) throws DataModelBuildingException {
        Class<?> clazz;
        this.checkParameterLock();
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException exc) {
            throw new DataModelBuildingException("Template data builder class not found: " + className);
        }
        if (clazz.isInterface()) {
            throw new DataModelBuildingException("Template data builder class must be a class, but this is an interface: " + clazz.getName());
        }
        if (!TemplateDataModelBuilder.class.isAssignableFrom(clazz)) {
            throw new DataModelBuildingException("Template data builder class must implement TemplateDataModelBuilder interface, but this class doesn't implement that: " + clazz.getName());
        }
        try {
            this.setTemplateDataModelBuilder((TemplateDataModelBuilder)clazz.newInstance());
        }
        catch (InstantiationException exc) {
            throw new DataModelBuildingException("Failed to create an instance of " + clazz.getName() + ": " + exc, exc);
        }
        catch (IllegalAccessException exc) {
            throw new DataModelBuildingException("Failed to create an instance of " + clazz.getName() + ": " + exc, exc);
        }
    }

    public TemplateDataModelBuilder getTemplateDataModelBuilder() {
        return this.tdmBuilder;
    }

    public void setSourceEncoding(String encoding) {
        this.checkParameterLock();
        if (encoding == null || encoding.equals(PARAMETER_VALUE_HOST)) {
            this.fmCfg.setDefaultEncoding(System.getProperty("file.encoding"));
        } else {
            this.fmCfg.setDefaultEncoding(encoding);
        }
    }

    public String getSourceEncoding() {
        return this.fmCfg.getDefaultEncoding();
    }

    public void setLocale(Locale locale) {
        this.checkParameterLock();
        if (locale == null) {
            this.fmCfg.setLocale(Locale.getDefault());
        } else {
            this.fmCfg.setLocale(locale);
        }
    }

    public void setLocale(String locale) {
        this.checkParameterLock();
        if (locale == null || locale.equals(PARAMETER_VALUE_HOST)) {
            this.fmCfg.setLocale(Locale.getDefault());
        } else {
            String[] codes = StringUtil.split(locale + "__", '_');
            this.fmCfg.setLocale(new Locale(codes[0], codes[1], codes[2]));
        }
    }

    public Locale getLocale() {
        return this.fmCfg.getLocale();
    }

    public void setOldTemplateSyntax(boolean oldSyntax) {
        this.checkParameterLock();
        this.fmCfg.setStrictSyntaxMode(!oldSyntax);
    }

    public boolean getOldTemplateSyntax() {
        return !this.fmCfg.getStrictSyntaxMode();
    }

    public void setTagSyntax(int tagSyntax) {
        this.checkParameterLock();
        this.fmCfg.setTagSyntax(tagSyntax);
    }

    public int getTagSyntax() {
        return this.fmCfg.getTagSyntax();
    }

    public void setInterpolationSyntax(int interpolationSyntax) {
        this.checkParameterLock();
        this.fmCfg.setInterpolationSyntax(interpolationSyntax);
    }

    public int getInterpolationSyntax() {
        return this.fmCfg.getInterpolationSyntax();
    }

    public void setOutputEncoding(String outputEncoding) {
        this.checkParameterLock();
        this.outputEncoding = outputEncoding == null ? PARAMETER_VALUE_SOURCE : (outputEncoding.equals(PARAMETER_VALUE_HOST) ? System.getProperty("file.encoding") : outputEncoding);
    }

    public String getOutputEncoding() {
        return this.outputEncoding;
    }

    public void setUrlEscapingCharset(String urlEscapingCharset) {
        this.checkParameterLock();
        if (urlEscapingCharset == null || urlEscapingCharset.equals(PARAMETER_VALUE_OUTPUT)) {
            this.urlEscapingCharset = PARAMETER_VALUE_OUTPUT;
            this.fmCfg.setURLEscapingCharset(null);
        } else if (urlEscapingCharset.equals(PARAMETER_VALUE_HOST)) {
            this.urlEscapingCharset = System.getProperty("file.encoding");
            this.fmCfg.setURLEscapingCharset(this.urlEscapingCharset);
        } else {
            this.urlEscapingCharset = urlEscapingCharset;
            this.fmCfg.setURLEscapingCharset(this.urlEscapingCharset);
        }
    }

    public String getUrlEscapingCharset() {
        return this.urlEscapingCharset;
    }

    public void setNumberFormat(String format) {
        this.checkParameterLock();
        this.fmCfg.setNumberFormat(format);
    }

    public void setBooleanFormat(String format) {
        this.checkParameterLock();
        this.fmCfg.setBooleanFormat(format);
    }

    public String getNumberFormat() {
        return this.fmCfg.getNumberFormat();
    }

    public void setDateFormat(String format) {
        this.checkParameterLock();
        this.fmCfg.setDateFormat(format);
    }

    public String getDateFormat() {
        return this.fmCfg.getDateFormat();
    }

    public void setTimeFormat(String format) {
        this.checkParameterLock();
        this.fmCfg.setTimeFormat(format);
    }

    public String getTimeFormat() {
        return this.fmCfg.getTimeFormat();
    }

    public void setDateTimeFormat(String format) {
        this.checkParameterLock();
        this.fmCfg.setDateTimeFormat(format);
    }

    public String getDateTimeFormat() {
        return this.fmCfg.getDateTimeFormat();
    }

    public void setTimeZone(TimeZone zone) {
        this.checkParameterLock();
        this.fmCfg.setTimeZone(zone);
    }

    public void setTimeZone(String zone) {
        this.checkParameterLock();
        try {
            this.fmCfg.setSetting("time_zone", zone);
        }
        catch (TemplateException e) {
            throw new RuntimeException("Failed to set timeZone in FreeMarker Configuration", e);
        }
    }

    public void setSQLDateAndTimeTimeZone(TimeZone zone) {
        this.checkParameterLock();
        this.fmCfg.setSQLDateAndTimeTimeZone(zone);
    }

    public void setSQLDateAndTimeTimeZone(String zone) {
        this.checkParameterLock();
        try {
            this.fmCfg.setSetting("sql_date_and_time_time_zone", zone);
        }
        catch (TemplateException e) {
            throw new RuntimeException("Failed to set timeZone in FreeMarker Configuration", e);
        }
    }

    public TimeZone getTimeZone() {
        return this.fmCfg.getTimeZone();
    }

    public void setMapCommonExtensionsToOutputFormats(boolean mapCommonExtensionsToOutputFormats) {
        this.checkParameterLock();
        this.mapCommonExtensionsToOutputFormats = mapCommonExtensionsToOutputFormats;
    }

    public boolean getMapCommonExtensionsToOutputFormats() {
        return this.mapCommonExtensionsToOutputFormats;
    }

    public void setOutputFormat(OutputFormat outputFormat) {
        this.fmCfg.setOutputFormat(outputFormat);
    }

    public OutputFormat getOutputFormat() {
        return this.fmCfg.getOutputFormat();
    }

    public void addOutputFormatChooser(String pathPattern, OutputFormat outputFormat) {
        this.checkParameterLock();
        this.outputFormatChoosers.add(new OutputFormatChooser(pathPattern, outputFormat));
    }

    public OutputFormat getOutputFormat(String name) throws UnregisteredOutputFormatException {
        return this.fmCfg.getOutputFormat(name);
    }

    public void addModeChooser(String pattern, int pmode) {
        this.checkParameterLock();
        PModeChooser chooser = new PModeChooser(pattern);
        if (pmode != 1 && pmode != 4 && pmode != 2 && pmode != 3) {
            throw new IllegalArgumentException("Illegal processing mode was passed to Engine.addProcessingModeChooser: " + pmode);
        }
        chooser.pMode = pmode;
        this.pModeChoosers.add(chooser);
    }

    public void addHeaderChooser(String pattern, String header) {
        this.checkParameterLock();
        this.headerChoosers.addChooser(0, pattern, header);
    }

    public void addHeaderChooser(int layer, String pattern, String footer) {
        this.checkParameterLock();
        this.headerChoosers.addChooser(layer, pattern, footer);
    }

    public void addFooterChooser(String pattern, String footer) {
        this.checkParameterLock();
        this.footerChoosers.addChooser(0, pattern, footer);
    }

    public void addFooterChooser(int layer, String pattern, String footer) {
        this.checkParameterLock();
        this.footerChoosers.addChooser(layer, pattern, footer);
    }

    public void addTurnChooser(String pattern, int turn) {
        this.checkParameterLock();
        TurnChooser chooser = new TurnChooser(pattern);
        chooser.turn = turn;
        this.turnChoosers.add(chooser);
    }

    public void clearOutputFormatChoosers() {
        this.checkParameterLock();
        this.outputFormatChoosers.clear();
    }

    public void clearModeChoosers() {
        this.checkParameterLock();
        this.pModeChoosers.clear();
    }

    public void clearHeaderChoosers() {
        this.checkParameterLock();
        this.headerChoosers.clear();
    }

    public void clearFooterChoosers() {
        this.checkParameterLock();
        this.footerChoosers.clear();
    }

    public void clearTurnChoosers() {
        this.checkParameterLock();
        this.turnChoosers.clear();
    }

    public void setCaseSensitive(boolean cs) {
        this.checkParameterLock();
        if (this.csPathCmp != cs) {
            this.csPathCmp = cs;
            for (PModeChooser pModeChooser : this.pModeChoosers) {
                pModeChooser.recompile();
            }
            for (TurnChooser turnChooser : this.turnChoosers) {
                turnChooser.recompile();
            }
            for (XmlRenderingCfgContainer xmlRenderingCfgContainer : this.xmlRendCfgCntrs) {
                xmlRenderingCfgContainer.recompile();
            }
            this.headerChoosers.recompile();
            this.footerChoosers.recompile();
            this.localDataBuilders.recompile();
        }
    }

    public boolean getCaseSensitive() {
        return this.csPathCmp;
    }

    public void setExpertMode(boolean expertMode) {
        this.checkParameterLock();
        this.expertMode = expertMode;
    }

    public boolean getExpertMode() {
        return this.expertMode;
    }

    public void addRemovePostfix(String postfix) {
        this.checkParameterLock();
        if (postfix == null || postfix.length() == 0) {
            throw new IllegalArgumentException("engine parameter \"remove postfix\" can't be empty string");
        }
        if (postfix.indexOf(".") != -1) {
            throw new IllegalArgumentException("engine parameter \"remove postfix\" can't contain dot: " + postfix);
        }
        this.removePostfixes.add(postfix);
    }

    public void addRemoveExtension(String extension) {
        this.checkParameterLock();
        this.checkExtension("remove extension", extension);
        this.removeExtensions.add(extension);
    }

    public void addReplaceExtension(String oldExtension, String newExtension) {
        this.checkParameterLock();
        this.checkExtension("replace extension", oldExtension);
        this.checkExtension("replace extension", newExtension);
        this.replaceExtensions.add(new String[]{oldExtension, newExtension});
    }

    private void checkExtension(String paramName, String extension) {
        if (extension == null || extension.length() == 0) {
            throw new IllegalArgumentException("Problem with engine parameter \"" + paramName + "\": extension can't be empty string");
        }
        if (extension.startsWith(".")) {
            throw new IllegalArgumentException("Problem with parameter \"" + paramName + "\": extension can't start with dot: " + extension);
        }
    }

    public void clearRemovePostfixes() {
        this.checkParameterLock();
        this.removePostfixes.clear();
    }

    public void clearRemoveExtensions() {
        this.checkParameterLock();
        this.removeExtensions.clear();
    }

    public void clearReplaceExtensions() {
        this.checkParameterLock();
        this.replaceExtensions.clear();
    }

    public void setRemoveFreemarkerExtensions(boolean removeFreemarkerExtensions) {
        this.checkParameterLock();
        this.removeFreemarkerExtensions = removeFreemarkerExtensions;
    }

    public boolean getRemoveFreemarkerExtensions() {
        return this.removeFreemarkerExtensions;
    }

    public void setDontTraverseDirectories(boolean dontTraverseDirs) {
        this.checkParameterLock();
        this.dontTraverseDirs = dontTraverseDirs;
    }

    public boolean getDontTraverseDirectories() {
        return this.dontTraverseDirs;
    }

    public void setSkipUnchanged(int skipWhat) {
        this.checkParameterLock();
        this.skipUnchanged = skipWhat;
    }

    public int getSkipUnchanged() {
        return this.skipUnchanged;
    }

    public void setAlwaysCreateDirectories(boolean enable) {
        this.checkParameterLock();
        this.alwaysCrateDirs = enable;
    }

    public boolean getAlwaysCreateDirectories() {
        return this.alwaysCrateDirs;
    }

    public void setIgnoreCvsFiles(boolean ignoreCvsFiles) {
        this.checkParameterLock();
        this.ignoreCvsFiles = ignoreCvsFiles;
    }

    public boolean getIgnoreCvsFiles() {
        return this.ignoreCvsFiles;
    }

    public void setIgnoreSvnFiles(boolean ignoreSvnFiles) {
        this.checkParameterLock();
        this.ignoreSvnFiles = ignoreSvnFiles;
    }

    public boolean getIgnoreSvnFiles() {
        return this.ignoreSvnFiles;
    }

    public void setIgnoreTemporaryFiles(boolean ignoreTemporaryFiles) {
        this.checkParameterLock();
        this.ignoreTemporaryFiles = ignoreTemporaryFiles;
    }

    public boolean getIgnoreTemporaryFiles() {
        return this.ignoreTemporaryFiles;
    }

    public void setXpathEngine(String xpathEngine) {
        this.checkParameterLock();
        this.xpathEngine = xpathEngine;
    }

    public String getXpathEngine() {
        return this.xpathEngine;
    }

    public void setXmlEntityResolver(Object xmlEntityResolver) throws InstallationException {
        this.checkParameterLock();
        if (xmlEntityResolver != null && !EngineXmlUtils.isEntityResolver(xmlEntityResolver)) {
            throw new IllegalArgumentException("The argument to Engine.setXmlEntiryResolver must implement org.xml.sax.EntityResolver. The class of the argument was " + xmlEntityResolver.getClass().getName() + ".");
        }
        this.xmlEntityResolver = xmlEntityResolver;
    }

    public Object getXmlEntiryResolver() {
        return this.xmlEntityResolver;
    }

    public void setValidateXml(boolean validateXml) {
        this.checkParameterLock();
        this.validateXml = validateXml;
    }

    public boolean getValidateXml() {
        return this.validateXml;
    }

    public void addXmlRenderingConfiguration(XmlRenderingConfiguration xmlRendering) {
        if (xmlRendering.getTemplatePath() == null && !xmlRendering.getCopy()) {
            throw new IllegalArgumentException("Illegal XmlRenderingConfiguration: Either \"template\" must be non-null, or \"copy\" must be true.");
        }
        this.xmlRendCfgCntrs.add(new XmlRenderingCfgContainer(xmlRendering));
        List ldbs = xmlRendering.getLocalDataBuilders();
        int ln = ldbs.size();
        for (int i = 0; i < ln; ++i) {
            Object o = ldbs.get(i);
            if (!(o instanceof ProgressListener)) continue;
            this.progListeners.addXmlLdbListener((ProgressListener)o);
        }
    }

    public void clearXmlRenderingConfigurations() {
        this.xmlRendCfgCntrs.clear();
        this.progListeners.clearXmlLdbListeners();
    }

    public void addData(String name, Object value) {
        this.checkParameterLock();
        this.data.put(name, value);
    }

    public void addData(String name, byte value) {
        this.checkParameterLock();
        this.data.put(name, new Byte(value));
    }

    public void addData(String name, short value) {
        this.checkParameterLock();
        this.data.put(name, new Short(value));
    }

    public void addData(String name, int value) {
        this.checkParameterLock();
        this.data.put(name, new Integer(value));
    }

    public void addData(String name, long value) {
        this.checkParameterLock();
        this.data.put(name, new Long(value));
    }

    public void addData(String name, float value) {
        this.checkParameterLock();
        this.data.put(name, new Float(value));
    }

    public void addData(String name, double value) {
        this.checkParameterLock();
        this.data.put(name, new Double(value));
    }

    public void addData(String name, char value) {
        this.checkParameterLock();
        this.data.put(name, new Character(value));
    }

    public void addData(String name, boolean value) {
        this.checkParameterLock();
        this.data.put(name, value ? Boolean.TRUE : Boolean.FALSE);
    }

    public void addData(Map map) {
        this.checkParameterLock();
        this.data.putAll(map);
    }

    public void clearData() {
        this.checkParameterLock();
        this.data.clear();
    }

    public Object getData(String name) {
        return this.data.get(name);
    }

    public Object removeData(String name) {
        return this.data.remove(name);
    }

    public void clearSharedVariables() {
        this.clearData();
    }

    public void addLocalDataBuilder(int layer, String pathPattern, LocalDataBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException("Argument \"builder\" to addLocalDataBuilder can't be null.");
        }
        this.localDataBuilders.addChooser(layer, pathPattern, builder);
        if (builder instanceof ProgressListener) {
            this.progListeners.addLdbListener((ProgressListener)((Object)builder));
        }
    }

    public void clearLocalDataBuilders() {
        this.localDataBuilders.clear();
        this.progListeners.clearLdbListeners();
    }

    public static String getProgressListenerEventName(int event) {
        if (event == 2) {
            return "begin file processing";
        }
        if (event == 1) {
            return "begin processing session";
        }
        if (event == 3) {
            return "end file processing";
        }
        if (event == 4) {
            return "end processing session";
        }
        if (event == 5) {
            return "ignoring dir";
        }
        if (event == 7) {
            return "source not modified";
        }
        if (event == 6) {
            return "warning";
        }
        return "event code " + event;
    }

    public TemplateModel wrap(Object obj) throws TemplateModelException {
        return this.fmCfg.getObjectWrapper().wrap(obj);
    }

    public TemplateEnvironment getTemplateEnvironment() {
        if (this.templateEnv.isExternallyAccessible()) {
            return this.templateEnv;
        }
        throw new IllegalStateException("You can't get the TemplateEnvironment, since no template execution is in progress currently.");
    }

    public boolean isTemplateEnvironmentAvailable() {
        return this.templateEnv.isExternallyAccessible();
    }

    public Object setAttribute(String name, Object value) {
        Object oldValue = this.attributes.put(name, value);
        if (value instanceof ProgressListener) {
            this.progListeners.addAttrListener((ProgressListener)value);
        }
        if (oldValue instanceof ProgressListener && !MiscUtil.mapContainsObject(this.attributes, oldValue)) {
            this.progListeners.removeAttrListener((ProgressListener)oldValue);
        }
        return oldValue;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Object removeAttribute(String name) {
        Object oldValue = this.attributes.remove(name);
        if (oldValue instanceof ProgressListener && !MiscUtil.mapContainsObject(this.attributes, oldValue)) {
            this.progListeners.removeAttrListener((ProgressListener)oldValue);
        }
        return oldValue;
    }

    public void clearAttribues() {
        this.progListeners.clearAttrListeners();
        this.attributes.clear();
    }

    public static String getVersionNumber() {
        return Engine.getVersion().toString();
    }

    public static Version getVersion() {
        if (cachedVersion == null) {
            Engine.loadVersionInfo();
        }
        return cachedVersion;
    }

    public static String getBuildInfo() {
        if (cachedBuildInfo == null) {
            Engine.loadVersionInfo();
        }
        return cachedBuildInfo;
    }

    public static String getFreeMarkerVersionNumber() {
        return Configuration.getVersionNumber();
    }

    public static Version getFreeMarkerVersion() {
        return Configuration.getVersion();
    }

    public Version getFreemarkerIncomplatibleImprovements() {
        return this.fmCfg.getIncompatibleImprovements();
    }

    public boolean isXmlSupportAvailabile() {
        if (this.chachedXmlSupportAvailable != null) {
            return this.chachedXmlSupportAvailable;
        }
        try {
            MiscUtil.checkXmlSupportAvailability(null);
        }
        catch (InstallationException e) {
            this.chachedXmlSupportAvailable = Boolean.FALSE;
            return false;
        }
        this.chachedXmlSupportAvailable = Boolean.TRUE;
        return true;
    }

    public void checkXmlSupportAvailability(String requiredForThis) throws InstallationException {
        if (this.chachedXmlSupportAvailable != null && this.chachedXmlSupportAvailable.booleanValue()) {
            return;
        }
        try {
            MiscUtil.checkXmlSupportAvailability(requiredForThis);
        }
        catch (InstallationException e) {
            this.chachedXmlSupportAvailable = Boolean.FALSE;
            throw e;
        }
        this.chachedXmlSupportAvailable = Boolean.TRUE;
    }

    Configuration getFreemarkerConfiguration() {
        return this.fmCfg;
    }

    void sendWarning(File srcFile, String message) {
        try {
            this.progListeners.notifyProgressEvent(this, 6, srcFile, 0, null, message);
        }
        catch (ProcessingException processingException) {
            // empty catch block
        }
    }

    Reader wrapReader(Reader r, File f) throws IOException {
        String footer;
        int i;
        String header;
        List headers = this.headerChoosers.choose(f);
        List footers = this.footerChoosers.choose(f);
        int hc = headers.size();
        int fc = footers.size();
        if (hc == 0 && fc == 0) {
            return r;
        }
        StringBuffer sb = null;
        if (hc != 0) {
            if (hc == 1) {
                header = (String)headers.get(0);
            } else {
                sb = new StringBuffer(40 + hc * 80);
                for (i = 0; i < hc; ++i) {
                    sb.append((String)headers.get(i));
                }
                header = sb.toString();
            }
            header = this.moveHeaderAfterTheFtlDirective(header, r);
        } else {
            header = null;
        }
        if (fc != 0) {
            if (fc == 1) {
                footer = (String)footers.get(0);
            } else {
                if (sb == null) {
                    sb = new StringBuffer(40 + fc * 80);
                } else {
                    sb.setLength(0);
                }
                for (i = fc - 1; i >= 0; --i) {
                    sb.append((String)footers.get(i));
                }
                footer = sb.toString();
            }
        } else {
            footer = null;
        }
        return new BorderedReader(header, r, footer);
    }

    List getLocalDataBuildersForFile(File sf) throws IOException {
        return this.localDataBuilders.choose(sf);
    }

    Pattern pathPatternToRegexpPattern(String path) {
        String originalPattern = path;
        path = FileUtil.pathToUnixStyle(path);
        if (!this.csPathCmp) {
            path = path.toLowerCase();
        }
        path = FileUtil.pathPatternToPerl5Regex(path);
        try {
            return Pattern.compile(path);
        }
        catch (PatternSyntaxException exc) {
            throw new BugException("Failed to parse path pattern: " + originalPattern, exc);
        }
    }

    private String moveHeaderAfterTheFtlDirective(String header, Reader r) throws IOException {
        block14: {
            int wbln;
            StringBuffer sb = new StringBuffer(64);
            char[] wb = new char[64];
            int mode = 0;
            int submode = 0;
            char quot = ' ';
            int cmpIdx = 0;
            do {
                wbln = r.read(wb);
                for (int i = 0; i < wbln; ++i) {
                    char c = wb[i];
                    if (mode == 0) {
                        if (Character.isWhitespace(c)) continue;
                        mode = 1;
                    }
                    if (mode == 1) {
                        if (cmpIdx < 5 && c == "<#ftl".charAt(cmpIdx)) {
                            ++cmpIdx;
                            continue;
                        }
                        if (cmpIdx == 5 && (Character.isWhitespace(c) || c == '>' || c == '/')) {
                            mode = 2;
                        } else {
                            mode = -1;
                            break;
                        }
                    }
                    if (mode != 2) continue;
                    if (submode == 0) {
                        if (c == '>') {
                            sb.append(wb, 0, i + 1);
                            sb.append(header);
                            if (i < wbln - 1) {
                                sb.append(wb, i + 1, wbln - (i + 1));
                            }
                            header = sb.toString();
                            break block14;
                        }
                        if (c != '\'' && c != 34) continue;
                        quot = c;
                        if (i != 0 && wb[i - 1] == 'r' || sb.length() > 0 && sb.charAt(sb.length() - 1) == 'r') {
                            submode = 2;
                            continue;
                        }
                        submode = 1;
                        continue;
                    }
                    if (submode == 1) {
                        if (c == '\\') {
                            submode = 3;
                            continue;
                        }
                        if (c != quot) continue;
                        submode = 0;
                        continue;
                    }
                    if (submode == 2) {
                        if (c != quot) continue;
                        submode = 0;
                        continue;
                    }
                    if (submode != 3) continue;
                    submode = 1;
                }
                if (wbln <= 0) continue;
                sb.append(wb, 0, wbln);
            } while (wbln >= 64 && mode != -1);
            header = header + sb.toString();
        }
        return header;
    }

    private File adjustOutputFileName(File f) throws IOException {
        String fn = f.getName();
        fn = this.applyRemoveExtensionSetting(fn);
        fn = this.applyRemovePostfixesSetting(fn);
        fn = this.applyReplaceExtensionsSetting(fn);
        if (this.removeFreemarkerExtensions) {
            String fnLC = fn.toLowerCase();
            if (fnLC.endsWith(".ftl")) {
                fn = fn.substring(0, fn.length() - 4);
            } else if (fnLC.endsWith(".ftlh") || fnLC.endsWith(".ftlx")) {
                fn = fn.substring(0, fn.length() - 5);
            }
        }
        if (fn.length() == 0) {
            throw new IOException("The deduced output file name is empty for this source file: " + FileUtil.getRelativePath(this.outRoot, f));
        }
        return new File(f.getParent(), fn).getCanonicalFile();
    }

    private String applyRemoveExtensionSetting(String fn) {
        String fnNormdCase = this.csPathCmp ? fn : fn.toLowerCase();
        int ln = this.removeExtensions.size();
        for (int i = 0; i < ln; ++i) {
            String dotExtToRemoveNormdCase;
            String dotExtToRemove = "." + this.removeExtensions.get(i);
            String string = dotExtToRemoveNormdCase = this.csPathCmp ? dotExtToRemove : dotExtToRemove.toLowerCase();
            if (!fnNormdCase.endsWith(dotExtToRemoveNormdCase)) continue;
            return fn.substring(0, fn.length() - dotExtToRemove.length());
        }
        return fn;
    }

    private String applyRemovePostfixesSetting(String fn) {
        int extDotIdx;
        String fnWithoutExt;
        int i = fn.indexOf(46);
        if (i != -1) {
            fnWithoutExt = fn.substring(0, i);
            extDotIdx = i;
        } else {
            fnWithoutExt = fn;
            extDotIdx = fn.length();
        }
        String fnWithoutExtNormdCase = this.csPathCmp ? fnWithoutExt : fnWithoutExt.toLowerCase();
        int ln = this.removePostfixes.size();
        for (int i2 = 0; i2 < ln; ++i2) {
            String posfixToRemoveNormdCase;
            String posfixToRemove = this.removePostfixes.get(i2);
            String string = posfixToRemoveNormdCase = this.csPathCmp ? posfixToRemove : posfixToRemove.toLowerCase();
            if (!fnWithoutExtNormdCase.endsWith(posfixToRemoveNormdCase)) continue;
            return fn.substring(0, extDotIdx - posfixToRemove.length()) + fn.substring(extDotIdx);
        }
        return fn;
    }

    private String applyReplaceExtensionsSetting(String fn) {
        String fnNormedCase = this.csPathCmp ? fn : fn.toLowerCase();
        int ln = this.replaceExtensions.size();
        for (int i = 0; i < ln; ++i) {
            String replacedExtNormedCase;
            String[] fromToPair = this.replaceExtensions.get(i);
            String string = replacedExtNormedCase = this.csPathCmp ? fromToPair[0] : fromToPair[0].toLowerCase();
            if (!fnNormedCase.endsWith("." + replacedExtNormedCase)) continue;
            return fn.substring(0, fn.length() - fromToPair[0].length()) + fromToPair[1];
        }
        return fn;
    }

    private <T extends Chooser> T findChooser(List<T> choosers, File f) throws IOException {
        String fp = FileUtil.getRelativePath(this.srcRoot, f);
        String unixStylePath = FileUtil.pathToUnixStyle(fp);
        return this.findChooser(choosers, unixStylePath);
    }

    private <T extends Chooser> T findChooser(List<T> choosers, String unixStylePath) {
        String normalizedPath = this.normalizePathForComparison(unixStylePath);
        for (Chooser chooser : choosers) {
            if (!chooser.regexpPattern.matcher(normalizedPath).matches()) continue;
            return (T)chooser;
        }
        return null;
    }

    private String normalizePathForComparison(String fp) {
        if (fp.endsWith("/")) {
            fp = fp.substring(0, fp.length() - 1);
        }
        if (!fp.startsWith("/")) {
            fp = "/" + fp;
        }
        if (!this.csPathCmp) {
            fp = fp.toLowerCase();
        }
        return fp;
    }

    private int getProcessingMode(File f) throws IOException {
        String fpathCisUpper;
        String fpathCisLower;
        String fnameCisLower;
        String fnameCs = f.getName();
        String fpathCs = f.getAbsolutePath();
        if (!this.csPathCmp) {
            fnameCisLower = fnameCs.toLowerCase();
            fpathCisLower = fpathCs.toLowerCase();
            fpathCisUpper = fpathCs.toUpperCase();
        } else {
            fnameCisLower = fnameCs;
            fpathCisLower = fpathCs;
            fpathCisUpper = fpathCs;
        }
        int i = fnameCs.lastIndexOf(".");
        String extLower = i == -1 ? "" : fnameCs.substring(i + 1).toLowerCase();
        if (extLower.equals("fmpp")) {
            return 3;
        }
        if (this.ignoreCvsFiles && (fnameCisLower.equals(".cvsignore") || fpathCisUpper.indexOf("/CVS/") != -1 || fpathCisUpper.indexOf(File.separatorChar + "CVS" + File.separatorChar) != -1 || fnameCs.length() > 2 && fnameCs.startsWith(".#"))) {
            return 3;
        }
        if (this.ignoreSvnFiles && (fpathCisLower.indexOf("/.svn/") != -1 || fpathCisLower.indexOf(File.separatorChar + ".svn" + File.separatorChar) != -1)) {
            return 3;
        }
        if (this.ignoreTemporaryFiles && (fnameCs.length() > 2 && (fnameCs.startsWith("#") && fnameCs.endsWith("#") || fnameCs.startsWith("%") && fnameCs.endsWith("%") || fnameCs.startsWith("._") || extLower.equals("bak")) || fnameCs.length() > 1 && (fnameCs.endsWith("~") || fnameCs.startsWith("~") || extLower.startsWith("~")))) {
            return 3;
        }
        PModeChooser pmc = this.findChooser(this.pModeChoosers, f);
        if (pmc == null) {
            if ((Engine.recommendedDefaultsGE0916(this.recommendedDefaults) ? STATIC_FILE_EXTS_V2 : STATIC_FILE_EXTS_V1).contains(extLower)) {
                return 2;
            }
            if (this.xmlRendCfgCntrs.size() != 0 && extLower.equals("xml")) {
                return 4;
            }
            return 1;
        }
        return pmc.pMode;
    }

    private int getTurn(File f) throws IOException {
        TurnChooser tc = this.findChooser(this.turnChoosers, f);
        return tc != null ? tc.turn : 1;
    }

    private static void loadVersionInfo() {
        Properties vp = new Properties();
        InputStream ins = Engine.class.getClassLoader().getResourceAsStream("fmpp/version.properties");
        if (ins == null) {
            throw new RuntimeException("Version file (<CLASSES>/fmpp/version.properties) is missing.");
        }
        try {
            try {
                vp.load(ins);
            }
            finally {
                ins.close();
            }
        }
        catch (IOException exc) {
            throw new RuntimeException("Error loading version file (<CLASSES>/fmpp/version.properties): " + exc);
        }
        String v = vp.getProperty("version");
        if (v == null) {
            throw new RuntimeException("Version file (<CLASSES>/fmpp/version.properties) is corrupt: version key is missing.");
        }
        String d = vp.getProperty("buildInfo");
        if (d == null) {
            throw new RuntimeException("Version file (<CLASSES>/fmpp/version.properties) is corrupt: buildInfo key is missing.");
        }
        cachedVersion = new Version(v);
        cachedBuildInfo = d;
    }

    private void lockParameters() {
        this.parametersLocked = true;
    }

    private void unlockParameters() {
        this.parametersLocked = false;
    }

    private void checkParameterLock() {
        if (this.parametersLocked) {
            throw new IllegalStateException("You can't change the engine parameters now. Settings can't bechanged while the processing session is runing.");
        }
    }

    private static boolean recommendedDefaultsGE0916(Version recommendedDefaults) {
        return recommendedDefaults.intValue() >= VERSION_0_9_16.intValue();
    }

    static {
        STATIC_FILE_EXTS_V1.addAll(Arrays.asList("jpg", "jpeg", "gif", "png", "swf", "bmp", "pcx", "tga", "tiff", "ico", "zip", "gz", "tgz", "jar", "ace", "bz", "bz2", "tar", "arj", "rar", "lha", "cab", "lzh", "taz", "tz", "arc", "exe", "com", "msi", "class", "dll", "doc", "xls", "pdf", "ps", "chm", "avi", "wav", "mp3", "mpeg", "mpg", "wma", "mov", "fli"));
        STATIC_FILE_EXTS_V2 = new HashSet<String>(STATIC_FILE_EXTS_V1);
        STATIC_FILE_EXTS_V2.addAll(Arrays.asList("webp", "svgz", "tif", "7z", "xz", "txz", "tbz2", "tb2", "z", "deb", "pkg", "rpm", "apk", "iso", "bin", "dmg", "vcd", "sys", "docx", "dotx", "docm", "dot", "odt", "ott", "oth", "odm", "xlsx", "xlsm", "xltx", "xltm", "xlw", "xlt", "ods", "ots", "ppt", "pps", "pot", "pptx", "pptm", "potx", "potm", "odp", "odg", "otp", "odg", "otg", "mkv", "mp4", "m4v", "m4a", "webm", "mpa", "cda", "aif", "h264", "wma", "wmv", "3gp", "3g2", "ogg", "oga", "mogg", "acc", "flac", "aiff", "flv", "swf", "fnt", "ttf", "otf", "woff", "woff2", "eot", "der"));
        COMMON_EXTENSIONS_TO_OUTPUT_FORMATS = new HashMap<String, OutputFormat>();
        COMMON_EXTENSIONS_TO_OUTPUT_FORMATS.put("html", (OutputFormat)HTMLOutputFormat.INSTANCE);
        COMMON_EXTENSIONS_TO_OUTPUT_FORMATS.put("htm", (OutputFormat)HTMLOutputFormat.INSTANCE);
        COMMON_EXTENSIONS_TO_OUTPUT_FORMATS.put("xhtml", (OutputFormat)XHTMLOutputFormat.INSTANCE);
        COMMON_EXTENSIONS_TO_OUTPUT_FORMATS.put("xhtm", (OutputFormat)XHTMLOutputFormat.INSTANCE);
        COMMON_EXTENSIONS_TO_OUTPUT_FORMATS.put("xht", (OutputFormat)XHTMLOutputFormat.INSTANCE);
        COMMON_EXTENSIONS_TO_OUTPUT_FORMATS.put("xml", (OutputFormat)XMLOutputFormat.INSTANCE);
        COMMON_EXTENSIONS_TO_OUTPUT_FORMATS.put("xsd", (OutputFormat)XMLOutputFormat.INSTANCE);
        COMMON_EXTENSIONS_TO_OUTPUT_FORMATS.put("xsl", (OutputFormat)XMLOutputFormat.INSTANCE);
        COMMON_EXTENSIONS_TO_OUTPUT_FORMATS.put("xslt", (OutputFormat)XMLOutputFormat.INSTANCE);
        COMMON_EXTENSIONS_TO_OUTPUT_FORMATS.put("svg", (OutputFormat)XMLOutputFormat.INSTANCE);
        COMMON_EXTENSIONS_TO_OUTPUT_FORMATS.put("wsdl", (OutputFormat)XMLOutputFormat.INSTANCE);
        COMMON_EXTENSIONS_TO_OUTPUT_FORMATS.put("dita", (OutputFormat)XMLOutputFormat.INSTANCE);
        COMMON_EXTENSIONS_TO_OUTPUT_FORMATS.put("ditamap", (OutputFormat)XMLOutputFormat.INSTANCE);
        COMMON_EXTENSIONS_TO_OUTPUT_FORMATS.put("rtf", (OutputFormat)RTFOutputFormat.INSTANCE);
    }

    private class FMPPTemplateConfigurationFactory
    extends TemplateConfigurationFactory {
        private final TemplateConfiguration htmlTC;
        private final TemplateConfiguration xhtmlTC;
        private final TemplateConfiguration xmlTC;
        private final TemplateConfiguration rtfTC;

        FMPPTemplateConfigurationFactory() {
            try {
                this.htmlTC = new TemplateConfiguration();
                this.htmlTC.setOutputFormat(Engine.this.fmCfg.getOutputFormat("HTML"));
                this.xhtmlTC = new TemplateConfiguration();
                this.xhtmlTC.setOutputFormat(Engine.this.fmCfg.getOutputFormat("XHTML"));
                this.xmlTC = new TemplateConfiguration();
                this.xmlTC.setOutputFormat(Engine.this.fmCfg.getOutputFormat("XML"));
                this.rtfTC = new TemplateConfiguration();
                this.rtfTC.setOutputFormat(Engine.this.fmCfg.getOutputFormat("RTF"));
            }
            catch (UnregisteredOutputFormatException e) {
                throw new IllegalStateException(e);
            }
        }

        public TemplateConfiguration get(String name, Object source) throws IOException, TemplateConfigurationFactoryException {
            String ext;
            OutputFormatChooser chooser = (OutputFormatChooser)Engine.this.findChooser(Engine.this.outputFormatChoosers, name);
            if (chooser != null) {
                if (chooser.templateConfiguration == null) {
                    throw new IllegalStateException("Uninitialized OutputFormatChooser.templateConfiguration");
                }
                return chooser.templateConfiguration;
            }
            if (Engine.this.mapCommonExtensionsToOutputFormats && (ext = FileUtil.getLowerCaseFileExtension(name)) != null) {
                if (ext.equals("ftl")) {
                    ext = FileUtil.getLowerCaseFileExtension(name.substring(0, name.length() - 1 - ext.length()));
                }
                if (ext != null) {
                    OutputFormat of = (OutputFormat)COMMON_EXTENSIONS_TO_OUTPUT_FORMATS.get(ext);
                    if (of == HTMLOutputFormat.INSTANCE) {
                        return this.htmlTC;
                    }
                    if (of == XHTMLOutputFormat.INSTANCE) {
                        return this.xhtmlTC;
                    }
                    if (of == XMLOutputFormat.INSTANCE) {
                        return this.xmlTC;
                    }
                    if (of == RTFOutputFormat.INSTANCE) {
                        return this.rtfTC;
                    }
                }
            }
            return null;
        }

        protected void setConfigurationOfChildren(Configuration cfg) {
            for (OutputFormatChooser chooser : Engine.this.outputFormatChoosers) {
                chooser.templateConfiguration.setParentConfiguration(cfg);
            }
            this.htmlTC.setParentConfiguration(cfg);
            this.xhtmlTC.setParentConfiguration(cfg);
            this.xmlTC.setParentConfiguration(cfg);
            this.rtfTC.setParentConfiguration(cfg);
        }
    }

    private class XmlRenderingCfgContainer {
        final XmlRenderingConfiguration xmlRenderingCfg;
        Pattern[] compiledPathPatterns;

        XmlRenderingCfgContainer(XmlRenderingConfiguration xmlRendering) {
            this.xmlRenderingCfg = xmlRendering;
            this.recompile();
        }

        void recompile() {
            List pathPatterns = this.xmlRenderingCfg.getPathPatterns();
            int ln = pathPatterns.size();
            this.compiledPathPatterns = new Pattern[ln];
            for (int i = 0; i < ln; ++i) {
                this.compiledPathPatterns[i] = Engine.this.pathPatternToRegexpPattern((String)pathPatterns.get(i));
            }
        }
    }

    private class MultiProgressListener
    implements ProgressListener {
        private List<ProgressListener> userListeners = new ArrayList<ProgressListener>();
        private List<ProgressListener> attrListeners = new ArrayList<ProgressListener>();
        private List<ProgressListener> ldbListeners = new ArrayList<ProgressListener>();
        private List<ProgressListener> xmlLdbListeners = new ArrayList<ProgressListener>();
        private boolean mergedNeedsRefresh = true;
        private List<ProgressListener> mergedListeners = new ArrayList<ProgressListener>();

        private MultiProgressListener() {
        }

        void addUserListener(ProgressListener listener) {
            if (!MiscUtil.listContainsObject(this.userListeners, listener)) {
                this.userListeners.add(listener);
            }
        }

        void clearUserListeners() {
            this.mergedNeedsRefresh = true;
            this.userListeners.clear();
        }

        void addAttrListener(ProgressListener listener) {
            if (!MiscUtil.listContainsObject(this.attrListeners, listener)) {
                this.mergedNeedsRefresh = true;
                this.attrListeners.add(listener);
            }
        }

        void removeAttrListener(ProgressListener listener) {
            int i = MiscUtil.findObject(this.attrListeners, listener);
            if (i != -1) {
                this.mergedNeedsRefresh = true;
                this.attrListeners.remove(i);
            }
        }

        void clearAttrListeners() {
            this.mergedNeedsRefresh = true;
            this.attrListeners.clear();
        }

        void addLdbListener(ProgressListener listener) {
            if (!MiscUtil.listContainsObject(this.ldbListeners, listener)) {
                this.mergedNeedsRefresh = true;
                this.ldbListeners.add(listener);
            }
        }

        void clearLdbListeners() {
            this.mergedNeedsRefresh = true;
            this.ldbListeners.clear();
        }

        void addXmlLdbListener(ProgressListener listener) {
            if (!MiscUtil.listContainsObject(this.xmlLdbListeners, listener)) {
                this.mergedNeedsRefresh = true;
                this.xmlLdbListeners.add(listener);
            }
        }

        void clearXmlLdbListeners() {
            this.mergedNeedsRefresh = true;
            this.xmlLdbListeners.clear();
        }

        public void notifyProgressEvent(Engine engine, int event, File src, int pMode, Throwable error, Object param) throws ProcessingException {
            if (this.mergedNeedsRefresh) {
                this.refreshMergedListeneres();
            }
            int doneCounter = 0;
            int closingEvent = this.getClosingEvent(event);
            ProcessingException firstException = null;
            for (ProgressListener lr : this.mergedListeners) {
                try {
                    lr.notifyProgressEvent(engine, event, src, pMode, error, param);
                }
                catch (Throwable e) {
                    if (firstException == null) {
                        firstException = new ProcessingException(Engine.this, src, new ExceptionCC("A listener Java object has failed to handle event \"" + Engine.getProgressListenerEventName(event) + "\". The class of the failing listener object is " + lr.getClass().getName() + ".", e));
                    }
                    if (closingEvent != Integer.MIN_VALUE) break;
                }
                ++doneCounter;
            }
            if (firstException != null) {
                if (closingEvent != Integer.MIN_VALUE) {
                    Iterator<ProgressListener> it = this.mergedListeners.iterator();
                    while (it.hasNext() && doneCounter != 0) {
                        ProgressListener lr;
                        lr = it.next();
                        try {
                            lr.notifyProgressEvent(engine, closingEvent, src, pMode, error, param);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        --doneCounter;
                    }
                }
                throw firstException;
            }
        }

        private void refreshMergedListeneres() {
            this.mergedListeners.clear();
            for (ProgressListener o : this.xmlLdbListeners) {
                if (MiscUtil.listContainsObject(this.mergedListeners, o)) continue;
                this.mergedListeners.add(o);
            }
            for (ProgressListener o : this.ldbListeners) {
                if (MiscUtil.listContainsObject(this.mergedListeners, o)) continue;
                this.mergedListeners.add(o);
            }
            for (ProgressListener o : this.attrListeners) {
                if (MiscUtil.listContainsObject(this.mergedListeners, o)) continue;
                this.mergedListeners.add(o);
            }
            for (ProgressListener o : this.userListeners) {
                if (MiscUtil.listContainsObject(this.mergedListeners, o)) continue;
                this.mergedListeners.add(o);
            }
            this.mergedNeedsRefresh = false;
        }

        private int getClosingEvent(int event) {
            if (event == 2) {
                return 3;
            }
            if (event == 1) {
                return 4;
            }
            return Integer.MIN_VALUE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LayeredChooser {
        private List<List<ObjectChooser>> layers = new ArrayList<List<ObjectChooser>>();
        private int usedLayers;

        private LayeredChooser() {
        }

        private void addChooser(int layer, String pathPattern, Object value) {
            if (layer < 0) {
                throw new IllegalArgumentException("Layer index can't be negative: " + layer);
            }
            ObjectChooser chooser = new ObjectChooser(pathPattern, value);
            for (int max = this.layers.size() - 1; max < layer; ++max) {
                this.layers.add(null);
            }
            List<ObjectChooser> choosers = this.layers.get(layer);
            if (choosers == null) {
                choosers = new ArrayList<ObjectChooser>();
                this.layers.set(layer, choosers);
                ++this.usedLayers;
            }
            choosers.add(chooser);
        }

        private List<Object> choose(File f) throws IOException {
            ArrayList<Object> result = new ArrayList<Object>(this.usedLayers);
            for (List<ObjectChooser> choosers : this.layers) {
                ObjectChooser c;
                if (choosers == null || (c = (ObjectChooser)Engine.this.findChooser(choosers, f)) == null) continue;
                result.add(c.value);
            }
            return result;
        }

        private void recompile() {
            for (List<ObjectChooser> choosers : this.layers) {
                for (ObjectChooser choser : choosers) {
                    choser.recompile();
                }
            }
        }

        private void clear() {
            this.layers.clear();
            this.usedLayers = 0;
        }
    }

    private class ObjectChooser
    extends Chooser {
        private final Object value;

        ObjectChooser(String pathPattern, Object value) {
            super(pathPattern);
            this.value = value;
        }
    }

    private class TurnChooser
    extends Chooser {
        private int turn;

        TurnChooser(String pathPattern) {
            super(pathPattern);
        }
    }

    private class PModeChooser
    extends Chooser {
        private int pMode;

        PModeChooser(String pathPattern) {
            super(pathPattern);
        }
    }

    private class OutputFormatChooser
    extends Chooser {
        private final TemplateConfiguration templateConfiguration;

        public OutputFormatChooser(String pathPattern, OutputFormat outputFormat) {
            super(pathPattern);
            TemplateConfiguration templateConfiguration = new TemplateConfiguration();
            templateConfiguration.setOutputFormat(outputFormat);
            this.templateConfiguration = templateConfiguration;
        }
    }

    private class Chooser {
        private final String pathPattern;
        Pattern regexpPattern;

        private Chooser(String pathPattern) {
            this.pathPattern = pathPattern;
            this.regexpPattern = Engine.this.pathPatternToRegexpPattern(pathPattern);
        }

        void recompile() {
            this.regexpPattern = Engine.this.pathPatternToRegexpPattern(this.pathPattern);
        }
    }
}

