/*
 * Decompiled with CFR 0.152.
 */
package fmpp;

import fmpp.Engine;
import fmpp.IllegalConfigurationException;
import fmpp.dataloaders.XmlDataLoader;
import fmpp.util.MiscUtil;
import fmpp.util.StringUtil;
import freemarker.ext.dom.NodeModel;
import freemarker.template.TemplateNodeModel;
import java.io.File;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;

class EngineXmlUtils {
    private EngineXmlUtils() {
    }

    static void setFreeMarkerXPathEngine(String xpathEngine) throws IllegalConfigurationException {
        if (!xpathEngine.equals("dontSet")) {
            if (xpathEngine.equals("default")) {
                NodeModel.useDefaultXPathSupport();
            } else {
                Class cl;
                if (xpathEngine.equals("xalan")) {
                    try {
                        NodeModel.useXalanXPathSupport();
                    }
                    catch (Exception e) {
                        throw new IllegalConfigurationException("Failed to use Xalan XPath engine.", e);
                    }
                }
                if (xpathEngine.equals("jaxen")) {
                    try {
                        NodeModel.useJaxenXPathSupport();
                    }
                    catch (Exception e) {
                        throw new IllegalConfigurationException("Failed to use Jaxen XPath engine.", e);
                    }
                }
                try {
                    cl = MiscUtil.classForName(xpathEngine);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalConfigurationException("Custom XPath engine adapter class " + StringUtil.jQuote(xpathEngine) + " not found. Note that the reserved names are: " + StringUtil.jQuote("dontSet") + ", " + StringUtil.jQuote("default") + ", " + StringUtil.jQuote("xalan") + ", " + StringUtil.jQuote("jaxen") + ".", e);
                }
                NodeModel.setXPathSupportClass((Class)cl);
            }
        }
    }

    static boolean isEntityResolver(Object o) {
        return o instanceof EntityResolver;
    }

    static Object loadXmlFile(Engine eng, File xmlFile, boolean validate) throws Exception {
        return XmlDataLoader.loadXmlFile(eng, xmlFile, true, validate);
    }

    static boolean documentElementEquals(Object doc, String namespace, String localName) {
        Element e = ((Document)doc).getDocumentElement();
        String ns = e.getNamespaceURI();
        String ln = e.getLocalName();
        if (ns == null || ns.length() == 0 ? namespace != null : namespace == null || !namespace.equals(ns)) {
            return false;
        }
        return localName.equals(ln);
    }

    static TemplateNodeModel loadWithXmlDataLoader(Engine eng, List args, Object preLoaderXml) throws Exception {
        XmlDataLoader xdl = new XmlDataLoader();
        return xdl.load(eng, args, (Document)preLoaderXml);
    }
}

