/*
 * Decompiled with CFR 0.152.
 */
package fmpp.dataloaders;

import fmpp.dataloaders.FileDataLoader;
import fmpp.models.JSONNode;
import fmpp.util.FileUtil;
import fmpp.util.JSONParser;
import java.io.InputStream;

public class JSONDataLoader
extends FileDataLoader {
    protected Object load(InputStream in) throws Exception {
        String charset;
        if (this.args.size() < 1 || this.args.size() > 2) {
            throw new IllegalArgumentException("json data loader needs 1 or 2 arguments: json(filename) or json(filename, charset)");
        }
        if (this.args.size() > 1) {
            Object arg = this.args.get(1);
            if (!(arg instanceof String)) {
                throw new IllegalArgumentException("The 2nd argument (charset) must be a string.");
            }
            charset = (String)arg;
        } else {
            charset = this.engine.getSourceEncoding();
        }
        String src = FileUtil.loadString(in, charset);
        Object jsonPOJO = JSONParser.parse(src, this.dataFile.getAbsolutePath());
        return this.finalizeResult(jsonPOJO);
    }

    protected Object finalizeResult(Object jsonPOJO) throws Exception {
        return JSONNode.wrap(jsonPOJO);
    }
}

