/*
 * Decompiled with CFR 0.152.
 */
package fmpp.dataloaders;

import fmpp.Engine;
import fmpp.tdd.DataLoader;
import fmpp.util.StringUtil;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public class NowDataLoader
implements DataLoader {
    public Object load(Engine engine, List args) throws Exception {
        DateFormat sdf;
        String pattern = null;
        boolean dateTypeSet = false;
        int dateType = 0;
        boolean timeTypeSet = false;
        int timeType = 0;
        TimeZone zone = engine.getTimeZone();
        Locale locale = engine.getLocale();
        if (args.size() > 0) {
            if (args.size() != 1) {
                throw new IllegalArgumentException("nowString data loader needs 0 or 1 arguments.");
            }
            if (!(args.get(0) instanceof Map)) {
                throw new IllegalArgumentException("The argument of nowString data loader must be a hash.");
            }
            Map ops = (Map)args.get(0);
            for (Map.Entry e : ops.entrySet()) {
                String opvalue;
                String opname = (String)e.getKey();
                if (opname.equals("locale")) {
                    opvalue = NowDataLoader.strOp(opname, e.getValue());
                    String[] codes = StringUtil.split(opvalue + "__", '_');
                    locale = new Locale(codes[0], codes[1], codes[2]);
                    continue;
                }
                if (opname.equals("date")) {
                    opvalue = NowDataLoader.strOp("date", e.getValue());
                    dateTypeSet = true;
                    if (opvalue.equalsIgnoreCase("short")) {
                        dateType = 3;
                        continue;
                    }
                    if (opvalue.equalsIgnoreCase("medium")) {
                        dateType = 2;
                        continue;
                    }
                    if (opvalue.equalsIgnoreCase("long")) {
                        dateType = 1;
                        continue;
                    }
                    if (opvalue.equalsIgnoreCase("default")) {
                        dateType = 2;
                        continue;
                    }
                    throw new IllegalArgumentException("Illegal value for the date option: " + StringUtil.jQuote(opvalue) + ". Valid values are: short, medium, long, default");
                }
                if (opname.equals("time")) {
                    opvalue = NowDataLoader.strOp(opname, e.getValue());
                    timeTypeSet = true;
                    if (opvalue.equalsIgnoreCase("short")) {
                        timeType = 3;
                        continue;
                    }
                    if (opvalue.equalsIgnoreCase("medium")) {
                        timeType = 2;
                        continue;
                    }
                    if (opvalue.equalsIgnoreCase("long")) {
                        timeType = 1;
                        continue;
                    }
                    if (opvalue.equalsIgnoreCase("default")) {
                        timeType = 2;
                        continue;
                    }
                    throw new IllegalArgumentException("Illegal value for the time option: " + StringUtil.jQuote(opvalue) + ". Valid values are: short, medium, long, default");
                }
                if (opname.equals("pattern")) {
                    pattern = NowDataLoader.strOp(opname, e.getValue());
                    continue;
                }
                if (opname.equals("zone")) {
                    opvalue = NowDataLoader.strOp(opname, e.getValue());
                    zone = TimeZone.getTimeZone(opvalue);
                    continue;
                }
                throw new IllegalArgumentException("Unknown option: " + StringUtil.jQuote(opname) + ". The supported options are: locale, date, time, pattern, zone");
            }
        }
        if (pattern != null) {
            if (dateTypeSet || timeTypeSet) {
                throw new IllegalArgumentException("You can't use the the date/time options together with the pattern option.");
            }
            sdf = new SimpleDateFormat(pattern, locale);
        } else {
            sdf = dateTypeSet ? (timeTypeSet ? DateFormat.getDateTimeInstance(dateType, timeType, locale) : DateFormat.getDateInstance(dateType, locale)) : (timeTypeSet ? DateFormat.getTimeInstance(dateType, locale) : DateFormat.getDateTimeInstance(3, 3, locale));
        }
        if (zone != null) {
            sdf.setTimeZone(zone);
        }
        return sdf.format(new Date());
    }

    private static String strOp(String name, Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        throw new IllegalArgumentException("The value of " + name + "option must be a string.");
    }
}

