/*
 * Decompiled with CFR 0.152.
 */
package fmpp.dataloaders;

import fmpp.dataloaders.AbstractTextDataLoader;
import fmpp.util.DataLoaderUtil;
import fmpp.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SlicedTextDataLoader
extends AbstractTextDataLoader {
    private String separator;
    private boolean trim = false;
    private boolean dropEmptyLastItem = true;

    protected final Object parseText(String text) throws Exception {
        ArrayList<String> res = new ArrayList<String>(100);
        int ln = text.length();
        String separator = this.separator;
        int sl = separator.length();
        int b = 0;
        int e = 0;
        boolean hasMore = true;
        do {
            int si;
            int ti = e;
            if (e < ln) {
                si = 0;
                while (si < sl) {
                    char sc = separator.charAt(si);
                    if (ti >= ln) break;
                    if (sc == '\n') {
                        char c = text.charAt(ti);
                        if (c == '\n') {
                            ++si;
                            ++ti;
                            continue;
                        }
                        if (c == '\r') {
                            ++si;
                            if (++ti >= ln || text.charAt(ti) != '\n') continue;
                            ++ti;
                            continue;
                        }
                        if (si != 0 && (c == ' ' || c == '\t')) {
                            ++ti;
                            continue;
                        }
                    } else if (sc == text.charAt(ti)) {
                        ++si;
                        ++ti;
                        continue;
                    }
                    break;
                }
            } else {
                si = sl;
                ti = ln;
                hasMore = false;
            }
            if (si == sl) {
                String item;
                if (!this.trim) {
                    item = text.substring(b, e);
                } else {
                    int e2;
                    for (e2 = e - 1; e2 >= 0 && Character.isWhitespace(text.charAt(e2)); --e2) {
                    }
                    ++e2;
                    while (b < ln && Character.isWhitespace(text.charAt(b))) {
                        ++b;
                    }
                    item = b < e ? text.substring(b, e2) : "";
                }
                res.add(item);
                e = b = ti;
                continue;
            }
            ++e;
        } while (hasMore);
        if (this.dropEmptyLastItem && ((String)res.get(res.size() - 1)).length() == 0) {
            res.remove(res.size() - 1);
        }
        return this.postProcessItems(res);
    }

    protected List postProcessItems(List items) {
        return items;
    }

    protected final String parseExtraArguments(List args) throws Exception {
        String encoding = null;
        if (args.size() > 1) {
            Object obj = args.get(1);
            if (!(obj instanceof Map)) {
                throw new IllegalArgumentException("The 2nd argument (options) must be a hash.");
            }
            Map options = (Map)obj;
            for (Map.Entry ent : options.entrySet()) {
                String opname = (String)ent.getKey();
                Object opvalue = ent.getValue();
                if (opname.equals("separator")) {
                    this.separator = StringUtil.normalizeLinebreaks(DataLoaderUtil.getStringOption(opname, opvalue));
                    if (this.separator.length() != 0) continue;
                    throw new IllegalArgumentException("The value of the " + StringUtil.jQuote(opname) + "option can't be 0 length string.");
                }
                if (opname.equals("encoding")) {
                    encoding = DataLoaderUtil.getStringOption(opname, opvalue);
                    continue;
                }
                if (opname.equals("trim")) {
                    this.trim = DataLoaderUtil.getBooleanOption(opname, opvalue);
                    continue;
                }
                if (opname.equals("dropEmptyLastItem")) {
                    this.dropEmptyLastItem = DataLoaderUtil.getBooleanOption(opname, opvalue);
                    continue;
                }
                throw new IllegalArgumentException("Unknown option: " + StringUtil.jQuote(opname) + ". The supported options are: encoding, separator, trim, dropEmptyLastItem");
            }
        }
        if (this.separator == null) {
            this.separator = "\n";
        }
        return encoding;
    }
}

