/*
 * Decompiled with CFR 0.152.
 */
package fmpp.models;

import fmpp.models.TemplateModelArrayCollection;
import fmpp.models.TemplateModelListCollection;
import fmpp.models.TemplateModelListSequence;
import fmpp.util.BugException;
import fmpp.util.StringUtil;
import freemarker.template.SimpleDate;
import freemarker.template.SimpleNumber;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateSequenceModel;
import java.io.IOException;
import java.io.Reader;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class CsvSequence
implements TemplateSequenceModel,
TemplateHashModel {
    private static final int T_STRING = 1;
    private static final int T_NUMBER = 2;
    private static final int T_BOOLEAN = 3;
    private static final int T_DATE = 4;
    private static final int T_TIME = 5;
    private static final int T_DATETIME = 6;
    private boolean loaded;
    private ArrayList rows = new ArrayList();
    private Map nameToCol = new HashMap();
    private int colCount;
    private List keyList = new ArrayList();
    private String[] externalHeaderRow;
    private boolean hasHeaderRow = true;
    private boolean normalizeHeaders = false;
    private boolean trimCells = false;
    private String[] emptyValues;
    private char separator = (char)59;
    private String altTrue;
    private String altFalse;
    private char groupingSeparator = '\u0000';
    private char decimalSeparator = (char)46;
    private DateFormat dateFormat;
    private String dateFormatPattern;
    private DateFormat timeFormat;
    private String timeFormatPattern;
    private DateFormat dateTimeFormat;
    private String dateTimeFormatPattern;
    private TimeZone timeZone;

    public void load(Reader in) throws StringUtil.ParseException, IOException {
        if (this.loaded) {
            throw new IllegalStateException("Data already loaded into this CSV sequence.");
        }
        if (this.externalHeaderRow == null && !this.hasHeaderRow) {
            throw new IllegalArgumentException("If \"fileHasHeaders\" is false then the \"headers\" parameter can't be null.");
        }
        new Parser(in).load();
        this.loaded = true;
    }

    public TemplateModel get(int index) throws TemplateModelException {
        return (TemplateModel)this.rows.get(index);
    }

    public int size() throws TemplateModelException {
        return this.rows.size();
    }

    protected String fixBoolean(String s) {
        s = s.trim().toLowerCase();
        if (this.altTrue != null && s.equals(this.altTrue)) {
            return "true";
        }
        if (this.altFalse != null && s.equals(this.altFalse)) {
            return "false";
        }
        return s;
    }

    protected String fixNumber(String s) {
        s = s.trim();
        if (this.groupingSeparator != '\u0000') {
            int i;
            while ((i = s.indexOf(this.groupingSeparator)) != -1) {
                s = s.substring(0, i) + s.substring(i + 1, s.length());
            }
        }
        if (this.decimalSeparator != '.') {
            s = s.replace(this.decimalSeparator, '.');
        }
        return s;
    }

    public TemplateModel get(String key) throws TemplateModelException {
        if (key.equals("headers")) {
            return new TemplateModelListSequence(this.keyList);
        }
        return null;
    }

    public boolean isEmpty() throws TemplateModelException {
        return false;
    }

    public void setExternalHeaderRow(String[] externalHeaderRow) {
        this.externalHeaderRow = externalHeaderRow;
    }

    public String[] getExternalHeaderRow() {
        return this.externalHeaderRow;
    }

    public void setHasHeaderRow(boolean hasHeaderRow) {
        this.hasHeaderRow = hasHeaderRow;
    }

    public boolean getHasHeaderRow() {
        return this.hasHeaderRow;
    }

    public void setNormalizeHeaders(boolean normalizeHeaders) {
        this.normalizeHeaders = normalizeHeaders;
    }

    public boolean getNormalizeHeaders() {
        return this.normalizeHeaders;
    }

    public void setTrimCells(boolean trimCells) {
        this.trimCells = trimCells;
    }

    public boolean getTrimCells() {
        return this.trimCells;
    }

    public void setEmptyValues(String[] emptyValues) {
        this.emptyValues = emptyValues;
    }

    public String[] getEmptyValues() {
        return this.emptyValues;
    }

    public String getAltFalse() {
        return this.altFalse;
    }

    public void setAltFalse(String altFalse) {
        this.altFalse = altFalse;
    }

    public String getAltTrue() {
        return this.altTrue;
    }

    public void setAltTrue(String altTrue) {
        this.altTrue = altTrue;
    }

    public String getDateFormatPattern() {
        return this.dateFormatPattern;
    }

    public void setDateFormatPattern(String dateFormatPattern) {
        if (dateFormatPattern == null) {
            this.dateFormat = null;
        } else {
            this.dateFormat = new SimpleDateFormat(dateFormatPattern);
            if (this.timeZone != null) {
                this.dateFormat.setTimeZone(this.timeZone);
            }
            this.dateFormatPattern = dateFormatPattern;
        }
    }

    public String getDateTimeFormatPattern() {
        return this.dateTimeFormatPattern;
    }

    public void setDateTimeFormatPattern(String dateTimeFormatPattern) {
        if (dateTimeFormatPattern == null) {
            this.dateTimeFormat = null;
        } else {
            this.dateTimeFormat = new SimpleDateFormat(dateTimeFormatPattern);
            if (this.timeZone != null) {
                this.dateTimeFormat.setTimeZone(this.timeZone);
            }
            this.dateTimeFormatPattern = dateTimeFormatPattern;
        }
    }

    public char getDecimalSeparator() {
        return this.decimalSeparator;
    }

    public void setDecimalSeparator(char decimalSeparator) {
        this.decimalSeparator = decimalSeparator;
    }

    public char getGroupingSeparator() {
        return this.groupingSeparator;
    }

    public void setGroupingSeparator(char groupingSeparator) {
        this.groupingSeparator = groupingSeparator;
    }

    public char getSeparator() {
        return this.separator;
    }

    public void setSeparator(char separator) {
        this.separator = separator;
    }

    public String getTimeFormatPattern() {
        return this.timeFormatPattern;
    }

    public void setTimeFormatPattern(String timeFormatPattern) {
        if (timeFormatPattern == null) {
            this.timeFormat = null;
        } else {
            this.timeFormat = new SimpleDateFormat(timeFormatPattern);
            if (this.timeZone != null) {
                this.timeFormat.setTimeZone(this.timeZone);
            }
            this.timeFormatPattern = timeFormatPattern;
        }
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    private class RowHash
    implements TemplateHashModelEx,
    TemplateSequenceModel {
        private TemplateModel[] cols;

        private RowHash(TemplateModel[] cols) {
            this.cols = cols;
        }

        public int size() {
            return CsvSequence.this.colCount;
        }

        public TemplateCollectionModel keys() {
            return new TemplateModelListCollection(CsvSequence.this.keyList);
        }

        public TemplateCollectionModel values() {
            return new TemplateModelArrayCollection(this.cols);
        }

        public TemplateModel get(String key) {
            Integer i = (Integer)CsvSequence.this.nameToCol.get(key);
            if (i != null) {
                return this.cols[i];
            }
            return null;
        }

        public boolean isEmpty() {
            return this.size() == 0;
        }

        public TemplateModel get(int i) throws TemplateModelException {
            return this.cols[i];
        }
    }

    private class Parser {
        private Reader in;
        private StringBuffer wb = new StringBuffer();
        private int cur;

        private Parser(Reader in) {
            this.in = in;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void load() throws IOException, StringUtil.ParseException {
            try {
                String s;
                ArrayList headerTypes = new ArrayList();
                if (CsvSequence.this.externalHeaderRow == null) {
                    this.cur = this.in.read();
                    CsvSequence.this.colCount = 0;
                    boolean hasNextCol = false;
                    while (hasNextCol || this.cur != -1) {
                        s = this.fetchValue();
                        this.load_processHeaderCell(s, headerTypes);
                        if (this.cur != CsvSequence.this.separator) {
                            if (this.cur == 13) {
                                this.cur = this.in.read();
                                if (this.cur == 10) {
                                    this.cur = this.in.read();
                                }
                            } else if (this.cur == 10) {
                                this.cur = this.in.read();
                            } else if (this.cur != -1 && this.cur != CsvSequence.this.separator) {
                                throw new StringUtil.ParseException("Line-break or EOF expected but found " + StringUtil.jQuote(String.valueOf((char)this.cur)) + " instead.");
                            }
                            break;
                        }
                        this.cur = this.in.read();
                        hasNextCol = true;
                    }
                } else {
                    for (int j = 0; j < CsvSequence.this.externalHeaderRow.length; ++j) {
                        String o = CsvSequence.this.externalHeaderRow[j];
                        if (!(o instanceof String)) {
                            throw new IllegalArgumentException("The header at index " + j + " (0 based) is not a string.");
                        }
                        this.load_processHeaderCell(o, headerTypes);
                    }
                    this.cur = this.in.read();
                    if (CsvSequence.this.hasHeaderRow) {
                        while (this.cur != 10 && this.cur != 13 && this.cur != -1) {
                            this.cur = this.in.read();
                        }
                        if (this.cur == 13) {
                            this.cur = this.in.read();
                            if (this.cur == 10) {
                                this.cur = this.in.read();
                            }
                        } else if (this.cur == 10) {
                            this.cur = this.in.read();
                        }
                    }
                }
                while (this.cur != -1) {
                    TemplateModel[] row = new TemplateModel[CsvSequence.this.colCount];
                    int colIdx = 0;
                    while (true) {
                        s = this.fetchValue();
                        if (CsvSequence.this.emptyValues != null) {
                            for (int i = 0; i < CsvSequence.this.emptyValues.length; ++i) {
                                if (!s.equals(CsvSequence.this.emptyValues[i])) continue;
                                s = "";
                                break;
                            }
                        }
                        if (colIdx >= CsvSequence.this.colCount) {
                            throw new StringUtil.ParseException("Row " + (CsvSequence.this.rows.size() + 2) + " contains more columns than the number of header cells.");
                        }
                        int t = (Integer)headerTypes.get(colIdx);
                        if (t == 1) {
                            row[colIdx] = new SimpleScalar(s);
                        } else if (t == 2) {
                            if ((s = CsvSequence.this.fixNumber(s)).length() != 0) {
                                row[colIdx] = new SimpleNumber((Number)StringUtil.stringToBigDecimal(s));
                            }
                        } else if (t == 3) {
                            if ((s = CsvSequence.this.fixBoolean(s)).length() != 0) {
                                row[colIdx] = StringUtil.stringToBoolean(s) ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
                            }
                        } else if (t == 4) {
                            if (s.length() != 0) {
                                if (CsvSequence.this.dateFormat != null) {
                                    try {
                                        row[colIdx] = new SimpleDate(CsvSequence.this.dateFormat.parse(s.trim()), 2);
                                    }
                                    catch (ParseException e) {
                                        throw new StringUtil.ParseException("Date value " + StringUtil.jQuote(s) + " is not valid according to pattern " + StringUtil.jQuote(CsvSequence.this.dateFormatPattern));
                                    }
                                } else {
                                    row[colIdx] = StringUtil.stringToDate(s, CsvSequence.this.timeZone);
                                }
                            }
                        } else if (t == 5) {
                            if (s.length() != 0) {
                                if (CsvSequence.this.timeFormat != null) {
                                    try {
                                        row[colIdx] = new SimpleDate(CsvSequence.this.timeFormat.parse(s.trim()), 1);
                                    }
                                    catch (ParseException e) {
                                        throw new StringUtil.ParseException("Time value " + StringUtil.jQuote(s) + " is not valid according to pattern " + StringUtil.jQuote(CsvSequence.this.timeFormatPattern));
                                    }
                                } else {
                                    row[colIdx] = StringUtil.stringToTime(s, CsvSequence.this.timeZone);
                                }
                            }
                        } else if (t == 6) {
                            if (s.length() != 0) {
                                if (CsvSequence.this.dateTimeFormat != null) {
                                    try {
                                        row[colIdx] = new SimpleDate(CsvSequence.this.dateTimeFormat.parse(s.trim()), 3);
                                    }
                                    catch (ParseException e) {
                                        throw new StringUtil.ParseException("Date-time value " + StringUtil.jQuote(s) + " is not valid according to pattern " + StringUtil.jQuote(CsvSequence.this.dateTimeFormatPattern));
                                    }
                                } else {
                                    row[colIdx] = StringUtil.stringToDateTime(s, CsvSequence.this.timeZone);
                                }
                            }
                        } else {
                            throw new BugException("Unknown column type " + t);
                        }
                        ++colIdx;
                        if (this.cur != CsvSequence.this.separator) {
                            if (this.cur == 13) {
                                this.cur = this.in.read();
                                if (this.cur != 10) break;
                                this.cur = this.in.read();
                                break;
                            }
                            if (this.cur == 10) {
                                this.cur = this.in.read();
                                break;
                            }
                            if (this.cur == -1 || this.cur == CsvSequence.this.separator) break;
                            throw new StringUtil.ParseException("Line-break or EOF expected but found" + StringUtil.jQuote(String.valueOf((char)this.cur)) + " instead.");
                        }
                        this.cur = this.in.read();
                    }
                    CsvSequence.this.rows.add(new RowHash(row));
                }
            }
            finally {
                this.in.close();
            }
        }

        private void load_processHeaderCell(String s, List headerTypes) throws StringUtil.ParseException {
            int type;
            int i;
            if (CsvSequence.this.normalizeHeaders) {
                int open = s.indexOf(40);
                int close = s.lastIndexOf(41);
                if (open != -1 && close != -1 && open < close) {
                    s = s.substring(0, open) + s.substring(close + 1);
                }
            }
            if ((i = s.lastIndexOf(58)) == -1) {
                s = s.trim();
                type = 1;
            } else {
                String s2 = s.substring(i + 1).trim().toLowerCase();
                s = s.substring(0, i).trim();
                if (s2.equals("n") || s2.equals("number")) {
                    type = 2;
                } else if (s2.equals("s") || s2.equals("string")) {
                    type = 1;
                } else if (s2.equals("b") || s2.equals("boolean")) {
                    type = 3;
                } else if (s2.equals("d") || s2.equals("date")) {
                    type = 4;
                } else if (s2.equals("t") || s2.equals("time")) {
                    type = 5;
                } else if (s2.equals("dt") || s2.equals("dateTime")) {
                    type = 6;
                } else {
                    throw new StringUtil.ParseException("Unknown data type in a header: " + StringUtil.jQuote(s2));
                }
            }
            if (CsvSequence.this.normalizeHeaders) {
                s = s.toLowerCase();
                s = StringUtil.replace(s, " ", "_");
                s = StringUtil.replace(s, "-", "_");
                s = StringUtil.replace(s, ",", "_");
                s = StringUtil.replace(s, ";", "_");
                s = StringUtil.replace(s, ":", "_");
                while (s.indexOf("__") != -1) {
                    s = StringUtil.replace(s, "__", "_");
                }
            }
            CsvSequence.this.nameToCol.put(s, new Integer(CsvSequence.this.colCount));
            CsvSequence.this.keyList.add(new SimpleScalar(s));
            headerTypes.add(new Integer(type));
            CsvSequence.this.colCount++;
        }

        private String fetchValue() throws IOException, StringUtil.ParseException {
            this.wb.setLength(0);
            if (this.cur == 34) {
                this.cur = this.in.read();
                while (this.cur != -1) {
                    if (this.cur != 34) {
                        this.wb.append((char)this.cur);
                        this.cur = this.in.read();
                        continue;
                    }
                    this.cur = this.in.read();
                    if (this.cur == 34) {
                        this.wb.append((char)this.cur);
                        this.cur = this.in.read();
                        continue;
                    }
                    return this.wb.toString();
                }
                throw new StringUtil.ParseException("Reached the end of the file, and the closing quotation mark of value is missing.");
            }
            while (this.cur != CsvSequence.this.separator && this.cur != -1 && this.cur != 10 && this.cur != 13) {
                this.wb.append((char)this.cur);
                this.cur = this.in.read();
            }
            String r = this.wb.toString();
            if (CsvSequence.this.trimCells) {
                r = r.trim();
            }
            return r;
        }
    }
}

