/*
 * Decompiled with CFR 0.152.
 */
package fmpp.models;

import fmpp.models.JSONNode;
import fmpp.models.JSONNullNode;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateSequenceModel;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONArrayNode
extends JSONNode
implements TemplateSequenceModel {
    private static final long serialVersionUID = 1L;
    public static final String NODE_TYPE = "array";
    public static final String DEFAULT_NODE_NAME = JSONArrayNode.nodeTypeToDefaultNodeName("array");
    private static JSONNode JSON_NULL_MARK = new JSONNode(null, null){
        private static final long serialVersionUID = 1L;

        public String getNodeType() throws TemplateModelException {
            return null;
        }

        public TemplateSequenceModel getChildNodes() throws TemplateModelException {
            return null;
        }

        @Override
        protected String getDefaultNodeName() {
            return null;
        }

        public Object getAdaptedObject(Class<?> arg0) {
            return null;
        }
    };
    private final List<Object> elements;
    private transient JSONNode[] wrappedElements;

    public JSONArrayNode(JSONNode parentNode, String nodeName, List elements) {
        super(parentNode, nodeName);
        this.elements = elements;
    }

    public TemplateSequenceModel getChildNodes() throws TemplateModelException {
        return new TemplateSequenceModel(){

            public TemplateModel get(int index) throws TemplateModelException {
                TemplateModel element = JSONArrayNode.this.get(index);
                return element != null ? element : new JSONNullNode(JSONArrayNode.this, null);
            }

            public int size() throws TemplateModelException {
                return JSONArrayNode.this.size();
            }
        };
    }

    public String getNodeType() throws TemplateModelException {
        return NODE_TYPE;
    }

    public TemplateModel get(int idx) throws TemplateModelException {
        JSONNode r;
        int size = this.elements.size();
        if (idx < 0 || idx >= size) {
            throw new TemplateModelException("JSON array index out of bounds: " + idx + " is outside 0.." + (size - 1));
        }
        JSONNode[] wrappedChildren = this.wrappedElements;
        if (wrappedChildren == null) {
            this.wrappedElements = wrappedChildren = new JSONNode[size];
        }
        if ((r = wrappedChildren[idx]) == null) {
            r = JSONArrayNode.wrap(this.elements.get(idx), this, null, false);
            if (r == null) {
                r = JSON_NULL_MARK;
            }
            wrappedChildren[idx] = r;
        }
        return r != JSON_NULL_MARK ? r : null;
    }

    public int size() throws TemplateModelException {
        return this.elements.size();
    }

    @Override
    protected String getDefaultNodeName() {
        return DEFAULT_NODE_NAME;
    }

    public List<Object> getAdaptedObject(Class<?> hint) {
        return this.elements;
    }
}

