/*
 * Decompiled with CFR 0.152.
 */
package fmpp.models;

import fmpp.util.StringUtil;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateNumberModel;
import freemarker.template.TemplateScalarModel;

public class TemplateModelUtils {
    protected String strParam(Object m, String name) throws TemplateModelException {
        if (!(m instanceof TemplateScalarModel)) {
            throw new TemplateModelException("Parameter " + StringUtil.jQuote(name) + " must be string.");
        }
        return ((TemplateScalarModel)m).getAsString();
    }

    protected int intParam(Object m, String name) throws TemplateModelException {
        if (!(m instanceof TemplateNumberModel)) {
            throw new TemplateModelException("Parameter " + StringUtil.jQuote(name) + " must be an integer number.");
        }
        Number n = ((TemplateNumberModel)m).getAsNumber();
        int i = n.intValue();
        if (n.doubleValue() != (double)i) {
            throw new TemplateModelException("Parameter " + StringUtil.jQuote(name) + " must be an integer.");
        }
        return n.intValue();
    }

    protected boolean boolParam(Object m, String name) throws TemplateModelException {
        if (!(m instanceof TemplateBooleanModel)) {
            throw new TemplateModelException("Parameter " + StringUtil.jQuote(name) + " must be boolean.");
        }
        return ((TemplateBooleanModel)m).getAsBoolean();
    }

    protected void dieWithMissingParam(String pname) throws TemplateModelException {
        throw this.newMissingParamException(pname);
    }

    protected TemplateModelException newMissingParamException(String pname) {
        return new TemplateModelException("Required parameter with this name is missing: " + pname);
    }

    protected void dieWithUnknownParam(String pname) throws TemplateModelException {
        throw this.newUnsupportedParamException(pname);
    }

    protected TemplateModelException newUnsupportedParamException(String pname) {
        return new TemplateModelException("Unsupported parameter: " + pname);
    }

    protected void dieWithParamsNotAllowed() throws TemplateModelException {
        throw this.newNoParamsAllowedException();
    }

    protected TemplateModelException newNoParamsAllowedException() throws TemplateModelException {
        return new TemplateModelException("This directive doesn't allow any parameters");
    }
}

