/*
 * Decompiled with CFR 0.152.
 */
package fmpp.progresslisteners;

import fmpp.Engine;
import fmpp.ProgressListener;
import java.io.File;

public class StatisticsProgressListener
implements ProgressListener {
    private int failed;
    private int executed;
    private int copied;
    private int rendered;
    private int warnings;
    private long endTime;
    private long beginTime;

    public void notifyProgressEvent(Engine engine, int event, File src, int pMode, Throwable error, Object param) {
        switch (event) {
            case 1: {
                this.beginTime = System.currentTimeMillis();
                break;
            }
            case 4: {
                this.endTime = System.currentTimeMillis();
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                if (error == null) {
                    if (pMode == 2) {
                        ++this.copied;
                        break;
                    }
                    if (pMode == 1) {
                        ++this.executed;
                        break;
                    }
                    if (pMode != 4) break;
                    ++this.rendered;
                    break;
                }
                ++this.failed;
                break;
            }
            case 6: {
                ++this.warnings;
            }
        }
    }

    public synchronized void reset() {
        this.failed = 0;
        this.executed = 0;
        this.rendered = 0;
        this.copied = 0;
        this.warnings = 0;
        this.beginTime = -1L;
        this.endTime = -1L;
    }

    public synchronized long getProcessingTime() {
        if (this.beginTime == -1L || this.endTime == -1L) {
            return -1L;
        }
        return this.endTime - this.beginTime;
    }

    public synchronized int getCopied() {
        return this.copied;
    }

    public synchronized int getExecuted() {
        return this.executed;
    }

    public synchronized int getXmlRendered() {
        return this.rendered;
    }

    public synchronized int getFailed() {
        return this.failed;
    }

    public synchronized int getSuccesful() {
        return this.executed + this.copied + this.rendered;
    }

    public synchronized int getAccessed() {
        return this.executed + this.copied + this.rendered + this.failed;
    }

    public synchronized int getWarnings() {
        return this.warnings;
    }
}

