/*
 * Decompiled with CFR 0.152.
 */
package fmpp.tools;

import fmpp.Engine;
import fmpp.ProcessingException;
import fmpp.progresslisteners.ConsoleProgressListener;
import fmpp.progresslisteners.LoggerProgressListener;
import fmpp.progresslisteners.StatisticsProgressListener;
import fmpp.progresslisteners.TerseConsoleProgressListener;
import fmpp.setting.FileWithSettingValue;
import fmpp.setting.SettingException;
import fmpp.setting.Settings;
import fmpp.util.ArgsParser;
import fmpp.util.FileUtil;
import fmpp.util.MiscUtil;
import fmpp.util.NullOutputStream;
import fmpp.util.RuntimeExceptionCC;
import fmpp.util.StringUtil;
import freemarker.log.Logger;
import freemarker.template.Configuration;
import freemarker.template.Version;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public class CommandLine {
    public static final String FMPP_CONSOLE_COLS = "FMPP_CONSOLE_COLS";
    private static final int DEFAULT_CONSOLE_COLS = 80;
    private static final String OPTION_CONFIGURATION = "configuration";
    private static final String OPTION_PRINT_LOCALES = "print-locales";
    private static final String OPTION_VERSION = "version";
    private static final String OPTION_HELP = "help";
    private static final String OPTION_LONG_HELP = "long-help";
    private static final String RC_FILE_NAME = ".fmpprc";
    private static final int EF_NORMAL = 0;
    private static final int EF_TERSE = 1;
    private static final int EF_QUIET = 2;
    private boolean quiet;
    private boolean printStackTrace;
    private PrintWriter stdout;
    private PrintWriter stderr;
    private PrintWriter tOut;
    private PrintWriter eOut;
    private Integer screenCols;
    private boolean loggingStarted = false;
    private LoggerProgressListener logListener;

    public static void main(String[] args) {
        int exitCode = CommandLine.execute(args, null, null);
        if (exitCode != 0) {
            System.exit(exitCode);
        }
    }

    public static int execute(String[] args, PrintWriter stdout, PrintWriter stderr) {
        CommandLine tool = new CommandLine();
        tool.stdout = stdout == null ? new PrintWriter(System.out, true) : stdout;
        tool.stderr = stderr == null ? new PrintWriter(System.err, true) : stderr;
        tool.eOut = tool.tOut = tool.stdout;
        tool.screenCols = CommandLine.getScreenColsFromEnvVar();
        return tool.run(args);
    }

    private static Integer getScreenColsFromEnvVar() {
        String colsStr = System.getenv(FMPP_CONSOLE_COLS);
        if (colsStr == null) {
            return null;
        }
        colsStr = StringUtil.normalizeLinebreaks(colsStr);
        colsStr = StringUtil.replace(colsStr, "[BR]", "\n");
        if ((colsStr = colsStr.trim()).startsWith("CON:")) {
            String[] rows = StringUtil.split(colsStr, '\n');
            int cols = 0;
            boolean colsFoundByName = false;
            int rowsWithNumValue = 0;
            for (int i = 0; i < rows.length; ++i) {
                Integer rowValue;
                String row = rows[i];
                int colonIdx = row.indexOf(58);
                if (colonIdx <= 0) continue;
                String rowValueStr = row.substring(colonIdx + 1).trim();
                try {
                    rowValue = Integer.valueOf(rowValueStr);
                }
                catch (NumberFormatException e) {
                    rowValue = null;
                }
                if (rowValue == null) continue;
                ++rowsWithNumValue;
                String rowLabel = row.substring(0, colonIdx).trim().toLowerCase();
                if ("columns".equals(rowLabel) || "cols".equals(rowLabel) || "spalten".equals(rowLabel) || "colonnes".equals(rowLabel) || "columnas".equals(rowLabel) || "\uf99c".equals(rowLabel)) {
                    cols = rowValue;
                    colsFoundByName = true;
                    break;
                }
                if (rowsWithNumValue != 2) continue;
                cols = rowValue;
            }
            if (colsFoundByName || rowsWithNumValue >= 4 && cols >= 20 && cols < 800) {
                return new Integer(cols);
            }
            return null;
        }
        try {
            return Integer.valueOf(colsStr);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int run(String[] args) {
        int exitCode = 0;
        try {
            Logger.selectLoggerLibrary((int)0);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeExceptionCC("Failed to disable FreeMarker logging", e);
        }
        File rcFile = null;
        String s = System.getProperty("user.home");
        if (s != null && !(rcFile = new File(s, RC_FILE_NAME)).isFile()) {
            rcFile = null;
        }
        if (rcFile == null && (s = System.getProperty("fmpp.userHome")) != null && !(rcFile = new File(s, RC_FILE_NAME)).isFile()) {
            rcFile = null;
        }
        if (rcFile == null && (s = System.getProperty("fmpp.home")) != null && !s.startsWith("%") && !(rcFile = new File(s, RC_FILE_NAME)).isFile()) {
            rcFile = null;
        }
        int impliedEchoFormat = 0;
        boolean impliedPrintStackTrace = false;
        boolean impliedAppendLogFile = false;
        int impliedQuiet = 0;
        if (rcFile != null) {
            try {
                Settings fmpprc = new Settings(new File("."));
                fmpprc.load(rcFile);
                Iterator it = fmpprc.getNames();
                while (it.hasNext()) {
                    String value;
                    String key = (String)it.next();
                    if (key.equals("echoFormat")) {
                        value = (String)fmpprc.get(key);
                        impliedEchoFormat = CommandLine.echoFormatOpToInt(value, false, key);
                        continue;
                    }
                    if (key.equals("printStackTrace")) {
                        impliedPrintStackTrace = (Boolean)fmpprc.get(key);
                        continue;
                    }
                    if (key.equals("snip")) {
                        impliedPrintStackTrace = (Boolean)fmpprc.get(key) == false;
                        continue;
                    }
                    if (key.equals("appendLogFile")) {
                        impliedAppendLogFile = (Boolean)fmpprc.get(key);
                        continue;
                    }
                    if (key.equals("columns")) {
                        this.screenCols = (Integer)fmpprc.get(key);
                        continue;
                    }
                    if (key.equals("quiet")) {
                        value = (String)fmpprc.get(key);
                        impliedQuiet = Settings.quietSettingValueToInt(value, key);
                        continue;
                    }
                    throw new SettingException("Setting \"" + key + "\" is not allowed in .fmpprc. In general, not setting that could influence the output files can be set here.");
                }
            }
            catch (SettingException e) {
                this.p("Error loading .fmpprc.");
                this.p(MiscUtil.causeMessages(e));
                return -1;
            }
        }
        File defaultCfg = Settings.getDefaultConfigurationFile(new File("."));
        if (args.length == 0 && defaultCfg == null) {
            this.printHelp(null);
            return -1;
        }
        try {
            File cfgToLoad;
            Properties ops;
            ArgsParser ap = new ArgsParser();
            ap.addOption("S DIR", this.cln("sourceRoot")).desc("Sets the root directory of source files. In bulk-mode it defaults to the current working directory.");
            ap.addOption("O DIR", this.cln("outputRoot")).desc("Sets the root directory of output files.");
            ap.addOption("o FILE", this.cln("outputFile")).desc("The output file. This switches FMPP to single-file mode.");
            ap.addOption(null, this.cln("freemarkerLinks") + "=MAP").desc("The map of FreeMarker links (external includes).");
            ap.addOption("U WHAT", this.cln("skipUnchanged")).desc("Skip <WHAT> files if the source was not modified after the output file was last modified. <WHAT> can be \"all\", \"none\" or \"static\"");
            ap.addOption(null, this.cln("dataRoot") + "=DIR").desc("Sets the root directory of data files. The reserved value \"source\" means that the data root is the same as the source root. The default value is \"source\".");
            ap.addOption("C FILE", OPTION_CONFIGURATION).desc("Load settings from a configuration file. Settings given with command-line options have higher priority (note that some settings are merged, rather than overridden). Be default fmpp will use ./config.fmpp or ./fmpp.cfg if that exists. Use value \"none\" (-C none) to prevent this.");
            ap.addOption(null, this.cln("inheritConfiguration") + " FILE").desc("Inherits options from a configuration file. The options in the primary configuration file (-C) has higher precedence.");
            ap.addOption(null, this.cln("outputFormat") + "=NAME").desc("Sets the output format (auto-escaping) of templates, like \"HTML\", \"XML\", \"RTF\", etc. By default \"unspecified\". The --" + this.cln("outputFormatsByPath") + " and --" + this.cln("mapCommonExtensionsToOutputFormats") + " option overrides this for matching paths.");
            ap.addOption(null, this.cln("mapCommonExtensionsToOutputFormats")).propertyValue("true").desc("Should templates with common file extensions (\"html\", \"htm\", \"xml\", etc.) be mapped to an output format (auto-escaping). Has lower priority than --" + this.cln("outputFormatsByPath") + ". Enabled by default if --" + this.cln("recommendedDefaults") + " is at least 0.9.16.");
            ap.addOption(null, "dont-" + this.cln("mapCommonExtensionsToOutputFormats")).property("mapCommonExtensionsToOutputFormats", "false").desc("Opposite of --" + this.cln("mapCommonExtensionsToOutputFormats") + ".");
            ap.addOption(null, this.cln("outputFormatsByPath") + "=SEQ").desc("List of case(...)-s that choose the template output format (auto-escaping), e.g.:\n--output-formats=\"case(**/*.xsl, **/*.wsdl, XML), case(**/*.htm*, HTML)\"\nBy default empty.");
            ap.addOption("M SEQ", this.cln("modes")).desc("The list of TDD function calls that choose the file processing mode, e.g.:\n-M \"ignore(**/tmp/), execute(**/*.htm, **/*.html), copy(**/*)\"");
            ap.addOption(null, this.cln("turns") + "=SEQ").desc("The list of turn(...)-s that choose the turns of processings, e.g.:\n--turns \"turn(2, **/*_t2.*, ), turn(3, **/*_t3.*, **/*.toc)\"\nBy default all files will be procesed in the first turn.");
            ap.addOption(null, this.cln("borders") + "=SEQ").desc("The list of TDD function calls that choose header and footer for templates, e.g.:\n-M 'border(\"<#import \"/lib/utils.ftlh\" as u><@u.myLayout>\", \"</@u.myLayout>\", *.htm, *.html), header(\"<#include \\\"/css.ftl\\\">\", *.css)'");
            ap.addOption("D TDD", this.cln("data")).desc("Creates shared data that all templates will see. <TDD> is the Textual Data Definition, e.g.:\n-D \"properties(style.properties), onLine:true\"\nNote that paths like \"style.properties\" are relative to the data root directory.");
            ap.addOption(null, this.cln("recommendedDefaults") + "=VER").desc("Use the setting value defaults recommended as of FMPP version <VER>. When you start a new project, set this to the current FMPP version (" + Engine.getVersion() + "). In older projects changing this setting can break things (check documentation). The default is 0.9.15, because this setting was added in 0.9.16.");
            Version maxFMVer = Configuration.getVersion();
            ap.addOption(null, this.cln("freemarkerIncompatibleImprovements") + "=VER").desc("Enables the FreeMarker fixes/improvements that aren't 100% backward compatible, and were implemented in FreeMarker version <VER>. In older projects using the highest available 2.3.x is usually a good compromise, but check FreeMarker documentation. New projects should use the maximum (in this installation \"" + maxFMVer.getMajor() + "." + maxFMVer.getMinor() + "." + maxFMVer.getMicro() + "\". The default depends on the " + this.cln("recommendedDefaults") + " setting; usually you just set that, and not directly this setting.");
            ap.addOption(null, this.cln("objectWrapper") + "=BSH").desc("Specifies the ObjectWrapper to use with a BeanShell expression that must evaluate to an object that extends BeansWrapper. The default value is a BeansWrapper instance with simpleMapWrapper set to true.");
            ap.addOption(null, this.cln("localData") + "=SEQ").desc("Creates data that is visible only for certain templates. This is a list of case(...) and layer() function calls.");
            ap.addOption(null, this.cln("templateData") + "=CLASS").desc("Creates Java object that builds data for individual templates.").hide();
            ap.addOption("s", this.cln("stopOnError")).propertyValue("true").implied().desc("Terminate fmpp on failed file processing. This is the default behaviour. Use -c to override this.");
            ap.addOption("c", "continue-on-error").property(this.cln("stopOnError"), "false").implied().desc("Skip to the next file on failed file processing (and log the error: see -L)");
            ap.addOption("E ENC", this.cln("sourceEncoding")).desc("The encoding of textual sources (templates). Use the special value \"host\" (-E host) if the default encoding of the host machine should be used. The default is \"ISO-8859-1\".");
            ap.addOption(null, this.cln("outputEncoding") + "=ENC").desc("The encoding of template output. Use the special value \"source\" if the encoding of the template file should be used. Use the special value \"host\" if the default encoding of the host machine should be used. The default is \"source\".");
            ap.addOption(null, this.cln("urlEscapingCharset") + "=ENC").desc("The charset used for URL escaping. Use the special value \"output\" if the encoding of the output file should be used. The default is \"output\".");
            ap.addOption("A LOC", this.cln("locale")).desc("The locale (as ar_SA). Use the special value \"host\" (-A host) if the default locale of the host machine should be used. The default value of the option is en_US.");
            ap.addOption(null, this.cln("numberFormat") + "=FORMAT").desc("The number format used to show numerical values. The default is 0.############");
            ap.addOption(null, this.cln("booleanFormat") + "=FORMAT").desc("The boolean format used to show boolean values, like \"Yes,No\". Not \"true,false\"; use ${myBool?c} for that. The default is error on ${myBool}.");
            ap.addOption(null, this.cln("dateFormat") + "=FORMAT").desc("The format used to show date (year+month+day) values. The default is locale dependent.");
            ap.addOption(null, this.cln("timeFormat") + "=FORMAT").desc("The format used to show time values. The default is locale dependent.");
            ap.addOption(null, this.cln("datetimeFormat") + "=FORMAT").desc("The format used to show date-time values. The default is locale dependent.");
            ap.addOption(null, this.cln("timeZone") + "=ZONE").desc("Sets the time zone in which date/time/date-time values are shown. The default is the time zone of the host machine. Example: GMT+02");
            ap.addOption(null, this.cln("sqlDateAndTimeTimeZone") + "=ZONE").desc("Sets a different time zone for java.sql.Date and java.sql.Time only.");
            ap.addOption(null, this.cln("tagSyntax") + "=WHAT").desc("Sets the tag syntax of the templates that doesn't start with the ftl directive. Possible values are: angleBracket (like <#ftl>), squareBracket (like [#ftl]), autoDetect. The default is angleBracket. The recommended value is autoDetect.");
            ap.addOption(null, this.cln("interpolationSyntax") + "=WHAT").desc("Sets the interpolation syntax of the templates. Possible values are: legacy (like ${exp} or #{exp}), dollar (${exp} only), squareBracket (like [=exp]). The default is legacy.");
            ap.addOption(null, this.cln("caseSensitive")).propertyValue("true").desc("Upper- and lower-case letters are considered as different characters when comparing or matching paths.");
            ap.addOption(null, "ignore-case").property(this.cln("caseSensitive"), "false").implied().desc("Upper- and lower-case letters are considered as the same characters when comparing or matching paths. This is the default.");
            ap.addOption(null, this.cln("alwaysCreateDirectories")).propertyValue("true").desc("Create output subdirectory even if it will remain empty. Defaults to false.");
            ap.addOption(null, this.cln("ignoreCvsFiles")).implied().desc("Ignore CVS files in the source root directory. This is the default.");
            ap.addOption(null, "dont-" + this.cln("ignoreCvsFiles")).property(this.cln("ignoreCvsFiles"), "false").desc("Don't ignore CVS files in the source root directory.");
            ap.addOption(null, this.cln("ignoreSvnFiles")).implied().desc("Ignore SVN files in the source root directory. This is the default.");
            ap.addOption(null, "dont-" + this.cln("ignoreSvnFiles")).property(this.cln("ignoreSvnFiles"), "false").desc("Don't ignore SVN files in the source root directory.");
            ap.addOption(null, this.cln("ignoreTemporaryFiles")).implied().desc("Ignore well-known temporary files (e.g. **/?*~) in the source root directory. This is the default.");
            ap.addOption(null, "dont-" + this.cln("ignoreTemporaryFiles")).property(this.cln("ignoreTemporaryFiles"), "false").desc("Don't ignore well-known temporary files in the source root directory.");
            ap.addOption("R SEQ", this.cln("removeExtensions")).desc("These extensions will be removed from the output file name. <SEQ> contains the extensions without the dot.");
            ap.addOption(null, this.cln("removeExtension") + "=L").hide();
            ap.addOption(null, this.cln("replaceExtensions") + "=SEQ").desc("Replaces the extensions with another exensions. The list contains the old and new extensions alternately; old1, new1, old2, new2, etc. The extensions in the <SEQ> do not contain the dot.");
            ap.addOption(null, this.cln("replaceExtension") + "=L").hide();
            ap.addOption(null, this.cln("removePostfixes") + "=SEQ").desc("If the source file name without the extension ends with a string in the <SEQ>, then that string will be removed from the output file name.");
            ap.addOption(null, this.cln("removePostfix") + "=L").hide();
            ap.addOption(null, this.cln("removeFreemarkerExtensions")).propertyValue("true").desc("Remove \"ftl\", \"ftlh\", and \"ftlx\" file extensions from the output file name. (This is applied last among the settings that tranform the output file name.) Enabled by default if --" + this.cln("recommendedDefaults") + " is at least 0.9.16.");
            ap.addOption(null, "dont-" + this.cln("removeFreemarkerExtensions")).property("removeFreemarkerExtensions", "false").desc("Opposite of --" + this.cln("removeFreemarkerExtensions") + ".");
            ap.addOption("L FILE", this.cln("logFile")).implied("none").desc("Sets the log file. Use \"none\" (-L none) to disable logging. The default is \"none\".");
            ArgsParser.OptionDefinition od = ap.addOption(null, this.cln("appendLogFile")).desc("If the log file already exists, it will be continued, instead of restarting it.");
            if (impliedAppendLogFile) {
                CommandLine.setAsDefault(od);
            }
            od = ap.addOption(null, "dont-" + this.cln("appendLogFile")).property(this.cln("appendLogFile"), "false").desc("If the log file already exists, it will be restarted.");
            if (!impliedAppendLogFile) {
                CommandLine.setAsDefault(od);
            }
            ap.addOption(null, this.cln("configurationBase") + "=DIR").desc("The directory used as base to resolve relative paths in the configuration file. It defaults to the directory of the configuration file.");
            ap.addOption("x", this.cln("expert")).propertyValue("true").desc("Expert mode.");
            ap.addOption(null, "not-expert").property(this.cln("expert"), "false").desc("Disables expert mode. This is the default.");
            ap.addOption(null, this.cln("xmlRenderings") + "=SEQ").desc("Sets the sequence of XML renderings. Each item is hash, that stores the options of an XML rendering configuration.");
            ap.addOption(null, this.cln("xpathEngine") + "=NAME").desc("Sets the XPath engine to be used. Legal values are: dontSet, default, jaxen, xalan, and any adapter class name.");
            ap.addOption(null, this.cln("xmlCatalogFiles") + "=SEQ").desc("Sets the catalog files used for XML entity resolution. Catalog based resolution is enabled if and only if this settings is specified.");
            ap.addOption(null, this.cln("xmlCatalogPrefer") + "=WHAT").desc("Sets if catalog file based XML entity resolution prefers public or system identifiers. Valid values are: public, system, globalDefault. Defaults to public.");
            ap.addOption(null, this.cln("validateXml")).desc("Sets that XML files will be validated by default.");
            ap.addOption(null, "dont-" + this.cln("validateXml")).property(this.cln("validateXml"), "false").desc("Sets that XML files will not be validated by default. This is the default.");
            od = ap.addOption("v", "verbose").property(this.cln("quiet"), "false").desc("The opposite of -Q: prints everything to the stdout.");
            if (impliedQuiet == 0) {
                CommandLine.setAsDefault(od);
            }
            od = ap.addOption("q", this.cln("quiet")).property(this.cln("quiet"), "true").desc("Don't write to the stdout, unless the command-line arguments are wrong. Print warning and error messages to the stderr.");
            if (impliedQuiet == 1) {
                CommandLine.setAsDefault(od);
            }
            od = ap.addOption("Q", "really-quiet").property(this.cln("quiet"), "reallyQuiet").desc("As -q, but doesn't even write to the stderr.");
            if (impliedQuiet == 2) {
                CommandLine.setAsDefault(od);
            }
            ap.addOption("F FORMAT", this.cln("echoFormat")).implied(CommandLine.echoFormatToString(impliedEchoFormat)).desc("The format used for displaying the progress. <FORMAT> is n[ormal], t[erse] or q[uiet] (or v[erbose], which is the same as normal). The default is " + CommandLine.echoFormatToString(impliedEchoFormat) + ".");
            ap.addOption(null, this.cln("columns") + "=COLS").desc("The number of columns on the console screen. Use when auto-detection gives bad result.");
            od = ap.addOption(null, this.cln("printStackTrace")).property(this.cln("printStackTrace"), "true").desc("Print stack trace on error.");
            if (impliedPrintStackTrace) {
                CommandLine.setAsDefault(od);
            }
            od = ap.addOption(null, "dont-" + this.cln("printStackTrace")).property(this.cln("printStackTrace"), "false").desc("Don't print stack trace on error, just cause chain.");
            if (!impliedPrintStackTrace) {
                CommandLine.setAsDefault(od);
            }
            od = ap.addOption(null, this.cln("snip")).property(this.cln("printStackTrace"), "false").desc("Deprecated; alias of dont-printStackTrace.");
            od = ap.addOption(null, "dont-" + this.cln("snip")).property(this.cln("printStackTrace"), "true").desc("Deprecated; alias of printStackTrace.");
            ap.addOption(null, OPTION_PRINT_LOCALES).desc("Prints the locale codes that Java platform knows.");
            ap.addOption(null, OPTION_VERSION).desc("Prints version information.");
            ap.addOption("h", OPTION_HELP).desc("Prints help on options.");
            ap.addOption(null, OPTION_LONG_HELP).desc("Deprecated; same as -h");
            Properties impliedOps = new Properties();
            ap.setDefaultProperties(impliedOps);
            try {
                ops = ap.parse(args);
                args = ap.getNonOptions();
            }
            catch (ArgsParser.BadArgsException e) {
                throw new SettingException("Bad command-line: " + MiscUtil.causeMessages(e));
            }
            Settings.fixVersion08SettingNames(ops);
            int i = Settings.quietSettingValueToInt(ops.getProperty(this.cln("quiet")), this.cln("quiet"));
            if (i > 0) {
                this.quiet = true;
                this.tOut.flush();
                this.tOut = new PrintWriter(NullOutputStream.INSTANCE);
                this.eOut = i == 1 ? this.stderr : this.tOut;
            } else {
                this.quiet = false;
            }
            int screenColsOr0 = CommandLine.opToInt(ops.getProperty(this.cln("columns")), this.cln("columns"));
            if (screenColsOr0 != 0) {
                this.screenCols = new Integer(screenColsOr0);
            }
            if (ops.containsKey(OPTION_HELP) || ops.containsKey(OPTION_LONG_HELP)) {
                this.printHelp(ap);
                throw FinishedException.INSTANCE;
            }
            if (ops.containsKey(OPTION_VERSION)) {
                this.p("FMPP version " + Engine.getVersion() + ", build " + Engine.getBuildInfo());
                this.p("Currently using FreeMarker version " + Engine.getFreeMarkerVersion());
                this.p("For the latest version visit: http://fmpp.sourceforge.net/");
                throw FinishedException.INSTANCE;
            }
            if (ops.containsKey(OPTION_PRINT_LOCALES)) {
                Locale[] locales = Locale.getAvailableLocales();
                Arrays.sort(locales, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        Locale loc1 = (Locale)o1;
                        Locale loc2 = (Locale)o2;
                        int r = ("" + loc1.getLanguage()).compareTo("" + loc2.getLanguage());
                        if (r != 0) {
                            return r;
                        }
                        r = ("" + loc1.getCountry()).compareTo("" + loc2.getCountry());
                        if (r != 0) {
                            return r;
                        }
                        return ("" + loc1.getVariant()).compareTo("" + loc2.getVariant());
                    }
                });
                StringBuffer sb = new StringBuffer();
                for (i = 0; i < locales.length; ++i) {
                    sb.setLength(0);
                    String la = locales[i].getLanguage();
                    String co = locales[i].getCountry();
                    String va = locales[i].getVariant();
                    sb.append(la);
                    if (co.length() != 0) {
                        sb.append("_");
                        sb.append(co);
                        if (va.length() != 0) {
                            sb.append("_");
                            sb.append(va);
                        }
                    }
                    sb.append(" (");
                    sb.append(locales[i].getDisplayLanguage());
                    if (co.length() != 0) {
                        sb.append(", ");
                        sb.append(locales[i].getDisplayCountry());
                        if (va.length() != 0) {
                            sb.append(", ");
                            sb.append(locales[i].getDisplayVariant());
                        }
                    }
                    sb.append(")");
                    this.p(sb.toString(), 0, 3);
                }
                throw FinishedException.INSTANCE;
            }
            Properties savedImpliedOps = new Properties();
            savedImpliedOps.putAll((Map<?, ?>)impliedOps);
            impliedOps.clear();
            String opCfg = ops.getProperty(OPTION_CONFIGURATION);
            ops.remove(OPTION_CONFIGURATION);
            Settings settings = new Settings(new File("."));
            settings.undashNames(ops);
            settings.addWithStrings(ops);
            ops = null;
            if (opCfg != null) {
                cfgToLoad = !opCfg.equals("none") ? new File(opCfg) : null;
            } else if (defaultCfg != null) {
                cfgToLoad = defaultCfg;
                this.p("Note: Using the " + cfgToLoad.getName() + " in the working directory.");
            } else {
                cfgToLoad = null;
            }
            if (cfgToLoad != null) {
                settings.loadDefaults(cfgToLoad);
            }
            settings.undashNames(savedImpliedOps);
            settings.addDefaultsWithStrings(savedImpliedOps);
            savedImpliedOps = null;
            i = Settings.quietSettingValueToInt((String)settings.get("quiet"), "quiet");
            if (i > 0) {
                this.quiet = true;
                this.tOut.flush();
                this.tOut = new PrintWriter(NullOutputStream.INSTANCE);
                this.eOut = i == 1 ? this.stderr : this.tOut;
            } else {
                this.quiet = false;
            }
            Integer colsOrNull = (Integer)settings.get("columns");
            if (colsOrNull != null) {
                this.screenCols = colsOrNull;
            }
            boolean singleFileMode = settings.get("outputFile") != null;
            FileWithSettingValue logFile = (FileWithSettingValue)settings.get("logFile");
            if (!logFile.getSettingValue().equals("none")) {
                this.startLogging(logFile, (Boolean)settings.get("appendLogFile"));
            }
            if (this.logListener != null) {
                settings.addProgressListener(this.logListener);
            }
            if (args.length != 0) {
                settings.add("sources", args);
            }
            int ef = CommandLine.echoFormatOpToInt((String)settings.get("echoFormat"), true, "echoFormat");
            if (!singleFileMode && !this.quiet) {
                if (ef == 0) {
                    settings.addProgressListener(new ConsoleProgressListener(this.tOut));
                } else if (ef == 1) {
                    settings.addProgressListener(new TerseConsoleProgressListener(this.tOut));
                } else if (ef == 2) {
                    settings.addProgressListener(new ConsoleProgressListener(this.tOut, true));
                }
            } else {
                settings.addProgressListener(new ConsoleProgressListener(this.eOut, true));
            }
            this.printStackTrace = (Boolean)settings.get("printStackTrace");
            StatisticsProgressListener stats = new StatisticsProgressListener();
            settings.addProgressListener(stats);
            if (!singleFileMode) {
                settings.addDefault("sourceRoot", ".");
            }
            Throwable abortingExc = null;
            try {
                settings.execute();
            }
            catch (ProcessingException e) {
                abortingExc = e;
            }
            if (!singleFileMode) {
                this.p();
            }
            if (abortingExc != null) {
                this.pe(">>> ABORTED! <<<");
            } else if (stats.getFailed() == 0) {
                this.p("*** DONE ***");
            } else {
                this.p(">>> DONE WITH ERRORS <<<");
            }
            if (!singleFileMode) {
                this.p();
                this.p(stats.getExecuted() + " executed + " + stats.getXmlRendered() + " rendered + " + stats.getCopied() + " copied = " + stats.getSuccesful() + " successfully processed\n" + stats.getFailed() + " failed, " + stats.getWarnings() + " warning(s) ");
                this.p("Time elapsed: " + (double)stats.getProcessingTime() / 1000.0 + " seconds");
            }
            if (abortingExc != null) {
                this.pe("");
                this.pe("The cause of aborting was: ");
                if (abortingExc instanceof ProcessingException) {
                    ProcessingException procExc = abortingExc;
                    if (!singleFileMode && procExc.getSourceFile() != null) {
                        this.pe("Error when processing this file: " + FileUtil.getRelativePath(procExc.getSourceRoot(), procExc.getSourceFile()));
                    }
                    abortingExc = procExc.getCause();
                }
                if (this.printStackTrace) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    abortingExc.printStackTrace(pw);
                    pw.flush();
                    this.pe(sw.toString());
                } else {
                    this.pe(MiscUtil.causeMessages(abortingExc));
                }
                exitCode = -2;
            }
        }
        catch (IOException e) {
            this.pe("I/O error:");
            this.pe(e);
            this.pl(">>> TERMINATED WITH I/O ERROR <<<");
            this.pl(MiscUtil.causeMessages(e));
            if (this.logListener != null) {
                this.logListener.printStackTrace(e);
            }
            exitCode = -2;
        }
        catch (SettingException e) {
            this.pe("Failed!");
            this.pe(MiscUtil.causeMessages(e));
            this.pl(">>> TERMINATED WITH SETTING ERROR <<<");
            this.pl(MiscUtil.causeMessages(e));
            if (this.logListener != null) {
                this.logListener.printStackTrace(e);
            }
            exitCode = -1;
        }
        catch (FinishedException e) {
            exitCode = 0;
        }
        catch (Throwable e) {
            this.pl("INTERNAL ERROR:");
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            pw.close();
            this.pTrace(sw.toString());
            this.pl(">>> TERMINATED WITH INTERNAL ERROR <<<");
            if (this.logListener != null) {
                this.logListener.printStackTrace(e);
            }
            exitCode = -2;
        }
        finally {
            this.tOut.println();
            this.tOut.flush();
            this.eOut.flush();
            if (this.logListener != null) {
                this.logListener.close();
            }
        }
        return exitCode;
    }

    private void printHelp(ArgsParser ap) {
        this.p("Typical usages:");
        this.p("fmpp -C configfile", 3);
        this.p("fmpp -S sourcedir -O outputdir", 3);
        this.p("fmpp sourcefile -o outputfile", 3);
        this.p("For more examples: http://fmpp.sourceforge.net/commandline.html");
        if (ap == null) {
            this.p("To see all options: fmpp -h");
        } else {
            this.p();
            this.p("Options:");
            this.tOut.println(ap.getOptionsHelp(this.getScreenColumnsOrDefault()));
            this.p();
            this.p("Most options above directly correspond to FMPP settings. See their full descriptions here: http://fmpp.sourceforge.net/settings.html");
        }
        this.p();
        this.tOut.flush();
    }

    private int getScreenColumnsOrDefault() {
        return this.screenCols != null ? this.screenCols : 80;
    }

    private void p() {
        this.tOut.println();
    }

    private void p(String text) {
        this.p(text, 0);
    }

    private void p(String text, int indent) {
        this.p(text, indent, indent);
    }

    private void p(String text, int firstIndent, int furtherIndent) {
        if (this.screenCols == null && (furtherIndent == firstIndent || furtherIndent == 0)) {
            this.tOut.println(StringUtil.repeat(" ", firstIndent) + text);
        } else {
            this.tOut.println(StringUtil.wrap(text, this.getScreenColumnsOrDefault(), firstIndent, furtherIndent));
        }
    }

    private void pe(Object obj) {
        this.pe(obj.toString());
    }

    private void pe(String text) {
        this.pe(text, 0);
    }

    private void pTrace(String text) {
        this.tOut.println(StringUtil.wrapTrace(text, this.getScreenColumnsOrDefault()));
    }

    private void pe(String text, int indent) {
        if (this.screenCols == null) {
            this.eOut.println(StringUtil.repeat(" ", indent) + text);
        } else {
            this.eOut.println(StringUtil.wrap(text, (int)this.screenCols, indent));
        }
    }

    private void pl(Object obj) {
        if (this.logListener == null) {
            return;
        }
        this.logListener.println(obj);
    }

    private void startLogging(File logFile, boolean append) throws SettingException {
        if (this.loggingStarted) {
            return;
        }
        try {
            this.logListener = new LoggerProgressListener(logFile, append);
        }
        catch (IOException e) {
            throw new SettingException("Failed to create log file.", e);
        }
        this.loggingStarted = true;
    }

    private static void setAsDefault(ArgsParser.OptionDefinition od) {
        od.implied();
        od.desc(od.getDescription() + " This is the default.");
    }

    private static int echoFormatOpToInt(String s, boolean ignoreError, String name) throws SettingException {
        if ((s = s.toLowerCase()).equals("n") || s.equals("normal") || s.equals("verbose") || s.equals("v")) {
            return 0;
        }
        if (s.equals("t") || s.equals("terse")) {
            return 1;
        }
        if (s.equals("q") || s.equals("quiet")) {
            return 2;
        }
        if (ignoreError) {
            return 0;
        }
        throw new SettingException("Invalid value " + StringUtil.jQuote(s) + " for setting " + StringUtil.jQuote(name) + ".  Valid values are (case insensitive): \"normal\", \"n\", \"terse\", \"t\", \"quiet\", \"q\".");
    }

    private static String echoFormatToString(int ef) {
        if (ef == 0) {
            return "normal";
        }
        if (ef == 1) {
            return "terse";
        }
        if (ef == 2) {
            return "quiet";
        }
        return null;
    }

    private static int opToInt(String value, String name) throws SettingException {
        if (value == null || value.length() == 0) {
            return 0;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new SettingException("The value of setting \"" + name + "\" has to be a valid integer.");
        }
    }

    private String cln(String name) {
        return Settings.getDashedName(name);
    }

    private static class FinishedException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private static final FinishedException INSTANCE = new FinishedException();

        private FinishedException() {
        }
    }
}

