/*
 * Decompiled with CFR 0.152.
 */
package fmpp.util;

import fmpp.util.ExceptionCC;
import fmpp.util.InstallationException;
import fmpp.util.RuntimeExceptionCC;
import fmpp.util.StringUtil;
import freemarker.core.ParseException;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModelException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MiscUtil {
    public static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final BigInteger MAX_INT_AS_BIG_INTEGER = BigInteger.valueOf(Integer.MAX_VALUE);
    private static final BigInteger MIN_INT_AS_BIG_INTEGER = BigInteger.valueOf(Integer.MIN_VALUE);
    private static final String MSG_XML_NOT_AVAIL = "XML support is not available. You need to use Java2 platform 1.4 or later, or you have to install XML support.";

    public static String causeMessages(Throwable e) {
        return MiscUtil.causeTrace_common(e, true);
    }

    public static String causeTrace(Throwable e) {
        return MiscUtil.causeTrace_common(e, false);
    }

    private static String causeTrace_common(Throwable e, boolean hideUninterstingClasses) {
        if (e == null) {
            return "??? (the error was described with a null object)";
        }
        StringBuffer res = new StringBuffer();
        String lastShownMsg = null;
        boolean first = true;
        while (true) {
            String msg;
            if ((msg = e.getMessage()) != null) {
                if (lastShownMsg == null || !msg.equals(lastShownMsg)) {
                    if (!first) {
                        MiscUtil.appendCausedBy(res);
                    }
                    lastShownMsg = msg;
                    String cn = e.getClass().getName();
                    if (!hideUninterstingClasses || !cn.startsWith("fmpp.")) {
                        int prevLen = res.length();
                        MiscUtil.appendClassAndLocation(e, hideUninterstingClasses, res);
                        if (res.length() != prevLen) {
                            res.append(": ");
                        }
                    }
                    res.append(msg);
                }
            } else {
                if (!first) {
                    MiscUtil.appendCausedBy(res);
                }
                MiscUtil.appendClassAndLocation(e, false, res);
            }
            if ((e = MiscUtil.getCauseException(e)) == null) break;
            first = false;
        }
        return res.toString();
    }

    private static void appendCausedBy(StringBuffer res) {
        res.append(StringUtil.LINE_BREAK);
        res.append(StringUtil.LINE_BREAK);
        res.append("Caused by:");
        res.append(StringUtil.LINE_BREAK);
    }

    private static void appendClassAndLocation(Throwable e, boolean hideUninterstingClasses, StringBuffer res) {
        StackTraceElement[] stackTrace = e.getStackTrace();
        if (stackTrace != null && stackTrace.length >= 1) {
            StackTraceElement thrower = stackTrace[0];
            String throwerC = thrower.getClassName();
            if (!hideUninterstingClasses || !MiscUtil.technicalDetailsNeedNotBeShown(throwerC, e)) {
                int line;
                res.append(e.getClass().getName());
                res.append(" (at ");
                res.append(throwerC);
                String m = thrower.getMethodName();
                if (m != null) {
                    res.append('.');
                    res.append(m);
                }
                if ((line = thrower.getLineNumber()) > 0) {
                    res.append(':');
                    res.append(line);
                }
                res.append(")");
            } else if (e instanceof TemplateException) {
                res.append("FreeMarker template error");
            }
        } else {
            res.append(e.getClass().getName());
        }
    }

    private static boolean technicalDetailsNeedNotBeShown(String throwerClassName, Throwable thrownExc) {
        return !(!(thrownExc instanceof ExceptionCC) && !(thrownExc instanceof RuntimeExceptionCC) && !(thrownExc instanceof TemplateException) && !(thrownExc instanceof ParseException) && !(thrownExc instanceof TemplateModelException) || !throwerClassName.startsWith("freemarker.") && !throwerClassName.startsWith("fmpp."));
    }

    public static Class classForName(String className) throws ClassNotFoundException {
        try {
            return Class.forName(className, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return Class.forName(className);
    }

    public static Map dictionaryToMap(Dictionary dict) {
        HashMap m = new HashMap(dict.size());
        Enumeration en = dict.keys();
        while (en.hasMoreElements()) {
            Object key = en.nextElement();
            m.put(key, dict.get(key));
        }
        return m;
    }

    public static Throwable getCauseException(Throwable e) {
        Method m2;
        Throwable cause = e.getCause();
        if (cause != null) {
            return cause;
        }
        try {
            m2 = e.getClass().getMethod("getTarget", EMPTY_CLASS_ARRAY);
            Throwable targetE = (Throwable)m2.invoke((Object)e, EMPTY_OBJECT_ARRAY);
            if (targetE != null) {
                return targetE;
            }
        }
        catch (Throwable m2) {
            // empty catch block
        }
        try {
            m2 = e.getClass().getMethod("getRootCause", EMPTY_CLASS_ARRAY);
            Throwable rootCauseE = (Throwable)m2.invoke((Object)e, EMPTY_OBJECT_ARRAY);
            if (rootCauseE != null) {
                return rootCauseE;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static boolean listContainsObject(List<?> list, Object o) {
        for (Object it : list) {
            if (it != o) continue;
            return true;
        }
        return false;
    }

    public static boolean mapContainsObject(Map<?, ?> map, Object o) {
        for (Object it : map.values()) {
            if (it != o) continue;
            return true;
        }
        return false;
    }

    public static int findObject(List list, Object o) {
        int i = 0;
        for (Object it : list) {
            if (it == o) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static void checkXmlSupportAvailability(String requiredForThis) throws InstallationException {
        Exception error = null;
        try {
            MiscUtil.classForName("javax.xml.parsers.DocumentBuilderFactory");
            MiscUtil.classForName("org.w3c.dom.Element");
            MiscUtil.classForName("org.xml.sax.XMLReader");
        }
        catch (ClassNotFoundException e) {
            error = e;
        }
        catch (SecurityException e) {
            error = e;
        }
        if (error != null) {
            if (requiredForThis != null) {
                throw new InstallationException("XML support is not available. You need to use Java2 platform 1.4 or later, or you have to install XML support. Note that XML support was required for this: " + requiredForThis, error);
            }
            throw new InstallationException(MSG_XML_NOT_AVAIL, error);
        }
    }

    public static int numberToInt(Number value) {
        if (value instanceof Integer || value instanceof Short || value instanceof Byte) {
            return value.intValue();
        }
        if (value instanceof Long) {
            long lv = (Long)value;
            if (lv >= Integer.MIN_VALUE && lv <= Integer.MAX_VALUE) {
                return (int)lv;
            }
            throw new IllegalArgumentException("Can't convert this long value to int, because it's out of range: " + lv);
        }
        if (value instanceof Double) {
            double dv = (Double)value;
            int iv = (int)dv;
            if (dv == (double)((int)dv)) {
                return iv;
            }
            throw new IllegalArgumentException("Can't convert this double value to int without loss: " + dv);
        }
        if (value instanceof Float) {
            float fv = ((Float)value).floatValue();
            int iv = (int)fv;
            if (fv == (float)((int)fv)) {
                return iv;
            }
            throw new IllegalArgumentException("Can't convert this float value to int without loss: " + fv);
        }
        if (value instanceof BigDecimal) {
            BigDecimal bv = (BigDecimal)value;
            int iv = bv.intValue();
            if (bv.compareTo(BigDecimal.valueOf(iv)) == 0) {
                return iv;
            }
            throw new IllegalArgumentException("Can't convert this BigDecimal value to int without loss: " + bv);
        }
        if (value instanceof BigInteger) {
            BigInteger bv = (BigInteger)value;
            if (bv.compareTo(MIN_INT_AS_BIG_INTEGER) >= 0 && bv.compareTo(MAX_INT_AS_BIG_INTEGER) <= 0) {
                return bv.intValue();
            }
            throw new IllegalArgumentException("Can't convert this BigInteger value to int without loss: " + bv);
        }
        throw new IllegalArgumentException("Can't convert a " + value.getClass().getName() + " to integer number.");
    }

    public static String[] add(String[] a1, String[] a2) {
        String[] r = new String[a1.length + a2.length];
        System.arraycopy(a1, 0, r, 0, a1.length);
        System.arraycopy(a2, 0, r, a1.length, a2.length);
        return r;
    }
}

