/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.babel.postgresql;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.Symbolizable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.ReturnTypes;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SqlBegin
extends SqlCall {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("BEGIN", SqlKind.OTHER_FUNCTION, 32, false, ReturnTypes.BOOLEAN, null, null){

        public SqlCall createCall(@Nullable SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            return new SqlBegin(pos, (SqlNodeList)operands[0]);
        }
    };
    private final SqlNodeList transactionModeList;

    protected SqlBegin(SqlParserPos pos, SqlNodeList transactionModeList) {
        super(pos);
        this.transactionModeList = transactionModeList;
    }

    public SqlOperator getOperator() {
        return OPERATOR;
    }

    public List<SqlNode> getOperandList() {
        return ImmutableList.of((Object)this.transactionModeList);
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("BEGIN");
        this.transactionModeList.unparse(writer, -1, -1);
    }

    public static enum TransactionMode implements Symbolizable
    {
        READ_WRITE,
        READ_ONLY,
        DEFERRABLE,
        NOT_DEFERRABLE,
        ISOLATION_LEVEL_SERIALIZABLE,
        ISOLATION_LEVEL_REPEATABLE_READ,
        ISOLATION_LEVEL_READ_COMMITTED,
        ISOLATION_LEVEL_READ_UNCOMMITTED;


        public String toString() {
            return super.toString().replace("_", " ");
        }
    }
}

