/*
 * Decompiled with CFR 0.152.
 */
package xerial.larray.impl;

import java.io.IOException;

public class OSInfo {
    public static void main(String[] stringArray) {
        if (stringArray.length >= 1) {
            if ("--os".equals(stringArray[0])) {
                System.out.print(OSInfo.getOSName());
                return;
            }
            if ("--arch".equals(stringArray[0])) {
                System.out.print(OSInfo.getArchName());
                return;
            }
        }
        System.out.print(OSInfo.getNativeLibFolderPathForCurrentOS());
    }

    public static String getNativeLibFolderPathForCurrentOS() {
        return OSInfo.getOSName() + "/" + OSInfo.getArchName();
    }

    public static String getOSName() {
        return OSInfo.translateOSNameToFolderName(System.getProperty("os.name"));
    }

    public static String getArchName() {
        String string = System.getProperty("os.arch");
        if (string.startsWith("arm") && System.getProperty("os.name").contains("Linux")) {
            String string2 = System.getProperty("java.home");
            try {
                String[] stringArray = new String[]{"/bin/sh", "-c", "find '" + string2 + "' -name 'libjvm.so' | head -1 | xargs readelf -A | grep 'Tag_ABI_VFP_args: VFP registers'"};
                int n = Runtime.getRuntime().exec(stringArray).waitFor();
                if (n == 0) {
                    return "armhf";
                }
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {}
        } else if (OSInfo.getOSName().equals("Mac") && (string.equals("universal") || string.equals("amd64"))) {
            return "x86_64";
        }
        return OSInfo.translateArchNameToFolderName(string);
    }

    static String translateOSNameToFolderName(String string) {
        if (string.contains("Windows")) {
            return "Windows";
        }
        if (string.contains("Mac")) {
            return "Mac";
        }
        if (string.contains("Linux")) {
            return "Linux";
        }
        return string.replaceAll("\\W", "");
    }

    public static boolean isWindows() {
        return OSInfo.getOSName().contains("Windows");
    }

    static String translateArchNameToFolderName(String string) {
        return string.replaceAll("\\W", "");
    }
}

