/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.creator;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.pinot.segment.spi.creator.SegmentVersion;
import org.apache.pinot.segment.spi.creator.name.FixedSegmentNameGenerator;
import org.apache.pinot.segment.spi.creator.name.NormalizedDateSegmentNameGenerator;
import org.apache.pinot.segment.spi.creator.name.SegmentNameGenerator;
import org.apache.pinot.segment.spi.creator.name.SimpleSegmentNameGenerator;
import org.apache.pinot.segment.spi.creator.name.UploadedRealtimeSegmentNameGenerator;
import org.apache.pinot.segment.spi.index.FieldIndexConfigs;
import org.apache.pinot.segment.spi.index.FieldIndexConfigsUtil;
import org.apache.pinot.segment.spi.index.IndexType;
import org.apache.pinot.segment.spi.index.StandardIndexes;
import org.apache.pinot.segment.spi.index.creator.DictionaryBasedInvertedIndexCreator;
import org.apache.pinot.segment.spi.index.reader.InvertedIndexReader;
import org.apache.pinot.spi.config.table.FieldConfig;
import org.apache.pinot.spi.config.table.IndexConfig;
import org.apache.pinot.spi.config.table.IndexingConfig;
import org.apache.pinot.spi.config.table.SegmentPartitionConfig;
import org.apache.pinot.spi.config.table.SegmentZKPropsConfig;
import org.apache.pinot.spi.config.table.StarTreeIndexConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.ingestion.IngestionConfig;
import org.apache.pinot.spi.data.DateTimeFieldSpec;
import org.apache.pinot.spi.data.DateTimeFormatSpec;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.FileFormat;
import org.apache.pinot.spi.data.readers.RecordReaderConfig;
import org.apache.pinot.spi.utils.IngestionConfigUtils;
import org.apache.pinot.spi.utils.TimestampIndexUtils;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;

public class SegmentGeneratorConfig
implements Serializable {
    public static final String GENERATE_INV_BEFORE_PUSH_DEPREC_PROP = "generate.inverted.index.before.push";
    private final TableConfig _tableConfig;
    private final Schema _schema;
    private final TreeMap<String, String> _customProperties = new TreeMap();
    private final List<String> _columnSortOrder = new ArrayList<String>();
    private String _inputFilePath = null;
    private FileFormat _format = FileFormat.AVRO;
    private String _recordReaderPath = null;
    private String _outDir = null;
    private String _rawTableName = null;
    private String _segmentName = null;
    private String _segmentNamePrefix = null;
    private String _segmentNamePostfix = null;
    private String _segmentTimeColumnName = null;
    private FieldSpec.DataType _segmentTimeColumnDataType = null;
    private TimeUnit _segmentTimeUnit = null;
    private String _segmentCreationTime = null;
    private String _segmentStartTime = null;
    private String _segmentEndTime = null;
    private SegmentVersion _segmentVersion = SegmentVersion.v3;
    private RecordReaderConfig _readerConfig = null;
    private List<StarTreeIndexConfig> _starTreeIndexConfigs = null;
    private boolean _enableDefaultStarTree = false;
    private String _creatorVersion = null;
    private SegmentNameGenerator _segmentNameGenerator = null;
    private SegmentPartitionConfig _segmentPartitionConfig = null;
    private int _uploadedSegmentPartitionId = -1;
    private int _sequenceId = -1;
    private TimeColumnType _timeColumnType = TimeColumnType.EPOCH;
    private DateTimeFormatSpec _dateTimeFormatSpec = null;
    private boolean _onHeap = false;
    private boolean _defaultNullHandlingEnabled = false;
    private boolean _continueOnError = false;
    private boolean _rowTimeValueCheck = false;
    private boolean _segmentTimeValueCheck = true;
    private boolean _failOnEmptySegment = false;
    private boolean _optimizeDictionary = false;
    private boolean _optimizeDictionaryForMetrics = false;
    private boolean _optimizeDictionaryType = false;
    private double _noDictionarySizeRatioThreshold = 0.85;
    private Double _noDictionaryCardinalityRatioThreshold;
    private boolean _realtimeConversion = false;
    private File _consumerDir;
    private final Map<String, FieldIndexConfigs> _indexConfigsByColName;
    private final Map<String, Map<String, String>> _columnProperties = new HashMap<String, Map<String, String>>();
    private SegmentZKPropsConfig _segmentZKPropsConfig;

    public SegmentGeneratorConfig(TableConfig tableConfig, Schema schema) {
        this(tableConfig, schema, false);
    }

    public SegmentGeneratorConfig(TableConfig tableConfig, Schema schema, boolean createInvertedIndex) {
        IngestionConfig ingestionConfig;
        List sortedColumns;
        Preconditions.checkNotNull((Object)tableConfig);
        Preconditions.checkNotNull((Object)schema);
        TimestampIndexUtils.applyTimestampIndex((TableConfig)tableConfig, (Schema)schema);
        this._tableConfig = tableConfig;
        this._schema = schema;
        this.setTableName(tableConfig.getTableName());
        String timeColumnName = null;
        if (tableConfig.getValidationConfig() != null) {
            timeColumnName = tableConfig.getValidationConfig().getTimeColumnName();
        }
        this.setTime(timeColumnName, schema);
        IndexingConfig indexingConfig = tableConfig.getIndexingConfig();
        String segmentVersion = indexingConfig.getSegmentFormatVersion();
        if (segmentVersion != null) {
            this._segmentVersion = SegmentVersion.valueOf(segmentVersion);
        }
        if ((sortedColumns = indexingConfig.getSortedColumn()) != null) {
            this._columnSortOrder.addAll(sortedColumns);
        }
        this._segmentPartitionConfig = indexingConfig.getSegmentPartitionConfig();
        this._defaultNullHandlingEnabled = indexingConfig.isNullHandlingEnabled();
        this._optimizeDictionary = indexingConfig.isOptimizeDictionary();
        this._optimizeDictionaryForMetrics = indexingConfig.isOptimizeDictionaryForMetrics();
        this._optimizeDictionaryType = indexingConfig.isOptimizeDictionaryType();
        this._noDictionarySizeRatioThreshold = indexingConfig.getNoDictionarySizeRatioThreshold();
        this._noDictionaryCardinalityRatioThreshold = indexingConfig.getNoDictionaryCardinalityRatioThreshold();
        this.setStarTreeIndexConfigs(indexingConfig.getStarTreeIndexConfigs());
        this.setEnableDefaultStarTree(indexingConfig.isEnableDefaultStarTree());
        List fieldConfigs = tableConfig.getFieldConfigList();
        if (fieldConfigs != null) {
            for (FieldConfig fieldConfig : fieldConfigs) {
                Map properties = fieldConfig.getProperties();
                if (properties == null) continue;
                this._columnProperties.put(fieldConfig.getName(), Collections.unmodifiableMap(properties));
            }
        }
        if ((ingestionConfig = tableConfig.getIngestionConfig()) != null) {
            this._continueOnError = ingestionConfig.isContinueOnError();
            this._rowTimeValueCheck = ingestionConfig.isRowTimeValueCheck();
            this._segmentTimeValueCheck = ingestionConfig.isSegmentTimeValueCheck();
        }
        this._indexConfigsByColName = FieldIndexConfigsUtil.createIndexConfigsByColName(tableConfig, schema);
        List invertedIndexColumns = indexingConfig.getInvertedIndexColumns();
        if (!createInvertedIndex && CollectionUtils.isNotEmpty((Collection)invertedIndexColumns)) {
            Map customConfigs = tableConfig.getCustomConfig().getCustomConfigs();
            boolean customConfigEnabled = customConfigs != null && Boolean.parseBoolean((String)customConfigs.get(GENERATE_INV_BEFORE_PUSH_DEPREC_PROP));
            boolean indexingConfigEnable = indexingConfig.isCreateInvertedIndexDuringSegmentGeneration();
            if (!customConfigEnabled && !indexingConfigEnable) {
                IndexType<IndexConfig, InvertedIndexReader, DictionaryBasedInvertedIndexCreator> inverted = StandardIndexes.inverted();
                for (String column : invertedIndexColumns) {
                    this._indexConfigsByColName.computeIfPresent(column, (k, v) -> new FieldIndexConfigs.Builder((FieldIndexConfigs)v).undeclare(inverted).build());
                }
            }
        }
    }

    public Map<String, Map<String, String>> getColumnProperties() {
        return Collections.unmodifiableMap(this._columnProperties);
    }

    private void setTime(@Nullable String timeColumnName, Schema schema) {
        DateTimeFieldSpec dateTimeFieldSpec;
        if (timeColumnName != null && (dateTimeFieldSpec = schema.getSpecForTimeColumn(timeColumnName)) != null) {
            this._segmentTimeColumnDataType = dateTimeFieldSpec.getDataType();
            this.setTimeColumnName(dateTimeFieldSpec.getName());
            this.setDateTimeFormatSpec(dateTimeFieldSpec.getFormatSpec());
        }
    }

    public Map<String, String> getCustomProperties() {
        return Collections.unmodifiableMap(this._customProperties);
    }

    public void setCustomProperties(Map<String, String> properties) {
        Preconditions.checkNotNull(properties);
        this._customProperties.putAll(properties);
    }

    public void setDateTimeFormatSpec(DateTimeFormatSpec formatSpec) {
        this._dateTimeFormatSpec = formatSpec;
        if (formatSpec.getTimeFormat() == DateTimeFieldSpec.TimeFormat.SIMPLE_DATE_FORMAT) {
            this._timeColumnType = TimeColumnType.SIMPLE_DATE;
        } else {
            this._segmentTimeUnit = formatSpec.getColumnUnit();
            this._timeColumnType = TimeColumnType.EPOCH;
        }
    }

    public DateTimeFormatSpec getDateTimeFormatSpec() {
        return this._dateTimeFormatSpec;
    }

    public TimeColumnType getTimeColumnType() {
        return this._timeColumnType;
    }

    public List<String> getColumnSortOrder() {
        return Collections.unmodifiableList(this._columnSortOrder);
    }

    public String getInputFilePath() {
        return this._inputFilePath;
    }

    public void setInputFilePath(String inputFilePath) {
        Preconditions.checkNotNull((Object)inputFilePath);
        File inputFile = new File(inputFilePath);
        Preconditions.checkState((boolean)inputFile.exists(), (String)"Input path %s does not exist.", (Object)inputFilePath);
        this._inputFilePath = inputFile.getAbsolutePath();
    }

    public FileFormat getFormat() {
        return this._format;
    }

    public void setFormat(FileFormat format) {
        this._format = format;
    }

    public String getRecordReaderPath() {
        return this._recordReaderPath;
    }

    public void setRecordReaderPath(String recordReaderPath) {
        this._recordReaderPath = recordReaderPath;
    }

    public String getOutDir() {
        return this._outDir;
    }

    public void setOutDir(String dir) {
        Preconditions.checkNotNull((Object)dir);
        File outputDir = new File(dir);
        if (outputDir.exists()) {
            Preconditions.checkState((boolean)outputDir.isDirectory(), (String)"Path: %s is not a directory", (Object)dir);
        } else {
            Preconditions.checkState((boolean)outputDir.mkdirs(), (String)"Cannot create output dir: %s", (Object)dir);
        }
        this._outDir = outputDir.getAbsolutePath();
    }

    public String getTableName() {
        return this._rawTableName;
    }

    public void setTableName(String tableName) {
        this._rawTableName = tableName != null ? TableNameBuilder.extractRawTableName((String)tableName) : null;
    }

    public String getSegmentName() {
        return this._segmentName;
    }

    public void setSegmentName(String segmentName) {
        this._segmentName = segmentName;
    }

    public String getCreatorVersion() {
        return this._creatorVersion;
    }

    public void setCreatorVersion(String creatorVersion) {
        this._creatorVersion = creatorVersion;
    }

    public String getSegmentNamePrefix() {
        return this._segmentNamePrefix;
    }

    public void setSegmentNamePrefix(String segmentNamePrefix) {
        this._segmentNamePrefix = segmentNamePrefix;
    }

    public String getSegmentNamePostfix() {
        return this._segmentNamePostfix;
    }

    public void setSegmentNamePostfix(String postfix) {
        this._segmentNamePostfix = postfix;
    }

    public String getTimeColumnName() {
        return this._segmentTimeColumnName;
    }

    public void setTimeColumnName(String timeColumnName) {
        this._segmentTimeColumnName = timeColumnName;
    }

    public int getUploadedSegmentPartitionId() {
        return this._uploadedSegmentPartitionId;
    }

    public int getSequenceId() {
        return this._sequenceId;
    }

    public void setUploadedSegmentPartitionId(int partitionId) {
        this._uploadedSegmentPartitionId = partitionId;
    }

    public void setSequenceId(int sequenceId) {
        this._sequenceId = sequenceId;
    }

    public TimeUnit getSegmentTimeUnit() {
        return this._segmentTimeUnit;
    }

    public void setSegmentTimeUnit(TimeUnit timeUnit) {
        this._segmentTimeUnit = timeUnit;
    }

    public String getCreationTime() {
        return this._segmentCreationTime;
    }

    public void setCreationTime(String creationTime) {
        this._segmentCreationTime = creationTime;
    }

    public String getStartTime() {
        return this._segmentStartTime;
    }

    public void setStartTime(String startTime) {
        this._segmentStartTime = startTime;
    }

    public String getEndTime() {
        return this._segmentEndTime;
    }

    public void setEndTime(String endTime) {
        this._segmentEndTime = endTime;
    }

    public SegmentVersion getSegmentVersion() {
        return this._segmentVersion;
    }

    public void setSegmentVersion(SegmentVersion segmentVersion) {
        this._segmentVersion = segmentVersion;
    }

    public TableConfig getTableConfig() {
        return this._tableConfig;
    }

    public Schema getSchema() {
        return this._schema;
    }

    public RecordReaderConfig getReaderConfig() {
        return this._readerConfig;
    }

    public void setReaderConfig(RecordReaderConfig readerConfig) {
        this._readerConfig = readerConfig;
    }

    @Nullable
    public List<StarTreeIndexConfig> getStarTreeIndexConfigs() {
        if (this._starTreeIndexConfigs == null) {
            return null;
        }
        return Collections.unmodifiableList(this._starTreeIndexConfigs);
    }

    public void setStarTreeIndexConfigs(List<StarTreeIndexConfig> starTreeIndexConfigs) {
        this._starTreeIndexConfigs = starTreeIndexConfigs;
    }

    public boolean isEnableDefaultStarTree() {
        return this._enableDefaultStarTree;
    }

    public void setEnableDefaultStarTree(boolean enableDefaultStarTree) {
        this._enableDefaultStarTree = enableDefaultStarTree;
    }

    public SegmentNameGenerator getSegmentNameGenerator() {
        String segmentNameGeneratorType;
        if (this._segmentNameGenerator != null) {
            return this._segmentNameGenerator;
        }
        switch (segmentNameGeneratorType = this.inferSegmentNameGeneratorType()) {
            case "fixed": {
                return new FixedSegmentNameGenerator(this._segmentName);
            }
            case "normalizedDate": {
                return new NormalizedDateSegmentNameGenerator(this._rawTableName, this._segmentNamePrefix, false, IngestionConfigUtils.getBatchSegmentIngestionType((TableConfig)this._tableConfig), IngestionConfigUtils.getBatchSegmentIngestionFrequency((TableConfig)this._tableConfig), this._dateTimeFormatSpec, this._segmentNamePostfix);
            }
            case "uploadedRealtime": {
                return new UploadedRealtimeSegmentNameGenerator(this._rawTableName, this._uploadedSegmentPartitionId, Long.parseLong(this._segmentCreationTime), this._segmentNamePrefix, this._segmentNamePostfix);
            }
        }
        return new SimpleSegmentNameGenerator(this._segmentNamePrefix != null ? this._segmentNamePrefix : this._rawTableName, this._segmentNamePostfix);
    }

    public String inferSegmentNameGeneratorType() {
        if (this._segmentName != null) {
            return "fixed";
        }
        if (this._segmentTimeColumnDataType == FieldSpec.DataType.STRING && this._timeColumnType == TimeColumnType.SIMPLE_DATE) {
            return "normalizedDate";
        }
        if (this._uploadedSegmentPartitionId != -1) {
            return "uploadedRealtime";
        }
        return "simple";
    }

    public void setSegmentNameGenerator(SegmentNameGenerator segmentNameGenerator) {
        this._segmentNameGenerator = segmentNameGenerator;
    }

    public boolean isOnHeap() {
        return this._onHeap;
    }

    public void setOnHeap(boolean onHeap) {
        this._onHeap = onHeap;
    }

    public boolean isSkipTimeValueCheck() {
        return !this._segmentTimeValueCheck;
    }

    public void setSkipTimeValueCheck(boolean skipTimeValueCheck) {
        this._segmentTimeValueCheck = !skipTimeValueCheck;
    }

    public List<String> getMetrics() {
        return this.getQualifyingFields(FieldSpec.FieldType.METRIC, true);
    }

    public List<String> getDimensions() {
        return this.getQualifyingFields(FieldSpec.FieldType.DIMENSION, true);
    }

    public List<String> getDateTimeColumnNames() {
        return this.getQualifyingFields(FieldSpec.FieldType.DATE_TIME, true);
    }

    public List<String> getComplexColumnNames() {
        return this.getQualifyingFields(FieldSpec.FieldType.COMPLEX, true);
    }

    public void setSegmentPartitionConfig(SegmentPartitionConfig segmentPartitionConfig) {
        this._segmentPartitionConfig = segmentPartitionConfig;
    }

    public SegmentPartitionConfig getSegmentPartitionConfig() {
        return this._segmentPartitionConfig;
    }

    private List<String> getQualifyingFields(FieldSpec.FieldType type, boolean excludeVirtualColumns) {
        ArrayList<String> fields = new ArrayList<String>();
        for (FieldSpec fieldSpec : this.getSchema().getAllFieldSpecs()) {
            if (excludeVirtualColumns && fieldSpec.isVirtualColumn() || fieldSpec.getFieldType() != type) continue;
            fields.add(fieldSpec.getName());
        }
        Collections.sort(fields);
        return fields;
    }

    @Deprecated
    public boolean isNullHandlingEnabled() {
        return this._defaultNullHandlingEnabled;
    }

    public boolean isDefaultNullHandlingEnabled() {
        return this._defaultNullHandlingEnabled;
    }

    @Deprecated
    public void setNullHandlingEnabled(boolean nullHandlingEnabled) {
        this.setDefaultNullHandlingEnabled(nullHandlingEnabled);
    }

    public void setDefaultNullHandlingEnabled(boolean nullHandlingEnabled) {
        this._defaultNullHandlingEnabled = nullHandlingEnabled;
    }

    public boolean isContinueOnError() {
        return this._continueOnError;
    }

    public void setContinueOnError(boolean continueOnError) {
        this._continueOnError = continueOnError;
    }

    public boolean isRowTimeValueCheck() {
        return this._rowTimeValueCheck;
    }

    public void setRowTimeValueCheck(boolean rowTimeValueCheck) {
        this._rowTimeValueCheck = rowTimeValueCheck;
    }

    public boolean isSegmentTimeValueCheck() {
        return this._segmentTimeValueCheck;
    }

    public void setSegmentTimeValueCheck(boolean segmentTimeValueCheck) {
        this._segmentTimeValueCheck = segmentTimeValueCheck;
    }

    public boolean isOptimizeDictionary() {
        return this._optimizeDictionary;
    }

    public void setOptimizeDictionary(boolean optimizeDictionary) {
        this._optimizeDictionary = optimizeDictionary;
    }

    public boolean isOptimizeDictionaryForMetrics() {
        return this._optimizeDictionaryForMetrics;
    }

    public void setOptimizeDictionaryForMetrics(boolean optimizeDictionaryForMetrics) {
        this._optimizeDictionaryForMetrics = optimizeDictionaryForMetrics;
    }

    public boolean isOptimizeDictionaryType() {
        return this._optimizeDictionaryType;
    }

    public void setOptimizeDictionaryType(boolean optimizeDictionaryType) {
        this._optimizeDictionaryType = optimizeDictionaryType;
    }

    public double getNoDictionarySizeRatioThreshold() {
        return this._noDictionarySizeRatioThreshold;
    }

    public boolean isRealtimeConversion() {
        return this._realtimeConversion;
    }

    public void setRealtimeConversion(boolean realtimeConversion) {
        this._realtimeConversion = realtimeConversion;
    }

    public File getConsumerDir() {
        return this._consumerDir;
    }

    public void setConsumerDir(File consumerDir) {
        this._consumerDir = consumerDir;
    }

    public void setNoDictionarySizeRatioThreshold(double noDictionarySizeRatioThreshold) {
        this._noDictionarySizeRatioThreshold = noDictionarySizeRatioThreshold;
    }

    @Nullable
    public Double getNoDictionaryCardinalityRatioThreshold() {
        return this._noDictionaryCardinalityRatioThreshold;
    }

    public void setNoDictionaryCardinalityRatioThreshold(@Nullable Double noDictionaryCardinalityRatioThreshold) {
        this._noDictionaryCardinalityRatioThreshold = noDictionaryCardinalityRatioThreshold;
    }

    public boolean isFailOnEmptySegment() {
        return this._failOnEmptySegment;
    }

    public void setFailOnEmptySegment(boolean failOnEmptySegment) {
        this._failOnEmptySegment = failOnEmptySegment;
    }

    public SegmentZKPropsConfig getSegmentZKPropsConfig() {
        return this._segmentZKPropsConfig;
    }

    public void setSegmentZKPropsConfig(SegmentZKPropsConfig segmentZKPropsConfig) {
        this._segmentZKPropsConfig = segmentZKPropsConfig;
    }

    public Map<String, FieldIndexConfigs> getIndexConfigsByColName() {
        return this._indexConfigsByColName;
    }

    public static enum TimeColumnType {
        EPOCH,
        SIMPLE_DATE;

    }
}

